/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class AccessibilityCheckResultBaseUtils {
    private AccessibilityCheckResultBaseUtils() {
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForCheck(Iterable<T> results, Class<? extends AccessibilityCheck> checkClass) {
        return AccessibilityCheckResultBaseUtils.getResultsForCheck(results, checkClass, null);
    }

    static <T extends AccessibilityCheckResult> List<T> getResultsForCheck(Iterable<T> results, Class<? extends AccessibilityCheck> checkClass, @Nullable ImmutableBiMap<?, ?> aliases) {
        ArrayList<AccessibilityCheckResult> resultsForCheck = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            Class<? extends AccessibilityCheck> resultCheckClass = result.getSourceCheckClass();
            Object alias = AccessibilityCheckResultBaseUtils.getAlias(resultCheckClass, aliases);
            if (!checkClass.equals(resultCheckClass) && !checkClass.equals(alias)) continue;
            resultsForCheck.add(result);
        }
        return resultsForCheck;
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForType(Iterable<T> results, AccessibilityCheckResult.AccessibilityCheckResultType type) {
        ArrayList<AccessibilityCheckResult> resultsForType = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            if (result.getType() != type) continue;
            resultsForType.add(result);
        }
        return resultsForType;
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForTypes(Iterable<T> results, Set<AccessibilityCheckResult.AccessibilityCheckResultType> types) {
        ArrayList<AccessibilityCheckResult> resultsForTypes = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            if (!types.contains((Object)result.getType())) continue;
            resultsForTypes.add(result);
        }
        return resultsForTypes;
    }

    public static Matcher<AccessibilityCheckResult> matchesTypes(final Matcher<? super AccessibilityCheckResult.AccessibilityCheckResultType> typeMatcher) {
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("result type", typeMatcher){

            @Override
            public boolean matchesSafely(AccessibilityCheckResult result) {
                return typeMatcher.matches((Object)result.getType());
            }
        };
    }

    public static Matcher<AccessibilityCheckResult> matchesChecks(Matcher<?> classMatcher) {
        return AccessibilityCheckResultBaseUtils.matchesChecks(classMatcher, null);
    }

    static Matcher<AccessibilityCheckResult> matchesChecks(final Matcher<?> classMatcher, final @Nullable ImmutableBiMap<?, ?> aliases) {
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("source check", classMatcher){

            @Override
            public boolean matchesSafely(AccessibilityCheckResult result) {
                Class<? extends AccessibilityCheck> checkClass = result.getSourceCheckClass();
                if (classMatcher.matches(checkClass)) {
                    return true;
                }
                Object alias = AccessibilityCheckResultBaseUtils.getAlias(checkClass, aliases);
                return alias != null && classMatcher.matches(alias);
            }
        };
    }

    public static Matcher<AccessibilityCheckResult> matchesCheckNames(Matcher<? super String> classNameMatcher) {
        return AccessibilityCheckResultBaseUtils.matchesCheckNames(classNameMatcher, null);
    }

    static Matcher<AccessibilityCheckResult> matchesCheckNames(final Matcher<? super String> classNameMatcher, final @Nullable ImmutableBiMap<?, ?> aliases) {
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("source check name", classNameMatcher){

            @Override
            public boolean matchesSafely(AccessibilityCheckResult result) {
                Class<? extends AccessibilityCheck> checkClass = result.getSourceCheckClass();
                if (classNameMatcher.matches(checkClass.getSimpleName())) {
                    return true;
                }
                Object alias = AccessibilityCheckResultBaseUtils.getAlias(checkClass, aliases);
                return alias instanceof Class && classNameMatcher.matches(((Class)alias).getSimpleName());
            }
        };
    }

    private static @Nullable Object getAlias(Object obj, @Nullable ImmutableBiMap<?, ?> aliases) {
        if (aliases == null) {
            return null;
        }
        Object alias = aliases.get(obj);
        return alias != null ? alias : aliases.inverse().get(obj);
    }

    static abstract class TypeSafeMemberMatcher<T>
    extends TypeSafeMatcher<T> {
        private static final String DESCRIPTION_FORMAT_STRING = "with %s: ";
        private final String memberDescription;
        private final Matcher<?> matcher;

        public TypeSafeMemberMatcher(String member, Matcher<?> matcher) {
            this.memberDescription = String.format(DESCRIPTION_FORMAT_STRING, member);
            this.matcher = matcher;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText(this.memberDescription);
            this.matcher.describeTo(description);
        }
    }
}

