/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.compat.annotation.UnsupportedAppUsage;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.Patterns;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsHeader;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SmsMessageBase {
    public static final Pattern NAME_ADDR_EMAIL_PATTERN = Pattern.compile("\\s*(\"[^\"]*\"|[^<>\"]+)\\s*<([^<>]+)>\\s*");
    @UnsupportedAppUsage
    protected String mScAddress;
    @UnsupportedAppUsage
    protected SmsAddress mOriginatingAddress;
    protected SmsAddress mRecipientAddress;
    @UnsupportedAppUsage
    protected String mMessageBody;
    protected String mPseudoSubject;
    protected String mEmailFrom;
    protected String mEmailBody;
    protected boolean mIsEmail;
    protected long mScTimeMillis;
    @UnsupportedAppUsage
    protected byte[] mPdu;
    protected byte[] mUserData;
    @UnsupportedAppUsage
    protected SmsHeader mUserDataHeader;
    @UnsupportedAppUsage
    protected boolean mIsMwi;
    @UnsupportedAppUsage
    protected boolean mMwiSense;
    @UnsupportedAppUsage
    protected boolean mMwiDontStore;
    protected int mStatusOnIcc = -1;
    protected int mIndexOnIcc = -1;
    @UnsupportedAppUsage
    public int mMessageRef;

    @UnsupportedAppUsage
    public SmsMessageBase() {
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public String getServiceCenterAddress() {
        return this.mScAddress;
    }

    @UnsupportedAppUsage
    public String getOriginatingAddress() {
        if (this.mOriginatingAddress == null) {
            return null;
        }
        return this.mOriginatingAddress.getAddressString();
    }

    @UnsupportedAppUsage
    public String getDisplayOriginatingAddress() {
        if (this.mIsEmail) {
            return this.mEmailFrom;
        }
        return this.getOriginatingAddress();
    }

    @UnsupportedAppUsage
    public String getMessageBody() {
        return this.mMessageBody;
    }

    public abstract SmsConstants.MessageClass getMessageClass();

    @UnsupportedAppUsage
    public String getDisplayMessageBody() {
        if (this.mIsEmail) {
            return this.mEmailBody;
        }
        return this.getMessageBody();
    }

    @UnsupportedAppUsage
    public String getPseudoSubject() {
        return this.mPseudoSubject == null ? "" : this.mPseudoSubject;
    }

    @UnsupportedAppUsage
    public long getTimestampMillis() {
        return this.mScTimeMillis;
    }

    public boolean isEmail() {
        return this.mIsEmail;
    }

    public String getEmailBody() {
        return this.mEmailBody;
    }

    public String getEmailFrom() {
        return this.mEmailFrom;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public abstract int getProtocolIdentifier();

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public abstract boolean isReplace();

    public abstract boolean isCphsMwiMessage();

    public abstract boolean isMWIClearMessage();

    public abstract boolean isMWISetMessage();

    public abstract boolean isMwiDontStore();

    @UnsupportedAppUsage
    public byte[] getUserData() {
        return this.mUserData;
    }

    @UnsupportedAppUsage
    public SmsHeader getUserDataHeader() {
        return this.mUserDataHeader;
    }

    public byte[] getPdu() {
        return this.mPdu;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public abstract int getStatus();

    @UnsupportedAppUsage
    public abstract boolean isStatusReportMessage();

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public abstract boolean isReplyPathPresent();

    public int getStatusOnIcc() {
        return this.mStatusOnIcc;
    }

    public int getIndexOnIcc() {
        return this.mIndexOnIcc;
    }

    protected void parseMessageBody() {
        if (this.mOriginatingAddress != null && this.mOriginatingAddress.couldBeEmailGateway()) {
            this.extractEmailAddressFromMessageBody();
        }
    }

    private static String extractAddrSpec(String messageHeader) {
        Matcher match = NAME_ADDR_EMAIL_PATTERN.matcher(messageHeader);
        if (match.matches()) {
            return match.group(2);
        }
        return messageHeader;
    }

    public static boolean isEmailAddress(String messageHeader) {
        if (TextUtils.isEmpty(messageHeader)) {
            return false;
        }
        String s = SmsMessageBase.extractAddrSpec(messageHeader);
        Matcher match = Patterns.EMAIL_ADDRESS.matcher(s);
        return match.matches();
    }

    protected void extractEmailAddressFromMessageBody() {
        String[] parts = this.mMessageBody.split("( /)|( )", 2);
        if (parts.length < 2) {
            return;
        }
        this.mEmailFrom = parts[0];
        this.mEmailBody = parts[1];
        this.mIsEmail = SmsMessageBase.isEmailAddress(this.mEmailFrom);
    }

    public static int findNextUnicodePosition(int currentPosition, int byteLimit, CharSequence msgBody) {
        int nextPos = Math.min(currentPosition + byteLimit / 2, msgBody.length());
        if (nextPos < msgBody.length()) {
            BreakIterator breakIterator = BreakIterator.getCharacterInstance();
            breakIterator.setText(msgBody.toString());
            if (!breakIterator.isBoundary(nextPos)) {
                int breakPos = breakIterator.preceding(nextPos);
                while (breakPos + 4 <= nextPos && SmsMessageBase.isRegionalIndicatorSymbol(Character.codePointAt(msgBody, breakPos)) && SmsMessageBase.isRegionalIndicatorSymbol(Character.codePointAt(msgBody, breakPos + 2))) {
                    breakPos += 4;
                }
                if (breakPos > currentPosition) {
                    nextPos = breakPos;
                } else if (Character.isHighSurrogate(msgBody.charAt(nextPos - 1))) {
                    --nextPos;
                }
            }
        }
        return nextPos;
    }

    private static boolean isRegionalIndicatorSymbol(int codePoint) {
        return 127462 <= codePoint && codePoint <= 127487;
    }

    public static GsmAlphabet.TextEncodingDetails calcUnicodeEncodingDetails(CharSequence msgBody) {
        GsmAlphabet.TextEncodingDetails ted = new GsmAlphabet.TextEncodingDetails();
        int octets = msgBody.length() * 2;
        ted.codeUnitSize = 3;
        ted.codeUnitCount = msgBody.length();
        if (octets > 140) {
            int maxUserDataBytesWithHeader = 134;
            if (!SmsMessage.hasEmsSupport() && octets <= 9 * (maxUserDataBytesWithHeader - 2)) {
                maxUserDataBytesWithHeader -= 2;
            }
            int pos = 0;
            int msgCount = 0;
            while (pos < msgBody.length()) {
                int nextPos = SmsMessageBase.findNextUnicodePosition(pos, maxUserDataBytesWithHeader, msgBody);
                if (nextPos == msgBody.length()) {
                    ted.codeUnitsRemaining = pos + maxUserDataBytesWithHeader / 2 - msgBody.length();
                }
                pos = nextPos;
                ++msgCount;
            }
            ted.msgCount = msgCount;
        } else {
            ted.msgCount = 1;
            ted.codeUnitsRemaining = (140 - octets) / 2;
        }
        return ted;
    }

    public String getRecipientAddress() {
        if (this.mRecipientAddress == null) {
            return null;
        }
        return this.mRecipientAddress.getAddressString();
    }

    public static abstract class SubmitPduBase {
        @UnsupportedAppUsage
        public byte[] encodedScAddress;
        @UnsupportedAppUsage
        public byte[] encodedMessage;

        public String toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }
    }
}

