/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.AutofillOptions;
import android.content.ContentCaptureOptions;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.view.ContextThemeWrapper;
import android.view.contentcapture.ContentCaptureManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.policy.PhoneWindow;
import java.lang.ref.WeakReference;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class DecorContext
extends ContextThemeWrapper {
    private PhoneWindow mPhoneWindow;
    private Resources mResources;
    private ContentCaptureManager mContentCaptureManager;
    private WeakReference<Context> mContext;

    @VisibleForTesting
    public DecorContext(Context baseContext, PhoneWindow phoneWindow) {
        super(null, null);
        this.setPhoneWindow(phoneWindow);
        Context displayContext = baseContext.createDisplayContext(phoneWindow.getContext().getDisplayNoVerify());
        this.attachBaseContext(displayContext);
    }

    void setPhoneWindow(PhoneWindow phoneWindow) {
        this.mPhoneWindow = phoneWindow;
        Context context = phoneWindow.getContext();
        this.mContext = new WeakReference<Context>(context);
        this.mResources = context.getResources();
    }

    @Override
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            return this.mPhoneWindow.getWindowManager();
        }
        Context context = (Context)this.mContext.get();
        if ("content_capture".equals(name)) {
            if (context != null && this.mContentCaptureManager == null) {
                this.mContentCaptureManager = (ContentCaptureManager)context.getSystemService(name);
            }
            return this.mContentCaptureManager;
        }
        if ("display".equals(name)) {
            return super.getSystemService(name);
        }
        return context != null ? context.getSystemService(name) : super.getSystemService(name);
    }

    @Override
    public Resources getResources() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            this.mResources = context.getResources();
        }
        return this.mResources;
    }

    @Override
    public AssetManager getAssets() {
        return this.mResources.getAssets();
    }

    @Override
    public AutofillOptions getAutofillOptions() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return context.getAutofillOptions();
        }
        return null;
    }

    @Override
    public ContentCaptureOptions getContentCaptureOptions() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return context.getContentCaptureOptions();
        }
        return null;
    }

    @Override
    public boolean isUiContext() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return context.isUiContext();
        }
        return false;
    }
}

