/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.system.suspend.ISuspendControlService;
import android.system.suspend.WakeLockInfo;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelWakelockStats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class KernelWakelockReader {
    private static final String TAG = "KernelWakelockReader";
    private static int sKernelWakelockUpdateVersion = 0;
    private static final String sWakelockFile = "/proc/wakelocks";
    private static final String sWakeupSourceFile = "/d/wakeup_sources";
    private static final String sSysClassWakeupDir = "/sys/class/wakeup";
    private static final int[] PROC_WAKELOCKS_FORMAT = new int[]{5129, 8201, 9, 9, 9, 8201};
    private static final int[] WAKEUP_SOURCES_FORMAT = new int[]{4105, 8457, 265, 265, 265, 265, 8457};
    private final String[] mProcWakelocksName = new String[3];
    private final long[] mProcWakelocksData = new long[3];
    private ISuspendControlService mSuspendControlService = null;
    private byte[] mKernelWakelockBuffer = new byte[32768];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelWakelockStats readKernelWakelockStats(KernelWakelockStats staleStats) {
        boolean wakeup_sources;
        boolean useSystemSuspend = new File(sSysClassWakeupDir).exists();
        if (useSystemSuspend) {
            this.updateVersion(staleStats);
            if (this.getWakelockStatsFromSystemSuspend(staleStats) == null) {
                Slog.w(TAG, "Failed to get wakelock stats from SystemSuspend");
                return null;
            }
            return this.removeOldStats(staleStats);
        }
        Arrays.fill(this.mKernelWakelockBuffer, (byte)0);
        int len = 0;
        long startTime = SystemClock.uptimeMillis();
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try {
            int cnt;
            FileInputStream is;
            try {
                is = new FileInputStream(sWakelockFile);
                wakeup_sources = false;
            }
            catch (FileNotFoundException e) {
                try {
                    is = new FileInputStream(sWakeupSourceFile);
                    wakeup_sources = true;
                }
                catch (FileNotFoundException e2) {
                    Slog.wtf(TAG, "neither /proc/wakelocks nor /d/wakeup_sources exists");
                    KernelWakelockStats kernelWakelockStats = null;
                    StrictMode.setThreadPolicyMask(oldMask);
                    return kernelWakelockStats;
                }
            }
            while ((cnt = is.read(this.mKernelWakelockBuffer, len, this.mKernelWakelockBuffer.length - len)) > 0) {
                len += cnt;
            }
            is.close();
        }
        catch (IOException e) {
            Slog.wtf(TAG, "failed to read kernel wakelocks", e);
            KernelWakelockStats kernelWakelockStats = null;
            return kernelWakelockStats;
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
        long readTime = SystemClock.uptimeMillis() - startTime;
        if (readTime > 100L) {
            Slog.w(TAG, "Reading wakelock stats took " + readTime + "ms");
        }
        if (len > 0) {
            if (len >= this.mKernelWakelockBuffer.length) {
                Slog.wtf(TAG, "Kernel wake locks exceeded mKernelWakelockBuffer size " + this.mKernelWakelockBuffer.length);
            }
            for (int i = 0; i < len; ++i) {
                if (this.mKernelWakelockBuffer[i] != 0) continue;
                len = i;
                break;
            }
        }
        this.updateVersion(staleStats);
        if (this.getWakelockStatsFromSystemSuspend(staleStats) == null) {
            Slog.w(TAG, "Failed to get Native wakelock stats from SystemSuspend");
        }
        this.parseProcWakelocks(this.mKernelWakelockBuffer, len, wakeup_sources, staleStats);
        return this.removeOldStats(staleStats);
    }

    private KernelWakelockStats getWakelockStatsFromSystemSuspend(KernelWakelockStats staleStats) {
        WakeLockInfo[] wlStats = null;
        if (this.mSuspendControlService == null) {
            try {
                this.mSuspendControlService = ISuspendControlService.Stub.asInterface(ServiceManager.getServiceOrThrow("suspend_control"));
            }
            catch (ServiceManager.ServiceNotFoundException e) {
                Slog.wtf(TAG, "Required service suspend_control not available", e);
                return null;
            }
        }
        try {
            wlStats = this.mSuspendControlService.getWakeLockStats();
            this.updateWakelockStats(wlStats, staleStats);
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "Failed to obtain wakelock stats from ISuspendControlService", e);
            return null;
        }
        return staleStats;
    }

    @VisibleForTesting
    public KernelWakelockStats updateWakelockStats(WakeLockInfo[] wlStats, KernelWakelockStats staleStats) {
        for (WakeLockInfo info : wlStats) {
            if (!staleStats.containsKey(info.name)) {
                staleStats.put(info.name, new KernelWakelockStats.Entry((int)info.activeCount, info.totalTime * 1000L, sKernelWakelockUpdateVersion));
                continue;
            }
            KernelWakelockStats.Entry kwlStats = (KernelWakelockStats.Entry)staleStats.get(info.name);
            kwlStats.mCount = (int)info.activeCount;
            kwlStats.mTotalTime = info.totalTime * 1000L;
            kwlStats.mVersion = sKernelWakelockUpdateVersion;
        }
        return staleStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public KernelWakelockStats parseProcWakelocks(byte[] wlBuffer, int len, boolean wakeup_sources, KernelWakelockStats staleStats) {
        int endIndex;
        int i;
        for (i = 0; i < len && wlBuffer[i] != 10 && wlBuffer[i] != 0; ++i) {
        }
        int startIndex = endIndex = i + 1;
        KernelWakelockReader kernelWakelockReader = this;
        synchronized (kernelWakelockReader) {
            while (endIndex < len) {
                for (endIndex = startIndex; endIndex < len && wlBuffer[endIndex] != 10 && wlBuffer[endIndex] != 0; ++endIndex) {
                }
                if (endIndex > len - 1) break;
                String[] nameStringArray = this.mProcWakelocksName;
                long[] wlData = this.mProcWakelocksData;
                for (int j = startIndex; j < endIndex; ++j) {
                    if ((wlBuffer[j] & 0x80) == 0) continue;
                    wlBuffer[j] = 63;
                }
                boolean parsed = Process.parseProcLine(wlBuffer, startIndex, endIndex, wakeup_sources ? WAKEUP_SOURCES_FORMAT : PROC_WAKELOCKS_FORMAT, nameStringArray, wlData, null);
                String name = nameStringArray[0].trim();
                int count = (int)wlData[1];
                long totalTime = wakeup_sources ? wlData[2] * 1000L : (wlData[2] + 500L) / 1000L;
                if (parsed && name.length() > 0) {
                    if (!staleStats.containsKey(name)) {
                        staleStats.put(name, new KernelWakelockStats.Entry(count, totalTime, sKernelWakelockUpdateVersion));
                    } else {
                        KernelWakelockStats.Entry kwlStats = (KernelWakelockStats.Entry)staleStats.get(name);
                        if (kwlStats.mVersion == sKernelWakelockUpdateVersion) {
                            kwlStats.mCount += count;
                            kwlStats.mTotalTime += totalTime;
                        } else {
                            kwlStats.mCount = count;
                            kwlStats.mTotalTime = totalTime;
                            kwlStats.mVersion = sKernelWakelockUpdateVersion;
                        }
                    }
                } else if (!parsed) {
                    try {
                        Slog.wtf(TAG, "Failed to parse proc line: " + new String(wlBuffer, startIndex, endIndex - startIndex));
                    }
                    catch (Exception e) {
                        Slog.wtf(TAG, "Failed to parse proc line!");
                    }
                }
                startIndex = endIndex + 1;
            }
            return staleStats;
        }
    }

    @VisibleForTesting
    public KernelWakelockStats updateVersion(KernelWakelockStats staleStats) {
        staleStats.kernelWakelockVersion = ++sKernelWakelockUpdateVersion;
        return staleStats;
    }

    @VisibleForTesting
    public KernelWakelockStats removeOldStats(KernelWakelockStats staleStats) {
        Iterator itr = staleStats.values().iterator();
        while (itr.hasNext()) {
            if (((KernelWakelockStats.Entry)itr.next()).mVersion == sKernelWakelockUpdateVersion) continue;
            itr.remove();
        }
        return staleStats;
    }
}

