/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.graphics.Insets;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.LocalLog;
import android.util.Log;
import android.util.TimeUtils;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ChildContentCaptureSession;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureEvent;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ContentCaptureManager;
import android.view.contentcapture.ContentCaptureSession;
import android.view.contentcapture.IContentCaptureDirectManager;
import android.view.contentcapture.IContentCaptureManager;
import android.view.contentcapture.ViewNode;
import com.android.internal.os.IResultReceiver;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MainContentCaptureSession
extends ContentCaptureSession {
    private static final String TAG = MainContentCaptureSession.class.getSimpleName();
    private static final boolean FORCE_FLUSH = true;
    private static final int MSG_FLUSH = 1;
    public static final String EXTRA_BINDER = "binder";
    public static final String EXTRA_ENABLED_STATE = "enabled";
    private final AtomicBoolean mDisabled = new AtomicBoolean(false);
    private final Context mContext;
    private final ContentCaptureManager mManager;
    private final Handler mHandler;
    private final IContentCaptureManager mSystemServerInterface;
    private IContentCaptureDirectManager mDirectServiceInterface;
    private IBinder.DeathRecipient mDirectServiceVulture;
    private int mState = 0;
    private IBinder mApplicationToken;
    private ComponentName mComponentName;
    private ArrayList<ContentCaptureEvent> mEvents;
    private long mNextFlush;
    private boolean mNextFlushForTextChanged = false;
    private final LocalLog mFlushHistory;
    private final SessionStateReceiver mSessionStateReceiver;

    protected MainContentCaptureSession(Context context, ContentCaptureManager manager, Handler handler, IContentCaptureManager systemServerInterface) {
        this.mContext = context;
        this.mManager = manager;
        this.mHandler = handler;
        this.mSystemServerInterface = systemServerInterface;
        int logHistorySize = this.mManager.mOptions.logHistorySize;
        this.mFlushHistory = logHistorySize > 0 ? new LocalLog(logHistorySize) : null;
        this.mSessionStateReceiver = new SessionStateReceiver(this);
    }

    @Override
    MainContentCaptureSession getMainCaptureSession() {
        return this;
    }

    @Override
    ContentCaptureSession newChild(ContentCaptureContext clientContext) {
        ChildContentCaptureSession child = new ChildContentCaptureSession(this, clientContext);
        this.notifyChildSessionStarted(this.mId, child.mId, clientContext);
        return child;
    }

    void start(IBinder token, ComponentName component, int flags) {
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "start(): token=" + token + ", comp=" + ComponentName.flattenToShortString(component));
        }
        if (this.hasStarted()) {
            if (ContentCaptureHelper.sDebug) {
                Log.d(TAG, "ignoring handleStartSession(" + token + "/" + ComponentName.flattenToShortString(component) + " while on state " + MainContentCaptureSession.getStateAsString(this.mState));
            }
            return;
        }
        this.mState = 1;
        this.mApplicationToken = token;
        this.mComponentName = component;
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleStartSession(): token=" + token + ", act=" + this.getDebugState() + ", id=" + this.mId);
        }
        try {
            this.mSystemServerInterface.startSession(this.mApplicationToken, component, this.mId, flags, this.mSessionStateReceiver);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error starting session for " + component.flattenToShortString() + ": " + e);
        }
    }

    @Override
    void onDestroy() {
        this.mHandler.removeMessages(1);
        this.mHandler.post(() -> this.destroySession());
    }

    private void onSessionStarted(int resultCode, IBinder binder) {
        if (binder != null) {
            this.mDirectServiceInterface = IContentCaptureDirectManager.Stub.asInterface(binder);
            this.mDirectServiceVulture = () -> {
                Log.w(TAG, "Keeping session " + this.mId + " when service died");
                this.mState = 1024;
                this.mDisabled.set(true);
            };
            try {
                binder.linkToDeath(this.mDirectServiceVulture, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to link to death on " + binder + ": " + e);
            }
        }
        if ((resultCode & 4) != 0) {
            this.resetSession(resultCode);
        } else {
            this.mState = resultCode;
            this.mDisabled.set(false);
            this.flushIfNeeded(7);
        }
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleSessionStarted() result: id=" + this.mId + " resultCode=" + resultCode + ", state=" + MainContentCaptureSession.getStateAsString(this.mState) + ", disabled=" + this.mDisabled.get() + ", binder=" + binder + ", events=" + (this.mEvents == null ? 0 : this.mEvents.size()));
        }
    }

    private void sendEvent(ContentCaptureEvent event) {
        this.sendEvent(event, false);
    }

    private void sendEvent(ContentCaptureEvent event, boolean forceFlush) {
        int flushReason;
        int numberEvents;
        boolean bufferEvent;
        ContentCaptureEvent lastEvent;
        int eventType = event.getType();
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleSendEvent(" + this.getDebugState() + "): " + event);
        }
        if (!this.hasStarted() && eventType != -1 && eventType != 6) {
            Log.v(TAG, "handleSendEvent(" + this.getDebugState() + ", " + ContentCaptureEvent.getTypeAsString(eventType) + "): dropping because session not started yet");
            return;
        }
        if (this.mDisabled.get()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleSendEvent(): ignoring when disabled");
            }
            return;
        }
        int maxBufferSize = this.mManager.mOptions.maxBufferSize;
        if (this.mEvents == null) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleSendEvent(): creating buffer for " + maxBufferSize + " events");
            }
            this.mEvents = new ArrayList(maxBufferSize);
        }
        boolean addEvent = true;
        if (!this.mEvents.isEmpty() && eventType == 3 && (lastEvent = this.mEvents.get(this.mEvents.size() - 1)).getType() == 3 && lastEvent.getId().equals(event.getId())) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "Buffering VIEW_TEXT_CHANGED event, updated text=" + ContentCaptureHelper.getSanitizedString(event.getText()));
            }
            lastEvent.mergeEvent(event);
            addEvent = false;
        }
        if (!this.mEvents.isEmpty() && eventType == 2 && (lastEvent = this.mEvents.get(this.mEvents.size() - 1)).getType() == 2 && event.getSessionId() == lastEvent.getSessionId()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "Buffering TYPE_VIEW_DISAPPEARED events for session " + lastEvent.getSessionId());
            }
            lastEvent.mergeEvent(event);
            addEvent = false;
        }
        if (addEvent) {
            this.mEvents.add(event);
        }
        boolean bl = bufferEvent = (numberEvents = this.mEvents.size()) < maxBufferSize;
        if (bufferEvent && !forceFlush) {
            int flushReason2;
            if (eventType == 3) {
                this.mNextFlushForTextChanged = true;
                flushReason2 = 6;
            } else {
                if (this.mNextFlushForTextChanged) {
                    if (ContentCaptureHelper.sVerbose) {
                        Log.i(TAG, "Not scheduling flush because next flush is for text changed");
                    }
                    return;
                }
                flushReason2 = 5;
            }
            this.scheduleFlush(flushReason2, true);
            return;
        }
        if (this.mState != 2 && numberEvents >= maxBufferSize) {
            if (ContentCaptureHelper.sDebug) {
                Log.d(TAG, "Closing session for " + this.getDebugState() + " after " + numberEvents + " delayed events");
            }
            this.resetSession(132);
            return;
        }
        switch (eventType) {
            case -1: {
                flushReason = 3;
                break;
            }
            case -2: {
                flushReason = 4;
                break;
            }
            default: {
                flushReason = 1;
            }
        }
        this.flush(flushReason);
    }

    private boolean hasStarted() {
        return this.mState != 0;
    }

    private void scheduleFlush(int reason, boolean checkExisting) {
        int flushFrequencyMs;
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleScheduleFlush(" + this.getDebugState(reason) + ", checkExisting=" + checkExisting);
        }
        if (!this.hasStarted()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleScheduleFlush(): session not started yet");
            }
            return;
        }
        if (this.mDisabled.get()) {
            Log.e(TAG, "handleScheduleFlush(" + this.getDebugState(reason) + "): should not be called when disabled. events=" + (this.mEvents == null ? null : Integer.valueOf(this.mEvents.size())));
            return;
        }
        if (checkExisting && this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
        if (reason == 6) {
            flushFrequencyMs = this.mManager.mOptions.textChangeFlushingFrequencyMs;
        } else {
            if (reason != 5 && ContentCaptureHelper.sDebug) {
                Log.d(TAG, "handleScheduleFlush(" + this.getDebugState(reason) + "): not a timeout reason because mDirectServiceInterface is not ready yet");
            }
            flushFrequencyMs = this.mManager.mOptions.idleFlushingFrequencyMs;
        }
        this.mNextFlush = System_Delegate.currentTimeMillis() + (long)flushFrequencyMs;
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleScheduleFlush(): scheduled to flush in " + flushFrequencyMs + "ms: " + TimeUtils.logTimeOfDay(this.mNextFlush));
        }
        this.mHandler.postDelayed(() -> this.flushIfNeeded(reason), 1, (long)flushFrequencyMs);
    }

    private void flushIfNeeded(int reason) {
        if (this.mEvents == null || this.mEvents.isEmpty()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "Nothing to flush");
            }
            return;
        }
        this.flush(reason);
    }

    @Override
    void flush(int reason) {
        if (this.mEvents == null) {
            return;
        }
        if (this.mDisabled.get()) {
            Log.e(TAG, "handleForceFlush(" + this.getDebugState(reason) + "): should not be when disabled");
            return;
        }
        if (this.mDirectServiceInterface == null) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleForceFlush(" + this.getDebugState(reason) + "): hold your horses, client not ready: " + this.mEvents);
            }
            if (!this.mHandler.hasMessages(1)) {
                this.scheduleFlush(reason, false);
            }
            return;
        }
        this.mNextFlushForTextChanged = false;
        int numberEvents = this.mEvents.size();
        String reasonString = MainContentCaptureSession.getFlushReasonAsString(reason);
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "Flushing " + numberEvents + " event(s) for " + this.getDebugState(reason));
        }
        if (this.mFlushHistory != null) {
            String logRecord = "r=" + reasonString + " s=" + numberEvents + " m=" + this.mManager.mOptions.maxBufferSize + " i=" + this.mManager.mOptions.idleFlushingFrequencyMs;
            this.mFlushHistory.log(logRecord);
        }
        try {
            this.mHandler.removeMessages(1);
            ParceledListSlice<ContentCaptureEvent> events = this.clearEvents();
            this.mDirectServiceInterface.sendEvents(events, reason, this.mManager.mOptions);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error sending " + numberEvents + " for " + this.getDebugState() + ": " + e);
        }
    }

    @Override
    public void updateContentCaptureContext(ContentCaptureContext context) {
        this.notifyContextUpdated(this.mId, context);
    }

    private ParceledListSlice<ContentCaptureEvent> clearEvents() {
        List events = this.mEvents == null ? Collections.emptyList() : this.mEvents;
        this.mEvents = null;
        return new ParceledListSlice<ContentCaptureEvent>(events);
    }

    private void destroySession() {
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "Destroying session (ctx=" + this.mContext + ", id=" + this.mId + ") with " + (this.mEvents == null ? 0 : this.mEvents.size()) + " event(s) for " + this.getDebugState());
        }
        try {
            this.mSystemServerInterface.finishSession(this.mId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error destroying system-service session " + this.mId + " for " + this.getDebugState() + ": " + e);
        }
        if (this.mDirectServiceInterface != null) {
            this.mDirectServiceInterface.asBinder().unlinkToDeath(this.mDirectServiceVulture, 0);
        }
        this.mDirectServiceInterface = null;
    }

    private void resetSession(int newState) {
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleResetSession(" + this.getActivityName() + "): from " + MainContentCaptureSession.getStateAsString(this.mState) + " to " + MainContentCaptureSession.getStateAsString(newState));
        }
        this.mState = newState;
        this.mDisabled.set((newState & 4) != 0);
        this.mApplicationToken = null;
        this.mComponentName = null;
        this.mEvents = null;
        if (this.mDirectServiceInterface != null) {
            this.mDirectServiceInterface.asBinder().unlinkToDeath(this.mDirectServiceVulture, 0);
        }
        this.mDirectServiceInterface = null;
        this.mHandler.removeMessages(1);
    }

    @Override
    void internalNotifyViewAppeared(ViewNode.ViewStructureImpl node) {
        this.notifyViewAppeared(this.mId, node);
    }

    @Override
    void internalNotifyViewDisappeared(AutofillId id2) {
        this.notifyViewDisappeared(this.mId, id2);
    }

    @Override
    void internalNotifyViewTextChanged(AutofillId id2, CharSequence text) {
        this.notifyViewTextChanged(this.mId, id2, text);
    }

    @Override
    void internalNotifyViewInsetsChanged(Insets viewInsets) {
        this.notifyViewInsetsChanged(this.mId, viewInsets);
    }

    @Override
    public void internalNotifyViewTreeEvent(boolean started) {
        this.notifyViewTreeEvent(this.mId, started);
    }

    @Override
    public void internalNotifySessionResumed() {
        this.notifySessionResumed(this.mId);
    }

    @Override
    public void internalNotifySessionPaused() {
        this.notifySessionPaused(this.mId);
    }

    @Override
    boolean isContentCaptureEnabled() {
        return super.isContentCaptureEnabled() && this.mManager.isContentCaptureEnabled();
    }

    boolean isDisabled() {
        return this.mDisabled.get();
    }

    boolean setDisabled(boolean disabled) {
        return this.mDisabled.compareAndSet(!disabled, disabled);
    }

    void notifyChildSessionStarted(int parentSessionId, int childSessionId, ContentCaptureContext clientContext) {
        this.sendEvent(new ContentCaptureEvent(childSessionId, -1).setParentSessionId(parentSessionId).setClientContext(clientContext), true);
    }

    void notifyChildSessionFinished(int parentSessionId, int childSessionId) {
        this.sendEvent(new ContentCaptureEvent(childSessionId, -2).setParentSessionId(parentSessionId), true);
    }

    void notifyViewAppeared(int sessionId, ViewNode.ViewStructureImpl node) {
        this.sendEvent(new ContentCaptureEvent(sessionId, 1).setViewNode(node.mNode));
    }

    public void notifyViewDisappeared(int sessionId, AutofillId id2) {
        this.sendEvent(new ContentCaptureEvent(sessionId, 2).setAutofillId(id2));
    }

    void notifyViewTextChanged(int sessionId, AutofillId id2, CharSequence text) {
        this.sendEvent(new ContentCaptureEvent(sessionId, 3).setAutofillId(id2).setText(text));
    }

    public void notifyViewInsetsChanged(int sessionId, Insets viewInsets) {
        this.sendEvent(new ContentCaptureEvent(sessionId, 9).setInsets(viewInsets));
    }

    public void notifyViewTreeEvent(int sessionId, boolean started) {
        int type = started ? 4 : 5;
        this.sendEvent(new ContentCaptureEvent(sessionId, type), true);
    }

    void notifySessionResumed(int sessionId) {
        this.sendEvent(new ContentCaptureEvent(sessionId, 7), true);
    }

    void notifySessionPaused(int sessionId) {
        this.sendEvent(new ContentCaptureEvent(sessionId, 8), true);
    }

    void notifyContextUpdated(int sessionId, ContentCaptureContext context) {
        this.sendEvent(new ContentCaptureEvent(sessionId, 6).setClientContext(context));
    }

    @Override
    void dump(String prefix, PrintWriter pw) {
        super.dump(prefix, pw);
        pw.print(prefix);
        pw.print("mContext: ");
        pw.println(this.mContext);
        pw.print(prefix);
        pw.print("user: ");
        pw.println(this.mContext.getUserId());
        if (this.mDirectServiceInterface != null) {
            pw.print(prefix);
            pw.print("mDirectServiceInterface: ");
            pw.println(this.mDirectServiceInterface);
        }
        pw.print(prefix);
        pw.print("mDisabled: ");
        pw.println(this.mDisabled.get());
        pw.print(prefix);
        pw.print("isEnabled(): ");
        pw.println(this.isContentCaptureEnabled());
        pw.print(prefix);
        pw.print("state: ");
        pw.println(MainContentCaptureSession.getStateAsString(this.mState));
        if (this.mApplicationToken != null) {
            pw.print(prefix);
            pw.print("app token: ");
            pw.println(this.mApplicationToken);
        }
        if (this.mComponentName != null) {
            pw.print(prefix);
            pw.print("component name: ");
            pw.println(this.mComponentName.flattenToShortString());
        }
        if (this.mEvents != null && !this.mEvents.isEmpty()) {
            int numberEvents = this.mEvents.size();
            pw.print(prefix);
            pw.print("buffered events: ");
            pw.print(numberEvents);
            pw.print('/');
            pw.println(this.mManager.mOptions.maxBufferSize);
            if (ContentCaptureHelper.sVerbose && numberEvents > 0) {
                String prefix3 = prefix + "  ";
                for (int i = 0; i < numberEvents; ++i) {
                    ContentCaptureEvent event = this.mEvents.get(i);
                    pw.print(prefix3);
                    pw.print(i);
                    pw.print(": ");
                    event.dump(pw);
                    pw.println();
                }
            }
            pw.print(prefix);
            pw.print("mNextFlushForTextChanged: ");
            pw.println(this.mNextFlushForTextChanged);
            pw.print(prefix);
            pw.print("flush frequency: ");
            if (this.mNextFlushForTextChanged) {
                pw.println(this.mManager.mOptions.textChangeFlushingFrequencyMs);
            } else {
                pw.println(this.mManager.mOptions.idleFlushingFrequencyMs);
            }
            pw.print(prefix);
            pw.print("next flush: ");
            TimeUtils.formatDuration(this.mNextFlush - System_Delegate.currentTimeMillis(), pw);
            pw.print(" (");
            pw.print(TimeUtils.logTimeOfDay(this.mNextFlush));
            pw.println(")");
        }
        if (this.mFlushHistory != null) {
            pw.print(prefix);
            pw.println("flush history:");
            this.mFlushHistory.reverseDump(null, pw, null);
            pw.println();
        } else {
            pw.print(prefix);
            pw.println("not logging flush history");
        }
        super.dump(prefix, pw);
    }

    private String getActivityName() {
        return this.mComponentName == null ? "pkg:" + this.mContext.getPackageName() : "act:" + this.mComponentName.flattenToShortString();
    }

    private String getDebugState() {
        return this.getActivityName() + " [state=" + MainContentCaptureSession.getStateAsString(this.mState) + ", disabled=" + this.mDisabled.get() + "]";
    }

    private String getDebugState(int reason) {
        return this.getDebugState() + ", reason=" + MainContentCaptureSession.getFlushReasonAsString(reason);
    }

    private static class SessionStateReceiver
    extends IResultReceiver.Stub {
        private final WeakReference<MainContentCaptureSession> mMainSession;

        SessionStateReceiver(MainContentCaptureSession session) {
            this.mMainSession = new WeakReference<MainContentCaptureSession>(session);
        }

        @Override
        public void send(int resultCode, Bundle resultData) {
            IBinder binder;
            MainContentCaptureSession mainSession = (MainContentCaptureSession)this.mMainSession.get();
            if (mainSession == null) {
                Log.w(TAG, "received result after mina session released");
                return;
            }
            if (resultData != null) {
                boolean hasEnabled = resultData.getBoolean(MainContentCaptureSession.EXTRA_ENABLED_STATE);
                if (hasEnabled) {
                    boolean disabled = resultCode == 2;
                    mainSession.mDisabled.set(disabled);
                    return;
                }
                binder = resultData.getBinder(MainContentCaptureSession.EXTRA_BINDER);
                if (binder == null) {
                    Log.wtf(TAG, "No binder extra result");
                    mainSession.mHandler.post(() -> mainSession.resetSession(260));
                    return;
                }
            } else {
                binder = null;
            }
            mainSession.mHandler.post(() -> mainSession.onSessionStarted(resultCode, binder));
        }
    }
}

