/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.ScrollCaptureClient;
import android.view.Surface;

public class ScrollCaptureSession {
    private final Surface mSurface;
    private final Rect mScrollBounds;
    private final Point mPositionInWindow;
    private ScrollCaptureClient mClient;

    public ScrollCaptureSession(Surface surface, Rect scrollBounds, Point positionInWindow, ScrollCaptureClient client) {
        this.mSurface = surface;
        this.mScrollBounds = scrollBounds;
        this.mPositionInWindow = positionInWindow;
        this.mClient = client;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public Rect getScrollBounds() {
        return this.mScrollBounds;
    }

    public Point getPositionInWindow() {
        return this.mPositionInWindow;
    }

    public void notifyBufferSent(long frameNumber, Rect capturedArea) {
        if (this.mClient != null) {
            this.mClient.onRequestImageCompleted(frameNumber, capturedArea);
        }
    }

    public void disconnect() {
        this.mClient = null;
        if (this.mSurface.isValid()) {
            this.mSurface.release();
        }
    }
}

