/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class DebugUtils {
    public static boolean isObjectSelected(Object object) {
        boolean match = false;
        String s = System.getenv("ANDROID_OBJECT_FILTER");
        if (s != null && s.length() > 0) {
            String[] selectors = s.split("@");
            if (object.getClass().getSimpleName().matches(selectors[0])) {
                for (int i = 1; i < selectors.length; ++i) {
                    String[] pair = selectors[i].split("=");
                    Class<?> klass = object.getClass();
                    try {
                        Method declaredMethod = null;
                        Class<?> parent = klass;
                        do {
                            declaredMethod = parent.getDeclaredMethod("get" + pair[0].substring(0, 1).toUpperCase(Locale.ROOT) + pair[0].substring(1), null);
                        } while ((parent = klass.getSuperclass()) != null && declaredMethod == null);
                        if (declaredMethod == null) continue;
                        Object value = declaredMethod.invoke(object, (Object[])null);
                        match |= (value != null ? value.toString() : "null").matches(pair[1]);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return match;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static void buildShortClassTag(Object cls, StringBuilder out) {
        if (cls == null) {
            out.append("null");
        } else {
            int end;
            String simpleName = cls.getClass().getSimpleName();
            if ((simpleName == null || simpleName.isEmpty()) && (end = (simpleName = cls.getClass().getName()).lastIndexOf(46)) > 0) {
                simpleName = simpleName.substring(end + 1);
            }
            out.append(simpleName);
            out.append('{');
            out.append(Integer.toHexString(System.identityHashCode(cls)));
        }
    }

    public static void printSizeValue(PrintWriter pw, long number) {
        float result = number;
        String suffix = "";
        if (result > 900.0f) {
            suffix = "KB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "MB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "GB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "TB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "PB";
            result /= 1024.0f;
        }
        String value = result < 1.0f ? String.format("%.2f", Float.valueOf(result)) : (result < 10.0f ? String.format("%.1f", Float.valueOf(result)) : (result < 100.0f ? String.format("%.0f", Float.valueOf(result)) : String.format("%.0f", Float.valueOf(result))));
        pw.print(value);
        pw.print(suffix);
    }

    public static String sizeValueToString(long number, StringBuilder outBuilder) {
        if (outBuilder == null) {
            outBuilder = new StringBuilder(32);
        }
        float result = number;
        String suffix = "";
        if (result > 900.0f) {
            suffix = "KB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "MB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "GB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "TB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "PB";
            result /= 1024.0f;
        }
        String value = result < 1.0f ? String.format("%.2f", Float.valueOf(result)) : (result < 10.0f ? String.format("%.1f", Float.valueOf(result)) : (result < 100.0f ? String.format("%.0f", Float.valueOf(result)) : String.format("%.0f", Float.valueOf(result))));
        outBuilder.append(value);
        outBuilder.append(suffix);
        return outBuilder.toString();
    }

    public static String valueToString(Class<?> clazz, String prefix, int value) {
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !field.getType().equals(Integer.TYPE) || !field.getName().startsWith(prefix)) continue;
            try {
                if (value != field.getInt(null)) continue;
                return DebugUtils.constNameWithoutPrefix(prefix, field);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return Integer.toString(value);
    }

    public static String flagsToString(Class<?> clazz, String prefix, int flags) {
        StringBuilder res = new StringBuilder();
        boolean flagsWasZero = flags == 0;
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !field.getType().equals(Integer.TYPE) || !field.getName().startsWith(prefix)) continue;
            try {
                int value = field.getInt(null);
                if (value == 0 && flagsWasZero) {
                    return DebugUtils.constNameWithoutPrefix(prefix, field);
                }
                if (value == 0 || (flags & value) != value) continue;
                flags &= ~value;
                res.append(DebugUtils.constNameWithoutPrefix(prefix, field)).append('|');
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (flags != 0 || res.length() == 0) {
            res.append(Integer.toHexString(flags));
        } else {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString();
    }

    private static String constNameWithoutPrefix(String prefix, Field field) {
        return field.getName().substring(prefix.length());
    }

    public static List<String> callersWithin(Class<?> cls, int offset) {
        List<String> result = Arrays.stream(Thread.currentThread().getStackTrace()).skip(offset + 3).filter(st -> st.getClassName().startsWith(cls.getName())).map(StackTraceElement::getMethodName).collect(Collectors.toList());
        Collections.reverse(result);
        return result;
    }
}

