/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsException;
import android.telephony.ims.RcsUceAdapter;
import android.telephony.ims.RegistrationManager;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsRcsController;
import android.telephony.ims.feature.RcsFeature;
import android.util.Log;
import com.android.internal.telephony.IIntegerConsumer;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ImsRcsManager {
    private static final String TAG = "ImsRcsManager";
    public static final String ACTION_SHOW_CAPABILITY_DISCOVERY_OPT_IN = "android.telephony.ims.action.SHOW_CAPABILITY_DISCOVERY_OPT_IN";
    private final int mSubId;
    private final Context mContext;

    public ImsRcsManager(Context context, int subId) {
        this.mSubId = subId;
        this.mContext = context;
    }

    public RcsUceAdapter getUceAdapter() {
        return new RcsUceAdapter(this.mContext, this.mSubId);
    }

    public void registerImsRegistrationCallback(Executor executor, RegistrationManager.RegistrationCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "Register registration callback: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        c.setExecutor(executor);
        try {
            imsRcsController.registerImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterImsRegistrationCallback(RegistrationManager.RegistrationCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "Unregister registration callback: IImsRcsController is null");
            throw new IllegalStateException("Cannot find remote IMS service");
        }
        try {
            imsRcsController.unregisterImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void getRegistrationState(final Executor executor, final Consumer<Integer> stateCallback) {
        if (stateCallback == null) {
            throw new IllegalArgumentException("Must include a non-null stateCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "Get registration state error: IImsRcsController is null");
            throw new IllegalStateException("Cannot find remote IMS service");
        }
        try {
            imsRcsController.getImsRcsRegistrationState(this.mSubId, new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> stateCallback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void getRegistrationTransportType(final Executor executor, final Consumer<Integer> transportTypeCallback) {
        if (transportTypeCallback == null) {
            throw new IllegalArgumentException("Must include a non-null transportTypeCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "Get registration transport type error: IImsRcsController is null");
            throw new IllegalStateException("Cannot find remote IMS service");
        }
        try {
            imsRcsController.getImsRcsRegistrationTransportType(this.mSubId, new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> transportTypeCallback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void registerRcsAvailabilityCallback(Executor executor, AvailabilityCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null AvailabilityCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "Register availability callback: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        c.setExecutor(executor);
        try {
            imsRcsController.registerRcsAvailabilityCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#registerRcsAvailabilityCallback", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    public void unregisterRcsAvailabilityCallback(AvailabilityCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null AvailabilityCallback.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "Unregister availability callback: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        try {
            imsRcsController.unregisterRcsAvailabilityCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#unregisterRcsAvailabilityCallback", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    public boolean isCapable(int capability, int radioTech) throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "isCapable: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        try {
            return imsRcsController.isCapable(this.mSubId, capability, radioTech);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#isCapable", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    public boolean isAvailable(int capability) throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "isAvailable: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        try {
            return imsRcsController.isAvailable(this.mSubId, capability);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#isAvailable", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    private IImsRcsController getIImsRcsController() {
        IBinder binder = TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyImsServiceRegisterer().get();
        return IImsRcsController.Stub.asInterface(binder);
    }

    public static class AvailabilityCallback {
        private final CapabilityBinder mBinder = new CapabilityBinder(this);

        public void onAvailabilityChanged(RcsFeature.RcsImsCapabilities capabilities) {
        }

        public IImsCapabilityCallback getBinder() {
            return this.mBinder;
        }

        private void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CapabilityBinder
        extends IImsCapabilityCallback.Stub {
            private final AvailabilityCallback mLocalCallback;
            private Executor mExecutor;

            CapabilityBinder(AvailabilityCallback c) {
                this.mLocalCallback = c;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesStatusChanged(int config) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onAvailabilityChanged(new RcsFeature.RcsImsCapabilities(config)));
                }
                finally {
                    CapabilityBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            @Override
            public void onQueryCapabilityConfiguration(int capability, int radioTech, boolean isEnabled) {
            }

            @Override
            public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }
}

