/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.SystemServiceRegistry;
import android.os.TelephonyServiceManager;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.euicc.EuiccCardManager;
import android.telephony.euicc.EuiccManager;
import android.telephony.ims.ImsManager;
import com.android.internal.util.Preconditions;

public class TelephonyFrameworkInitializer {
    private static volatile TelephonyServiceManager sTelephonyServiceManager;

    private TelephonyFrameworkInitializer() {
    }

    public static void setTelephonyServiceManager(TelephonyServiceManager telephonyServiceManager) {
        Preconditions.checkState(sTelephonyServiceManager == null, "setTelephonyServiceManager called twice!");
        sTelephonyServiceManager = Preconditions.checkNotNull(telephonyServiceManager);
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("phone", TelephonyManager.class, context -> new TelephonyManager(context));
        SystemServiceRegistry.registerContextAwareService("telephony_subscription_service", SubscriptionManager.class, context -> new SubscriptionManager(context));
        SystemServiceRegistry.registerContextAwareService("carrier_config", CarrierConfigManager.class, context -> new CarrierConfigManager(context));
        SystemServiceRegistry.registerContextAwareService("euicc", EuiccManager.class, context -> new EuiccManager(context));
        SystemServiceRegistry.registerContextAwareService("euicc_card", EuiccCardManager.class, context -> new EuiccCardManager(context));
        SystemServiceRegistry.registerContextAwareService("telephony_ims", ImsManager.class, context -> new ImsManager(context));
    }

    public static TelephonyServiceManager getTelephonyServiceManager() {
        return sTelephonyServiceManager;
    }
}

