/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.IActivityManager;
import android.app.PropertyInvalidatedCache;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.content.pm.permission.SplitPermissionInfoParcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.permission.IPermissionManager;
import android.util.Slog;
import com.android.internal.annotations.Immutable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
public class PermissionManager {
    private static final String TAG = PermissionManager.class.getName();
    public static final String KILL_APP_REASON_PERMISSIONS_REVOKED = "permissions revoked";
    public static final String KILL_APP_REASON_GIDS_CHANGED = "permission grant or revoke changed gids";
    private final Context mContext;
    private final IPackageManager mPackageManager;
    private final IPermissionManager mPermissionManager;
    private List<SplitPermissionInfo> mSplitPermissionInfos;
    public static final String CACHE_KEY_PACKAGE_INFO = "cache_key.package_info";
    private static final PropertyInvalidatedCache<PermissionQuery, Integer> sPermissionCache = new PropertyInvalidatedCache<PermissionQuery, Integer>(16, "cache_key.package_info"){

        @Override
        protected Integer recompute(PermissionQuery query) {
            return PermissionManager.checkPermissionUncached(query.permission, query.pid, query.uid);
        }
    };
    private static PropertyInvalidatedCache<PackageNamePermissionQuery, Integer> sPackageNamePermissionCache = new PropertyInvalidatedCache<PackageNamePermissionQuery, Integer>(16, "cache_key.package_info"){

        @Override
        protected Integer recompute(PackageNamePermissionQuery query) {
            return PermissionManager.checkPackageNamePermissionUncached(query.permName, query.pkgName, query.uid);
        }
    };

    public PermissionManager(Context context, IPackageManager packageManager) throws ServiceManager.ServiceNotFoundException {
        this(context, packageManager, IPermissionManager.Stub.asInterface(ServiceManager.getServiceOrThrow("permissionmgr")));
    }

    @VisibleForTesting
    public PermissionManager(Context context, IPackageManager packageManager, IPermissionManager permissionManager) {
        this.mContext = context;
        this.mPackageManager = packageManager;
        this.mPermissionManager = permissionManager;
    }

    @SystemApi
    public int getRuntimePermissionsVersion() {
        try {
            return this.mPackageManager.getRuntimePermissionsVersion(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setRuntimePermissionsVersion(int version) {
        try {
            this.mPackageManager.setRuntimePermissionsVersion(version, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SplitPermissionInfo> getSplitPermissions() {
        List<SplitPermissionInfoParcelable> parcelableList;
        if (this.mSplitPermissionInfos != null) {
            return this.mSplitPermissionInfos;
        }
        try {
            parcelableList = ActivityThread.getPermissionManager().getSplitPermissions();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error getting split permissions", e);
            return Collections.emptyList();
        }
        this.mSplitPermissionInfos = this.splitPermissionInfoListToNonParcelableList(parcelableList);
        return this.mSplitPermissionInfos;
    }

    public void grantDefaultPermissionsToLuiApp(String packageName, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mPermissionManager.grantDefaultPermissionsToActiveLuiApp(packageName, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mPermissionManager.revokeDefaultPermissionsFromLuiApps(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mPermissionManager.grantDefaultPermissionsToEnabledImsServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mPermissionManager.grantDefaultPermissionsToEnabledTelephonyDataServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mPermissionManager.revokeDefaultPermissionsFromDisabledTelephonyDataServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mPermissionManager.grantDefaultPermissionsToEnabledCarrierApps(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public Set<String> getAutoRevokeExemptionRequestedPackages() {
        try {
            return CollectionUtils.toSet(this.mPermissionManager.getAutoRevokeExemptionRequestedPackages(this.mContext.getUser().getIdentifier()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public Set<String> getAutoRevokeExemptionGrantedPackages() {
        try {
            return CollectionUtils.toSet(this.mPermissionManager.getAutoRevokeExemptionGrantedPackages(this.mContext.getUser().getIdentifier()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private List<SplitPermissionInfo> splitPermissionInfoListToNonParcelableList(List<SplitPermissionInfoParcelable> parcelableList) {
        int size = parcelableList.size();
        ArrayList<SplitPermissionInfo> list = new ArrayList<SplitPermissionInfo>(size);
        for (int i = 0; i < size; ++i) {
            list.add(new SplitPermissionInfo(parcelableList.get(i)));
        }
        return list;
    }

    public static List<SplitPermissionInfoParcelable> splitPermissionInfoListToParcelableList(List<SplitPermissionInfo> splitPermissionsList) {
        int size = splitPermissionsList.size();
        ArrayList<SplitPermissionInfoParcelable> outList = new ArrayList<SplitPermissionInfoParcelable>(size);
        for (int i = 0; i < size; ++i) {
            SplitPermissionInfo info = splitPermissionsList.get(i);
            outList.add(new SplitPermissionInfoParcelable(info.getSplitPermission(), info.getNewPermissions(), info.getTargetSdk()));
        }
        return outList;
    }

    @SystemApi
    public void startOneTimePermissionSession(String packageName, long timeoutMillis, int importanceToResetTimer, int importanceToKeepSessionAlive) {
        try {
            this.mPermissionManager.startOneTimePermissionSession(packageName, this.mContext.getUserId(), timeoutMillis, importanceToResetTimer, importanceToKeepSessionAlive);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void stopOneTimePermissionSession(String packageName) {
        try {
            this.mPermissionManager.stopOneTimePermissionSession(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int checkDeviceIdentifierAccess(String packageName, String message, String callingFeatureId, int pid, int uid) {
        try {
            return this.mPermissionManager.checkDeviceIdentifierAccess(packageName, message, callingFeatureId, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static int checkPermissionUncached(String permission2, int pid, int uid) {
        IActivityManager am = ActivityManager.getService();
        if (am == null) {
            int appId = UserHandle.getAppId(uid);
            if (appId == 0 || appId == 1000) {
                Slog.w(TAG, "Missing ActivityManager; assuming " + uid + " holds " + permission2);
                return 0;
            }
            Slog.w(TAG, "Missing ActivityManager; assuming " + uid + " does not hold " + permission2);
            return -1;
        }
        try {
            return am.checkPermission(permission2, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int checkPermission(String permission2, int pid, int uid) {
        return sPermissionCache.query(new PermissionQuery(permission2, pid, uid));
    }

    public static void disablePermissionCache() {
        sPermissionCache.disableLocal();
    }

    private static int checkPackageNamePermissionUncached(String permName, String pkgName, int uid) {
        try {
            return ActivityThread.getPermissionManager().checkPermission(permName, pkgName, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int checkPackageNamePermission(String permName, String pkgName, int uid) {
        return sPackageNamePermissionCache.query(new PackageNamePermissionQuery(permName, pkgName, uid));
    }

    public static void disablePackageNamePermissionCache() {
        sPackageNamePermissionCache.disableLocal();
    }

    @Immutable
    private static class PackageNamePermissionQuery {
        final String permName;
        final String pkgName;
        final int uid;

        PackageNamePermissionQuery(String permName, String pkgName, int uid) {
            this.permName = permName;
            this.pkgName = pkgName;
            this.uid = uid;
        }

        public String toString() {
            return String.format("PackageNamePermissionQuery(pkgName=\"%s\", permName=\"%s, uid=%s\")", this.pkgName, this.permName, this.uid);
        }

        public int hashCode() {
            return Objects.hash(this.permName, this.pkgName, this.uid);
        }

        public boolean equals(Object rval) {
            PackageNamePermissionQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PackageNamePermissionQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return Objects.equals(this.permName, other.permName) && Objects.equals(this.pkgName, other.pkgName) && this.uid == other.uid;
        }
    }

    @Immutable
    private static class PermissionQuery {
        final String permission;
        final int pid;
        final int uid;

        PermissionQuery(String permission2, int pid, int uid) {
            this.permission = permission2;
            this.pid = pid;
            this.uid = uid;
        }

        public String toString() {
            return String.format("PermissionQuery(permission=\"%s\", pid=%s, uid=%s)", this.permission, this.pid, this.uid);
        }

        public int hashCode() {
            int hash = Objects.hashCode(this.permission);
            hash = hash * 13 + Objects.hashCode(this.uid);
            return hash;
        }

        public boolean equals(Object rval) {
            PermissionQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PermissionQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return this.uid == other.uid && Objects.equals(this.permission, other.permission);
        }
    }

    @Immutable
    public static class SplitPermissionInfo {
        private final SplitPermissionInfoParcelable mSplitPermissionInfoParcelable;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SplitPermissionInfo that = (SplitPermissionInfo)o;
            return this.mSplitPermissionInfoParcelable.equals(that.mSplitPermissionInfoParcelable);
        }

        public int hashCode() {
            return this.mSplitPermissionInfoParcelable.hashCode();
        }

        public String getSplitPermission() {
            return this.mSplitPermissionInfoParcelable.getSplitPermission();
        }

        public List<String> getNewPermissions() {
            return this.mSplitPermissionInfoParcelable.getNewPermissions();
        }

        public int getTargetSdk() {
            return this.mSplitPermissionInfoParcelable.getTargetSdk();
        }

        public SplitPermissionInfo(String splitPerm, List<String> newPerms, int targetSdk) {
            this(new SplitPermissionInfoParcelable(splitPerm, newPerms, targetSdk));
        }

        private SplitPermissionInfo(SplitPermissionInfoParcelable parcelable) {
            this.mSplitPermissionInfoParcelable = parcelable;
        }
    }
}

