/*
 * Decompiled with CFR 0.152.
 */
package android.os.incremental;

import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.IDataLoaderStatusListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.incremental.IStorageHealthListener;
import android.os.incremental.IncrementalNewFileParams;
import android.os.incremental.StorageHealthCheckParams;

public interface IIncrementalService
extends IInterface {
    public static final int CREATE_MODE_TEMPORARY_BIND = 1;
    public static final int CREATE_MODE_PERMANENT_BIND = 2;
    public static final int CREATE_MODE_CREATE = 4;
    public static final int CREATE_MODE_OPEN_EXISTING = 8;
    public static final int BIND_TEMPORARY = 0;
    public static final int BIND_PERMANENT = 1;

    public int openStorage(String var1) throws RemoteException;

    public int createStorage(String var1, DataLoaderParamsParcel var2, int var3, IDataLoaderStatusListener var4, StorageHealthCheckParams var5, IStorageHealthListener var6) throws RemoteException;

    public int createLinkedStorage(String var1, int var2, int var3) throws RemoteException;

    public int makeBindMount(int var1, String var2, String var3, int var4) throws RemoteException;

    public int deleteBindMount(int var1, String var2) throws RemoteException;

    public int makeDirectory(int var1, String var2) throws RemoteException;

    public int makeDirectories(int var1, String var2) throws RemoteException;

    public int makeFile(int var1, String var2, IncrementalNewFileParams var3) throws RemoteException;

    public int makeFileFromRange(int var1, String var2, String var3, long var4, long var6) throws RemoteException;

    public int makeLink(int var1, String var2, int var3, String var4) throws RemoteException;

    public int unlink(int var1, String var2) throws RemoteException;

    public boolean isFileRangeLoaded(int var1, String var2, long var3, long var5) throws RemoteException;

    public byte[] getMetadataByPath(int var1, String var2) throws RemoteException;

    public byte[] getMetadataById(int var1, byte[] var2) throws RemoteException;

    public boolean startLoading(int var1) throws RemoteException;

    public void deleteStorage(int var1) throws RemoteException;

    public void disableReadLogs(int var1) throws RemoteException;

    public boolean configureNativeBinaries(int var1, String var2, String var3, String var4, boolean var5) throws RemoteException;

    public boolean waitForNativeBinariesExtraction(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIncrementalService {
        private static final String DESCRIPTOR = "android.os.incremental.IIncrementalService";
        static final int TRANSACTION_openStorage = 1;
        static final int TRANSACTION_createStorage = 2;
        static final int TRANSACTION_createLinkedStorage = 3;
        static final int TRANSACTION_makeBindMount = 4;
        static final int TRANSACTION_deleteBindMount = 5;
        static final int TRANSACTION_makeDirectory = 6;
        static final int TRANSACTION_makeDirectories = 7;
        static final int TRANSACTION_makeFile = 8;
        static final int TRANSACTION_makeFileFromRange = 9;
        static final int TRANSACTION_makeLink = 10;
        static final int TRANSACTION_unlink = 11;
        static final int TRANSACTION_isFileRangeLoaded = 12;
        static final int TRANSACTION_getMetadataByPath = 13;
        static final int TRANSACTION_getMetadataById = 14;
        static final int TRANSACTION_startLoading = 15;
        static final int TRANSACTION_deleteStorage = 16;
        static final int TRANSACTION_disableReadLogs = 17;
        static final int TRANSACTION_configureNativeBinaries = 18;
        static final int TRANSACTION_waitForNativeBinariesExtraction = 19;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIncrementalService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IIncrementalService) {
                return (IIncrementalService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "openStorage";
                }
                case 2: {
                    return "createStorage";
                }
                case 3: {
                    return "createLinkedStorage";
                }
                case 4: {
                    return "makeBindMount";
                }
                case 5: {
                    return "deleteBindMount";
                }
                case 6: {
                    return "makeDirectory";
                }
                case 7: {
                    return "makeDirectories";
                }
                case 8: {
                    return "makeFile";
                }
                case 9: {
                    return "makeFileFromRange";
                }
                case 10: {
                    return "makeLink";
                }
                case 11: {
                    return "unlink";
                }
                case 12: {
                    return "isFileRangeLoaded";
                }
                case 13: {
                    return "getMetadataByPath";
                }
                case 14: {
                    return "getMetadataById";
                }
                case 15: {
                    return "startLoading";
                }
                case 16: {
                    return "deleteStorage";
                }
                case 17: {
                    return "disableReadLogs";
                }
                case 18: {
                    return "configureNativeBinaries";
                }
                case 19: {
                    return "waitForNativeBinariesExtraction";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.openStorage(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    DataLoaderParamsParcel _arg1 = 0 != data.readInt() ? DataLoaderParamsParcel.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    IDataLoaderStatusListener _arg3 = IDataLoaderStatusListener.Stub.asInterface(data.readStrongBinder());
                    StorageHealthCheckParams _arg4 = 0 != data.readInt() ? StorageHealthCheckParams.CREATOR.createFromParcel(data) : null;
                    IStorageHealthListener _arg5 = IStorageHealthListener.Stub.asInterface(data.readStrongBinder());
                    int _result = this.createStorage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _result = this.createLinkedStorage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _result = this.makeBindMount(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.deleteBindMount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.makeDirectory(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.makeDirectories(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IncrementalNewFileParams _arg2 = 0 != data.readInt() ? IncrementalNewFileParams.CREATOR.createFromParcel(data) : null;
                    int _result = this.makeFile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    long _arg3 = data.readLong();
                    long _arg4 = data.readLong();
                    int _result = this.makeFileFromRange(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _result = this.makeLink(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.unlink(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    boolean _result = this.isFileRangeLoaded(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    byte[] _result = this.getMetadataByPath(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _result = this.getMetadataById(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.startLoading(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.deleteStorage(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.disableReadLogs(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _arg4 = 0 != data.readInt();
                    boolean _result = this.configureNativeBinaries(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.waitForNativeBinariesExtraction(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IIncrementalService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IIncrementalService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IIncrementalService {
            private IBinder mRemote;
            public static IIncrementalService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int openStorage(String path) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().openStorage(path);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createStorage(String path, DataLoaderParamsParcel params, int createMode, IDataLoaderStatusListener statusListener, StorageHealthCheckParams healthCheckParams, IStorageHealthListener healthListener) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(createMode);
                    _data.writeStrongBinder(statusListener != null ? statusListener.asBinder() : null);
                    if (healthCheckParams != null) {
                        _data.writeInt(1);
                        healthCheckParams.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(healthListener != null ? healthListener.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().createStorage(path, params, createMode, statusListener, healthCheckParams, healthListener);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createLinkedStorage(String path, int otherStorageId, int createMode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(otherStorageId);
                    _data.writeInt(createMode);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().createLinkedStorage(path, otherStorageId, createMode);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int makeBindMount(int storageId, String sourcePath, String targetFullPath, int bindType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(sourcePath);
                    _data.writeString(targetFullPath);
                    _data.writeInt(bindType);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().makeBindMount(storageId, sourcePath, targetFullPath, bindType);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int deleteBindMount(int storageId, String targetFullPath) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(targetFullPath);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().deleteBindMount(storageId, targetFullPath);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int makeDirectory(int storageId, String path) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().makeDirectory(storageId, path);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int makeDirectories(int storageId, String path) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().makeDirectories(storageId, path);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int makeFile(int storageId, String path, IncrementalNewFileParams params) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(path);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().makeFile(storageId, path, params);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int makeFileFromRange(int storageId, String targetPath, String sourcePath, long start, long end) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(targetPath);
                    _data.writeString(sourcePath);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().makeFileFromRange(storageId, targetPath, sourcePath, start, end);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int makeLink(int sourceStorageId, String sourcePath, int destStorageId, String destPath) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sourceStorageId);
                    _data.writeString(sourcePath);
                    _data.writeInt(destStorageId);
                    _data.writeString(destPath);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().makeLink(sourceStorageId, sourcePath, destStorageId, destPath);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int unlink(int storageId, String path) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().unlink(storageId, path);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFileRangeLoaded(int storageId, String path, long start, long end) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(path);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isFileRangeLoaded(storageId, path, start, end);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMetadataByPath(int storageId, String path) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getMetadataByPath(storageId, path);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMetadataById(int storageId, byte[] fileId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeByteArray(fileId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getMetadataById(storageId, fileId);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startLoading(int storageId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startLoading(storageId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteStorage(int storageId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteStorage(storageId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableReadLogs(int storageId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disableReadLogs(storageId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean configureNativeBinaries(int storageId, String apkFullPath, String libDirRelativePath, String abi, boolean extractNativeLibs) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    _data.writeString(apkFullPath);
                    _data.writeString(libDirRelativePath);
                    _data.writeString(abi);
                    _data.writeInt(extractNativeLibs ? 1 : 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().configureNativeBinaries(storageId, apkFullPath, libDirRelativePath, abi, extractNativeLibs);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean waitForNativeBinariesExtraction(int storageId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(storageId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().waitForNativeBinariesExtraction(storageId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IIncrementalService {
        @Override
        public int openStorage(String path) throws RemoteException {
            return 0;
        }

        @Override
        public int createStorage(String path, DataLoaderParamsParcel params, int createMode, IDataLoaderStatusListener statusListener, StorageHealthCheckParams healthCheckParams, IStorageHealthListener healthListener) throws RemoteException {
            return 0;
        }

        @Override
        public int createLinkedStorage(String path, int otherStorageId, int createMode) throws RemoteException {
            return 0;
        }

        @Override
        public int makeBindMount(int storageId, String sourcePath, String targetFullPath, int bindType) throws RemoteException {
            return 0;
        }

        @Override
        public int deleteBindMount(int storageId, String targetFullPath) throws RemoteException {
            return 0;
        }

        @Override
        public int makeDirectory(int storageId, String path) throws RemoteException {
            return 0;
        }

        @Override
        public int makeDirectories(int storageId, String path) throws RemoteException {
            return 0;
        }

        @Override
        public int makeFile(int storageId, String path, IncrementalNewFileParams params) throws RemoteException {
            return 0;
        }

        @Override
        public int makeFileFromRange(int storageId, String targetPath, String sourcePath, long start, long end) throws RemoteException {
            return 0;
        }

        @Override
        public int makeLink(int sourceStorageId, String sourcePath, int destStorageId, String destPath) throws RemoteException {
            return 0;
        }

        @Override
        public int unlink(int storageId, String path) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isFileRangeLoaded(int storageId, String path, long start, long end) throws RemoteException {
            return false;
        }

        @Override
        public byte[] getMetadataByPath(int storageId, String path) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getMetadataById(int storageId, byte[] fileId) throws RemoteException {
            return null;
        }

        @Override
        public boolean startLoading(int storageId) throws RemoteException {
            return false;
        }

        @Override
        public void deleteStorage(int storageId) throws RemoteException {
        }

        @Override
        public void disableReadLogs(int storageId) throws RemoteException {
        }

        @Override
        public boolean configureNativeBinaries(int storageId, String apkFullPath, String libDirRelativePath, String abi, boolean extractNativeLibs) throws RemoteException {
            return false;
        }

        @Override
        public boolean waitForNativeBinariesExtraction(int storageId) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

