/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.DeviceIdleManager;
import android.os.IDeviceIdleController;
import android.os.RemoteException;
import android.os.UserHandle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

@SystemApi
public class PowerWhitelistManager {
    private final Context mContext;
    private final IDeviceIdleController mService;
    public static final int EVENT_UNSPECIFIED = 0;
    public static final int EVENT_SMS = 1;
    public static final int EVENT_MMS = 2;

    public PowerWhitelistManager(Context context) {
        this.mContext = context;
        this.mService = context.getSystemService(DeviceIdleManager.class).getService();
    }

    public void addToWhitelist(String packageName) {
        this.addToWhitelist(Collections.singletonList(packageName));
    }

    public void addToWhitelist(List<String> packageNames) {
        try {
            this.mService.addPowerSaveWhitelistApps(packageNames);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int[] getWhitelistedAppIds(boolean includingIdle) {
        try {
            if (includingIdle) {
                return this.mService.getAppIdWhitelist();
            }
            return this.mService.getAppIdWhitelistExceptIdle();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWhitelisted(String packageName, boolean includingIdle) {
        try {
            if (includingIdle) {
                return this.mService.isPowerSaveWhitelistApp(packageName);
            }
            return this.mService.isPowerSaveWhitelistExceptIdleApp(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void whitelistAppTemporarily(String packageName, long durationMs) {
        String reason = "from:" + UserHandle.formatUid(Binder.getCallingUid());
        try {
            this.mService.addPowerSaveTempWhitelistApp(packageName, durationMs, this.mContext.getUserId(), reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long whitelistAppTemporarilyForEvent(String packageName, int event, String reason) {
        try {
            switch (event) {
                case 2: {
                    return this.mService.addPowerSaveTempWhitelistAppForMms(packageName, this.mContext.getUserId(), reason);
                }
                case 1: {
                    return this.mService.addPowerSaveTempWhitelistAppForSms(packageName, this.mContext.getUserId(), reason);
                }
            }
            return this.mService.whitelistAppTemporarily(packageName, this.mContext.getUserId(), reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WhitelistEvent {
    }
}

