/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RouteDiscoveryPreference
implements Parcelable {
    public static final Parcelable.Creator<RouteDiscoveryPreference> CREATOR = new Parcelable.Creator<RouteDiscoveryPreference>(){

        @Override
        public RouteDiscoveryPreference createFromParcel(Parcel in) {
            return new RouteDiscoveryPreference(in);
        }

        public RouteDiscoveryPreference[] newArray(int size) {
            return new RouteDiscoveryPreference[size];
        }
    };
    private final List<String> mPreferredFeatures;
    private final boolean mShouldPerformActiveScan;
    private final Bundle mExtras;
    public static final RouteDiscoveryPreference EMPTY = new Builder(Collections.emptyList(), false).build();

    RouteDiscoveryPreference(Builder builder) {
        this.mPreferredFeatures = builder.mPreferredFeatures;
        this.mShouldPerformActiveScan = builder.mActiveScan;
        this.mExtras = builder.mExtras;
    }

    RouteDiscoveryPreference(Parcel in) {
        this.mPreferredFeatures = in.createStringArrayList();
        this.mShouldPerformActiveScan = in.readBoolean();
        this.mExtras = in.readBundle();
    }

    public List<String> getPreferredFeatures() {
        return this.mPreferredFeatures;
    }

    public boolean shouldPerformActiveScan() {
        return this.mShouldPerformActiveScan;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringList(this.mPreferredFeatures);
        dest.writeBoolean(this.mShouldPerformActiveScan);
        dest.writeBundle(this.mExtras);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("RouteDiscoveryRequest{ ").append("preferredFeatures={").append(String.join((CharSequence)", ", this.mPreferredFeatures)).append("}").append(", activeScan=").append(this.mShouldPerformActiveScan).append(" }");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RouteDiscoveryPreference)) {
            return false;
        }
        RouteDiscoveryPreference other = (RouteDiscoveryPreference)o;
        return Objects.equals(this.mPreferredFeatures, other.mPreferredFeatures) && this.mShouldPerformActiveScan == other.mShouldPerformActiveScan;
    }

    public int hashCode() {
        return Objects.hash(this.mPreferredFeatures, this.mShouldPerformActiveScan);
    }

    public static class Builder {
        List<String> mPreferredFeatures;
        boolean mActiveScan;
        Bundle mExtras;

        public Builder(List<String> preferredFeatures, boolean activeScan) {
            Objects.requireNonNull(preferredFeatures, "preferredFeatures must not be null");
            this.mPreferredFeatures = preferredFeatures.stream().filter(str -> !TextUtils.isEmpty(str)).collect(Collectors.toList());
            this.mActiveScan = activeScan;
        }

        public Builder(RouteDiscoveryPreference preference) {
            Objects.requireNonNull(preference, "preference must not be null");
            this.mPreferredFeatures = preference.getPreferredFeatures();
            this.mActiveScan = preference.shouldPerformActiveScan();
            this.mExtras = preference.getExtras();
        }

        public Builder(Collection<RouteDiscoveryPreference> preferences) {
            Objects.requireNonNull(preferences, "preferences must not be null");
            HashSet routeFeatureSet = new HashSet();
            this.mActiveScan = false;
            for (RouteDiscoveryPreference preference : preferences) {
                routeFeatureSet.addAll(preference.mPreferredFeatures);
                this.mActiveScan |= preference.mShouldPerformActiveScan;
            }
            this.mPreferredFeatures = new ArrayList<String>(routeFeatureSet);
        }

        public Builder setPreferredFeatures(List<String> preferredFeatures) {
            Objects.requireNonNull(preferredFeatures, "preferredFeatures must not be null");
            this.mPreferredFeatures = preferredFeatures.stream().filter(str -> !TextUtils.isEmpty(str)).collect(Collectors.toList());
            return this;
        }

        public Builder setShouldPerformActiveScan(boolean activeScan) {
            this.mActiveScan = activeScan;
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public RouteDiscoveryPreference build() {
            return new RouteDiscoveryPreference(this);
        }
    }
}

