/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.animation;

import android.animation.TimeInterpolator;
import android.graphics.animation.FallbackLUTInterpolator;
import android.graphics.animation.NativeInterpolator;
import android.graphics.animation.NativeInterpolatorFactory_Delegate;
import android.graphics.animation.RenderNodeAnimator;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class NativeInterpolatorFactory {
    private NativeInterpolatorFactory() {
    }

    public static long createNativeInterpolator(TimeInterpolator interpolator2, long duration) {
        if (interpolator2 == null) {
            return NativeInterpolatorFactory.createLinearInterpolator();
        }
        if (RenderNodeAnimator.isNativeInterpolator(interpolator2)) {
            return ((NativeInterpolator)((Object)interpolator2)).createNativeInterpolator();
        }
        return FallbackLUTInterpolator.createNativeInterpolator(interpolator2, duration);
    }

    @LayoutlibDelegate
    public static long createAccelerateDecelerateInterpolator() {
        return NativeInterpolatorFactory_Delegate.createAccelerateDecelerateInterpolator();
    }

    @LayoutlibDelegate
    public static long createAccelerateInterpolator(float f) {
        return NativeInterpolatorFactory_Delegate.createAccelerateInterpolator(f);
    }

    @LayoutlibDelegate
    public static long createAnticipateInterpolator(float f) {
        return NativeInterpolatorFactory_Delegate.createAnticipateInterpolator(f);
    }

    @LayoutlibDelegate
    public static long createAnticipateOvershootInterpolator(float f) {
        return NativeInterpolatorFactory_Delegate.createAnticipateOvershootInterpolator(f);
    }

    @LayoutlibDelegate
    public static long createBounceInterpolator() {
        return NativeInterpolatorFactory_Delegate.createBounceInterpolator();
    }

    @LayoutlibDelegate
    public static long createCycleInterpolator(float f) {
        return NativeInterpolatorFactory_Delegate.createCycleInterpolator(f);
    }

    @LayoutlibDelegate
    public static long createDecelerateInterpolator(float f) {
        return NativeInterpolatorFactory_Delegate.createDecelerateInterpolator(f);
    }

    @LayoutlibDelegate
    public static long createLinearInterpolator() {
        return NativeInterpolatorFactory_Delegate.createLinearInterpolator();
    }

    @LayoutlibDelegate
    public static long createOvershootInterpolator(float f) {
        return NativeInterpolatorFactory_Delegate.createOvershootInterpolator(f);
    }

    @LayoutlibDelegate
    public static long createPathInterpolator(float[] fArray, float[] fArray2) {
        return NativeInterpolatorFactory_Delegate.createPathInterpolator(fArray, fArray2);
    }

    @LayoutlibDelegate
    public static long createLutInterpolator(float[] fArray) {
        return NativeInterpolatorFactory_Delegate.createLutInterpolator(fArray);
    }
}

