/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.Shader;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import libcore.util.NativeAllocationRegistry_Delegate;

public abstract class Shader_Delegate {
    protected static final DelegateManager<Shader_Delegate> sManager = new DelegateManager<Shader_Delegate>(Shader_Delegate.class);
    private static long sFinalizer = -1L;
    private Matrix_Delegate mLocalMatrix = null;
    private float mAlpha = 1.0f;

    public static Shader_Delegate getDelegate(long nativeShader) {
        return sManager.getDelegate(nativeShader);
    }

    public static Shader.TileMode getTileMode(int tileMode) {
        for (Shader.TileMode tm : Shader.TileMode.values()) {
            if (tm.nativeInt != tileMode) continue;
            return tm;
        }
        assert (false);
        return Shader.TileMode.CLAMP;
    }

    public abstract Paint getJavaPaint();

    public abstract boolean isSupported();

    public abstract String getSupportMessage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nativeGetFinalizer() {
        Class<Shader_Delegate> clazz = Shader_Delegate.class;
        synchronized (Shader_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    protected Shader_Delegate(long nativeMatrix) {
        this.setLocalMatrix(nativeMatrix);
    }

    public void setLocalMatrix(long nativeMatrix) {
        this.mLocalMatrix = Matrix_Delegate.getDelegate(nativeMatrix);
    }

    protected AffineTransform getLocalMatrix() {
        if (this.mLocalMatrix != null) {
            return this.mLocalMatrix.getAffineTransform();
        }
        return new AffineTransform();
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public float getAlpha() {
        return this.mAlpha;
    }
}

