/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.EnumSet;
import java.util.NoSuchElementException;

public class RoundRectangle
extends RectangularShape {
    public double x;
    public double y;
    public double width;
    public double height;
    public double ulWidth;
    public double ulHeight;
    public double urWidth;
    public double urHeight;
    public double lrWidth;
    public double lrHeight;
    public double llWidth;
    public double llHeight;
    private final EnumSet<Zone> close = EnumSet.of(Zone.CLOSE_OUTSIDE, Zone.CLOSE_INSIDE);
    private final EnumSet<Zone> far = EnumSet.of(Zone.FAR_OUTSIDE, Zone.FAR_INSIDE);

    public RoundRectangle(float x, float y, float width, float height, float[] cornerDimensions) {
        assert (cornerDimensions.length == 8) : "The array of corner dimensions must have eight elements";
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        float[] dimensions = (float[])cornerDimensions.clone();
        for (int i = 0; i < dimensions.length; i += 2) {
            if (!(dimensions[i] < 0.0f) && !(dimensions[i + 1] < 0.0f)) continue;
            dimensions[i] = 0.0f;
            dimensions[i + 1] = 0.0f;
        }
        double topCornerWidth = (double)(dimensions[0] + dimensions[2]) / 2.0;
        double bottomCornerWidth = (double)(dimensions[4] + dimensions[6]) / 2.0;
        double leftCornerHeight = (double)(dimensions[1] + dimensions[7]) / 2.0;
        double rightCornerHeight = (double)(dimensions[3] + dimensions[5]) / 2.0;
        double scale = Math.min(1.0, (double)width / topCornerWidth);
        scale = Math.min(scale, (double)width / bottomCornerWidth);
        scale = Math.min(scale, (double)height / leftCornerHeight);
        scale = Math.min(scale, (double)height / rightCornerHeight);
        this.ulWidth = (double)dimensions[0] * scale;
        this.ulHeight = (double)dimensions[1] * scale;
        this.urWidth = (double)dimensions[2] * scale;
        this.urHeight = (double)dimensions[3] * scale;
        this.lrWidth = (double)dimensions[4] * scale;
        this.lrHeight = (double)dimensions[5] * scale;
        this.llWidth = (double)dimensions[6] * scale;
        this.llHeight = (double)dimensions[7] * scale;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.isEmpty()) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        double x1 = x0 + this.getWidth();
        double y1 = y0 + this.getHeight();
        if (x < x0 || y < y0 || x >= x1 || y >= y1) {
            return false;
        }
        double insideTopX0 = x0 + this.ulWidth / 2.0;
        double insideLeftY0 = y0 + this.ulHeight / 2.0;
        if (x < insideTopX0 && y < insideLeftY0) {
            return this.isInsideCorner(x - insideTopX0, y - insideLeftY0, this.ulWidth / 2.0, this.ulHeight / 2.0);
        }
        double insideTopX1 = x1 - this.urWidth / 2.0;
        double insideRightY0 = y0 + this.urHeight / 2.0;
        if (x > insideTopX1 && y < insideRightY0) {
            return this.isInsideCorner(x - insideTopX1, y - insideRightY0, this.urWidth / 2.0, this.urHeight / 2.0);
        }
        double insideBottomX1 = x1 - this.lrWidth / 2.0;
        double insideRightY1 = y1 - this.lrHeight / 2.0;
        if (x > insideBottomX1 && y > insideRightY1) {
            return this.isInsideCorner(x - insideBottomX1, y - insideRightY1, this.lrWidth / 2.0, this.lrHeight / 2.0);
        }
        double insideBottomX0 = x0 + this.llWidth / 2.0;
        double insideLeftY1 = y1 - this.llHeight / 2.0;
        if (x < insideBottomX0 && y > insideLeftY1) {
            return this.isInsideCorner(x - insideBottomX0, y - insideLeftY1, this.llWidth / 2.0, this.llHeight / 2.0);
        }
        return true;
    }

    private boolean isInsideCorner(double x, double y, double width, double height) {
        double squareDist = height * height * x * x + width * width * y * y;
        return squareDist <= width * width * height * height;
    }

    private Zone classify(double coord, double side1, double arcSize1, double side2, double arcSize2) {
        if (coord < side1) {
            return Zone.CLOSE_OUTSIDE;
        }
        if (coord < side1 + arcSize1) {
            return Zone.CLOSE_INSIDE;
        }
        if (coord < side2 - arcSize2) {
            return Zone.MIDDLE;
        }
        if (coord < side2) {
            return Zone.FAR_INSIDE;
        }
        return Zone.FAR_OUTSIDE;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        double x1 = x0 + this.getWidth();
        double y1 = y0 + this.getHeight();
        if (x + w <= x0 || x >= x1 || y + h <= y0 || y >= y1) {
            return false;
        }
        double maxLeftCornerWidth = Math.max(this.ulWidth, this.llWidth) / 2.0;
        double maxRightCornerWidth = Math.max(this.urWidth, this.lrWidth) / 2.0;
        double maxUpperCornerHeight = Math.max(this.ulHeight, this.urHeight) / 2.0;
        double maxLowerCornerHeight = Math.max(this.llHeight, this.lrHeight) / 2.0;
        Zone x0class = this.classify(x, x0, maxLeftCornerWidth, x1, maxRightCornerWidth);
        Zone x1class = this.classify(x + w, x0, maxLeftCornerWidth, x1, maxRightCornerWidth);
        Zone y0class = this.classify(y, y0, maxUpperCornerHeight, y1, maxLowerCornerHeight);
        Zone y1class = this.classify(y + h, y0, maxUpperCornerHeight, y1, maxLowerCornerHeight);
        if (x0class == Zone.MIDDLE || x1class == Zone.MIDDLE || y0class == Zone.MIDDLE || y1class == Zone.MIDDLE) {
            return true;
        }
        if (this.close.contains((Object)x0class) && this.far.contains((Object)x1class) || this.close.contains((Object)y0class) && this.far.contains((Object)y1class)) {
            return true;
        }
        if (x1class == Zone.CLOSE_INSIDE && y1class == Zone.CLOSE_INSIDE) {
            x = x + w - x0 - this.ulWidth / 2.0;
            y = y + h - y0 - this.ulHeight / 2.0;
            return x > 0.0 || y > 0.0 || this.isInsideCorner(x, y, this.ulWidth / 2.0, this.ulHeight / 2.0);
        }
        if (x1class == Zone.CLOSE_INSIDE) {
            x = x + w - x0 - this.llWidth / 2.0;
            y = y - y1 + this.llHeight / 2.0;
            return x > 0.0 || y < 0.0 || this.isInsideCorner(x, y, this.llWidth / 2.0, this.llHeight / 2.0);
        }
        if (y1class == Zone.CLOSE_INSIDE) {
            x = x - x1 + this.urWidth / 2.0;
            y = y + h - y0 - this.urHeight / 2.0;
            return x < 0.0 || y > 0.0 || this.isInsideCorner(x, y, this.urWidth / 2.0, this.urHeight / 2.0);
        }
        x = x - x1 + this.lrWidth / 2.0;
        y = y - y1 + this.lrHeight / 2.0;
        return x < 0.0 || y < 0.0 || this.isInsideCorner(x, y, this.lrWidth / 2.0, this.lrHeight / 2.0);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public PathIterator getPathIterator(final AffineTransform at) {
        return new PathIterator(){
            int index;
            public static final double CtrlVal = 0.5522847498307933;
            private final double ncv = 0.44771525016920666;
            private final double[][] ctrlpts;
            private final int[] types;
            {
                this.ctrlpts = new double[][]{{0.0, 0.0, 0.0, RoundRectangle.this.ulHeight}, {0.0, 0.0, 1.0, -RoundRectangle.this.llHeight}, {0.0, 0.0, 1.0, -RoundRectangle.this.llHeight * 0.44771525016920666, 0.0, 0.44771525016920666 * RoundRectangle.this.llWidth, 1.0, 0.0, 0.0, RoundRectangle.this.llWidth, 1.0, 0.0}, {1.0, -RoundRectangle.this.lrWidth, 1.0, 0.0}, {1.0, -RoundRectangle.this.lrWidth * 0.44771525016920666, 1.0, 0.0, 1.0, 0.0, 1.0, -RoundRectangle.this.lrHeight * 0.44771525016920666, 1.0, 0.0, 1.0, -RoundRectangle.this.lrHeight}, {1.0, 0.0, 0.0, RoundRectangle.this.urHeight}, {1.0, 0.0, 0.0, 0.44771525016920666 * RoundRectangle.this.urHeight, 1.0, -RoundRectangle.this.urWidth * 0.44771525016920666, 0.0, 0.0, 1.0, -RoundRectangle.this.urWidth, 0.0, 0.0}, {0.0, RoundRectangle.this.ulWidth, 0.0, 0.0}, {0.0, 0.44771525016920666 * RoundRectangle.this.ulWidth, 0.0, 0.0, 0.0, 0.0, 0.0, 0.44771525016920666 * RoundRectangle.this.ulHeight, 0.0, 0.0, 0.0, RoundRectangle.this.ulHeight}, new double[0]};
                this.types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};
            }

            @Override
            public int getWindingRule() {
                return 1;
            }

            @Override
            public boolean isDone() {
                return this.index >= this.ctrlpts.length;
            }

            @Override
            public void next() {
                ++this.index;
            }

            @Override
            public int currentSegment(float[] coords) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                int nc = 0;
                double[] ctrls = this.ctrlpts[this.index];
                for (int i = 0; i < ctrls.length; i += 4) {
                    coords[nc++] = (float)(RoundRectangle.this.x + ctrls[i] * RoundRectangle.this.width + ctrls[i + 1] / 2.0);
                    coords[nc++] = (float)(RoundRectangle.this.y + ctrls[i + 2] * RoundRectangle.this.height + ctrls[i + 3] / 2.0);
                }
                if (at != null) {
                    at.transform(coords, 0, coords, 0, nc / 2);
                }
                return this.types[this.index];
            }

            @Override
            public int currentSegment(double[] coords) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                int nc = 0;
                double[] ctrls = this.ctrlpts[this.index];
                for (int i = 0; i < ctrls.length; i += 4) {
                    coords[nc++] = RoundRectangle.this.x + ctrls[i] * RoundRectangle.this.width + ctrls[i + 1] / 2.0;
                    coords[nc++] = RoundRectangle.this.y + ctrls[i + 2] * RoundRectangle.this.height + ctrls[i + 3] / 2.0;
                }
                if (at != null) {
                    at.transform(coords, 0, coords, 0, nc / 2);
                }
                return this.types[this.index];
            }
        };
    }

    private static enum Zone {
        CLOSE_OUTSIDE,
        CLOSE_INSIDE,
        MIDDLE,
        FAR_INSIDE,
        FAR_OUTSIDE;

    }
}

