/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Matrix;
import android.graphics.Path_Delegate;
import android.graphics.RectF;
import android.graphics.Region;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import libcore.util.NativeAllocationRegistry;

public class Path {
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Path.class.getClassLoader(), Path.nGetFinalizer());
    public final long mNativePath;
    @UnsupportedAppUsage
    public boolean isSimplePath = true;
    @UnsupportedAppUsage
    public Region rects;
    private Direction mLastDirection = null;
    static final FillType[] sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};

    public Path() {
        this.mNativePath = Path.nInit();
        sRegistry.registerNativeAllocation(this, this.mNativePath);
    }

    public Path(Path src) {
        long valNative = 0L;
        if (src != null) {
            valNative = src.mNativePath;
            this.isSimplePath = src.isSimplePath;
            if (src.rects != null) {
                this.rects = new Region(src.rects);
            }
        }
        this.mNativePath = Path.nInit(valNative);
        sRegistry.registerNativeAllocation(this, this.mNativePath);
    }

    public void reset() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        FillType fillType = this.getFillType();
        Path.nReset(this.mNativePath);
        this.setFillType(fillType);
    }

    public void rewind() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        Path.nRewind(this.mNativePath);
    }

    public void set(Path src) {
        if (this == src) {
            return;
        }
        this.isSimplePath = src.isSimplePath;
        Path.nSet(this.mNativePath, src.mNativePath);
        if (!this.isSimplePath) {
            return;
        }
        if (this.rects != null && src.rects != null) {
            this.rects.set(src.rects);
        } else if (this.rects != null && src.rects == null) {
            this.rects.setEmpty();
        } else if (src.rects != null) {
            this.rects = new Region(src.rects);
        }
    }

    public boolean op(Path path, Op op) {
        return this.op(this, path, op);
    }

    public boolean op(Path path1, Path path2, Op op) {
        if (Path.nOp(path1.mNativePath, path2.mNativePath, op.ordinal(), this.mNativePath)) {
            this.isSimplePath = false;
            this.rects = null;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isConvex() {
        return Path.nIsConvex(this.mNativePath);
    }

    public FillType getFillType() {
        return sFillTypeArray[Path.nGetFillType(this.mNativePath)];
    }

    public void setFillType(FillType ft) {
        Path.nSetFillType(this.mNativePath, ft.nativeInt);
    }

    public boolean isInverseFillType() {
        int ft = Path.nGetFillType(this.mNativePath);
        return (ft & FillType.INVERSE_WINDING.nativeInt) != 0;
    }

    public void toggleInverseFillType() {
        int ft = Path.nGetFillType(this.mNativePath);
        Path.nSetFillType(this.mNativePath, ft ^= FillType.INVERSE_WINDING.nativeInt);
    }

    public boolean isEmpty() {
        return Path.nIsEmpty(this.mNativePath);
    }

    public boolean isRect(RectF rect) {
        return Path.nIsRect(this.mNativePath, rect);
    }

    public void computeBounds(RectF bounds, boolean exact) {
        Path.nComputeBounds(this.mNativePath, bounds);
    }

    public void incReserve(int extraPtCount) {
        Path.nIncReserve(this.mNativePath, extraPtCount);
    }

    public void moveTo(float x, float y) {
        Path.nMoveTo(this.mNativePath, x, y);
    }

    public void rMoveTo(float dx, float dy) {
        Path.nRMoveTo(this.mNativePath, dx, dy);
    }

    public void lineTo(float x, float y) {
        this.isSimplePath = false;
        Path.nLineTo(this.mNativePath, x, y);
    }

    public void rLineTo(float dx, float dy) {
        this.isSimplePath = false;
        Path.nRLineTo(this.mNativePath, dx, dy);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.isSimplePath = false;
        Path.nQuadTo(this.mNativePath, x1, y1, x2, y2);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        this.isSimplePath = false;
        Path.nRQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.nCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.nRCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, forceMoveTo);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, false);
    }

    public void arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.isSimplePath = false;
        Path.nArcTo(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle, forceMoveTo);
    }

    public void close() {
        this.isSimplePath = false;
        Path.nClose(this.mNativePath);
    }

    private void detectSimplePath(float left, float top, float right, float bottom, Direction dir) {
        if (this.mLastDirection == null) {
            this.mLastDirection = dir;
        }
        if (this.mLastDirection != dir) {
            this.isSimplePath = false;
        } else {
            if (this.rects == null) {
                this.rects = new Region();
            }
            this.rects.op((int)left, (int)top, (int)right, (int)bottom, Region.Op.UNION);
        }
    }

    public void addRect(RectF rect, Direction dir) {
        this.addRect(rect.left, rect.top, rect.right, rect.bottom, dir);
    }

    public void addRect(float left, float top, float right, float bottom, Direction dir) {
        this.detectSimplePath(left, top, right, bottom, dir);
        Path.nAddRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addOval(RectF oval, Direction dir) {
        this.addOval(oval.left, oval.top, oval.right, oval.bottom, dir);
    }

    public void addOval(float left, float top, float right, float bottom, Direction dir) {
        this.isSimplePath = false;
        Path.nAddOval(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addCircle(float x, float y, float radius, Direction dir) {
        this.isSimplePath = false;
        Path.nAddCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    public void addArc(RectF oval, float startAngle, float sweepAngle) {
        this.addArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle);
    }

    public void addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        this.isSimplePath = false;
        Path.nAddArc(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle);
    }

    public void addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, dir);
    }

    public void addRoundRect(float left, float top, float right, float bottom, float rx, float ry, Direction dir) {
        this.isSimplePath = false;
        Path.nAddRoundRect(this.mNativePath, left, top, right, bottom, rx, ry, dir.nativeInt);
    }

    public void addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, radii, dir);
    }

    public void addRoundRect(float left, float top, float right, float bottom, float[] radii, Direction dir) {
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        this.isSimplePath = false;
        Path.nAddRoundRect(this.mNativePath, left, top, right, bottom, radii, dir.nativeInt);
    }

    public void addPath(Path src, float dx, float dy) {
        this.isSimplePath = false;
        Path.nAddPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    public void addPath(Path src) {
        this.isSimplePath = false;
        Path.nAddPath(this.mNativePath, src.mNativePath);
    }

    public void addPath(Path src, Matrix matrix) {
        if (!src.isSimplePath) {
            this.isSimplePath = false;
        }
        Path.nAddPath(this.mNativePath, src.mNativePath, matrix.native_instance);
    }

    public void offset(float dx, float dy, Path dst) {
        if (dst != null) {
            dst.set(this);
        } else {
            dst = this;
        }
        dst.offset(dx, dy);
    }

    public void offset(float dx, float dy) {
        if (this.isSimplePath && this.rects == null) {
            return;
        }
        if (this.isSimplePath && (double)dx == Math.rint(dx) && (double)dy == Math.rint(dy)) {
            this.rects.translate((int)dx, (int)dy);
        } else {
            this.isSimplePath = false;
        }
        Path.nOffset(this.mNativePath, dx, dy);
    }

    public void setLastPoint(float dx, float dy) {
        this.isSimplePath = false;
        Path.nSetLastPoint(this.mNativePath, dx, dy);
    }

    public void transform(Matrix matrix, Path dst) {
        long dstNative = 0L;
        if (dst != null) {
            dst.isSimplePath = false;
            dstNative = dst.mNativePath;
        }
        Path.nTransform(this.mNativePath, matrix.native_instance, dstNative);
    }

    public void transform(Matrix matrix) {
        this.isSimplePath = false;
        Path.nTransform(this.mNativePath, matrix.native_instance);
    }

    public long readOnlyNI() {
        return this.mNativePath;
    }

    long mutateNI() {
        this.isSimplePath = false;
        return this.mNativePath;
    }

    public float[] approximate(float acceptableError) {
        if (acceptableError < 0.0f) {
            throw new IllegalArgumentException("AcceptableError must be greater than or equal to 0");
        }
        return Path.nApproximate(this.mNativePath, acceptableError);
    }

    @LayoutlibDelegate
    private static long nInit() {
        return Path_Delegate.nInit();
    }

    @LayoutlibDelegate
    private static long nInit(long l) {
        return Path_Delegate.nInit(l);
    }

    @LayoutlibDelegate
    private static long nGetFinalizer() {
        return Path_Delegate.nGetFinalizer();
    }

    @LayoutlibDelegate
    private static void nSet(long l, long l2) {
        Path_Delegate.nSet(l, l2);
    }

    @LayoutlibDelegate
    private static void nComputeBounds(long l, RectF rectF) {
        Path_Delegate.nComputeBounds(l, rectF);
    }

    @LayoutlibDelegate
    private static void nIncReserve(long l, int n) {
        Path_Delegate.nIncReserve(l, n);
    }

    @LayoutlibDelegate
    private static void nMoveTo(long l, float f, float f2) {
        Path_Delegate.nMoveTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void nRMoveTo(long l, float f, float f2) {
        Path_Delegate.nRMoveTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void nLineTo(long l, float f, float f2) {
        Path_Delegate.nLineTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void nRLineTo(long l, float f, float f2) {
        Path_Delegate.nRLineTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void nQuadTo(long l, float f, float f2, float f3, float f4) {
        Path_Delegate.nQuadTo(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void nRQuadTo(long l, float f, float f2, float f3, float f4) {
        Path_Delegate.nRQuadTo(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void nCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate.nCubicTo(l, f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    private static void nRCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate.nRCubicTo(l, f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    private static void nArcTo(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        Path_Delegate.nArcTo(l, f, f2, f3, f4, f5, f6, bl);
    }

    @LayoutlibDelegate
    private static void nClose(long l) {
        Path_Delegate.nClose(l);
    }

    @LayoutlibDelegate
    private static void nAddRect(long l, float f, float f2, float f3, float f4, int n) {
        Path_Delegate.nAddRect(l, f, f2, f3, f4, n);
    }

    @LayoutlibDelegate
    private static void nAddOval(long l, float f, float f2, float f3, float f4, int n) {
        Path_Delegate.nAddOval(l, f, f2, f3, f4, n);
    }

    @LayoutlibDelegate
    private static void nAddCircle(long l, float f, float f2, float f3, int n) {
        Path_Delegate.nAddCircle(l, f, f2, f3, n);
    }

    @LayoutlibDelegate
    private static void nAddArc(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate.nAddArc(l, f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    private static void nAddRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        Path_Delegate.nAddRoundRect(l, f, f2, f3, f4, f5, f6, n);
    }

    @LayoutlibDelegate
    private static void nAddRoundRect(long l, float f, float f2, float f3, float f4, float[] fArray, int n) {
        Path_Delegate.nAddRoundRect(l, f, f2, f3, f4, fArray, n);
    }

    @LayoutlibDelegate
    private static void nAddPath(long l, long l2, float f, float f2) {
        Path_Delegate.nAddPath(l, l2, f, f2);
    }

    @LayoutlibDelegate
    private static void nAddPath(long l, long l2) {
        Path_Delegate.nAddPath(l, l2);
    }

    @LayoutlibDelegate
    private static void nAddPath(long l, long l2, long l3) {
        Path_Delegate.nAddPath(l, l2, l3);
    }

    @LayoutlibDelegate
    private static void nOffset(long l, float f, float f2) {
        Path_Delegate.nOffset(l, f, f2);
    }

    @LayoutlibDelegate
    private static void nSetLastPoint(long l, float f, float f2) {
        Path_Delegate.nSetLastPoint(l, f, f2);
    }

    @LayoutlibDelegate
    private static void nTransform(long l, long l2, long l3) {
        Path_Delegate.nTransform(l, l2, l3);
    }

    @LayoutlibDelegate
    private static void nTransform(long l, long l2) {
        Path_Delegate.nTransform(l, l2);
    }

    @LayoutlibDelegate
    private static boolean nOp(long l, long l2, int n, long l3) {
        return Path_Delegate.nOp(l, l2, n, l3);
    }

    @LayoutlibDelegate
    private static float[] nApproximate(long l, float f) {
        return Path_Delegate.nApproximate(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nIsRect(long l, RectF rectF) {
        return Path_Delegate.nIsRect(l, rectF);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nReset(long l) {
        Path_Delegate.nReset(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nRewind(long l) {
        Path_Delegate.nRewind(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsEmpty(long l) {
        return Path_Delegate.nIsEmpty(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsConvex(long l) {
        return Path_Delegate.nIsConvex(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetFillType(long l) {
        return Path_Delegate.nGetFillType(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetFillType(long l, int n) {
        Path_Delegate.nSetFillType(l, n);
    }

    public static enum Direction {
        CW(0),
        CCW(1);

        final int nativeInt;

        private Direction(int ni) {
            this.nativeInt = ni;
        }
    }

    public static enum FillType {
        WINDING(0),
        EVEN_ODD(1),
        INVERSE_WINDING(2),
        INVERSE_EVEN_ODD(3);

        final int nativeInt;

        private FillType(int ni) {
            this.nativeInt = ni;
        }
    }

    public static enum Op {
        DIFFERENCE,
        INTERSECT,
        UNION,
        XOR,
        REVERSE_DIFFERENCE;

    }
}

