/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch_Delegate;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class NinePatch {
    @UnsupportedAppUsage
    private final Bitmap mBitmap;
    @UnsupportedAppUsage
    public long mNativeChunk;
    private Paint mPaint;
    private String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] chunk) {
        this(bitmap, chunk, null);
    }

    public NinePatch(Bitmap bitmap, byte[] chunk, String srcName) {
        this.mBitmap = bitmap;
        this.mSrcName = srcName;
        this.mNativeChunk = NinePatch.validateNinePatchChunk(chunk);
    }

    public NinePatch(NinePatch patch) {
        this.mBitmap = patch.mBitmap;
        this.mSrcName = patch.mSrcName;
        if (patch.mPaint != null) {
            this.mPaint = new Paint(patch.mPaint);
        }
        this.mNativeChunk = patch.mNativeChunk;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativeChunk != 0L) {
                NinePatch.nativeFinalize(this.mNativeChunk);
                this.mNativeChunk = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        return this.mSrcName;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setPaint(Paint p) {
        this.mPaint = p;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void draw(Canvas canvas, RectF location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location, Paint paint) {
        canvas.drawPatch(this, location, paint);
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public Region getTransparentRegion(Rect bounds) {
        long r = NinePatch.nativeGetTransparentRegion(this.mBitmap.getNativeInstance(), this.mNativeChunk, bounds);
        return r != 0L ? new Region(r) : null;
    }

    @LayoutlibDelegate
    public static boolean isNinePatchChunk(byte[] byArray) {
        return NinePatch_Delegate.isNinePatchChunk(byArray);
    }

    @LayoutlibDelegate
    private static long validateNinePatchChunk(byte[] byArray) {
        return NinePatch_Delegate.validateNinePatchChunk(byArray);
    }

    @LayoutlibDelegate
    private static void nativeFinalize(long l) {
        NinePatch_Delegate.nativeFinalize(l);
    }

    @LayoutlibDelegate
    private static long nativeGetTransparentRegion(long l, long l2, Rect rect) {
        return NinePatch_Delegate.nativeGetTransparentRegion(l, l2, rect);
    }

    public static class InsetStruct {
        public final Rect opticalRect;
        public final Rect outlineRect;
        public final float outlineRadius;
        public final float outlineAlpha;

        @UnsupportedAppUsage
        InsetStruct(int opticalLeft, int opticalTop, int opticalRight, int opticalBottom, int outlineLeft, int outlineTop, int outlineRight, int outlineBottom, float outlineRadius, int outlineAlpha, float decodeScale) {
            this.opticalRect = new Rect(opticalLeft, opticalTop, opticalRight, opticalBottom);
            this.opticalRect.scale(decodeScale);
            this.outlineRect = InsetStruct.scaleInsets(outlineLeft, outlineTop, outlineRight, outlineBottom, decodeScale);
            this.outlineRadius = outlineRadius * decodeScale;
            this.outlineAlpha = (float)outlineAlpha / 255.0f;
        }

        public static Rect scaleInsets(int left, int top, int right, int bottom, float scale) {
            if (scale == 1.0f) {
                return new Rect(left, top, right, bottom);
            }
            Rect result = new Rect();
            result.left = (int)Math.ceil((float)left * scale);
            result.top = (int)Math.ceil((float)top * scale);
            result.right = (int)Math.ceil((float)right * scale);
            result.bottom = (int)Math.ceil((float)bottom * scale);
            return result;
        }
    }
}

