/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.VersionedPackage;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SharedLibraryInfo
implements Parcelable {
    public static final int TYPE_BUILTIN = 0;
    public static final int TYPE_DYNAMIC = 1;
    public static final int TYPE_STATIC = 2;
    public static final int VERSION_UNDEFINED = -1;
    private final String mPath;
    private final String mPackageName;
    private final String mName;
    private final List<String> mCodePaths;
    private final long mVersion;
    private final int mType;
    private final VersionedPackage mDeclaringPackage;
    private final List<VersionedPackage> mDependentPackages;
    private List<SharedLibraryInfo> mDependencies;
    public static final Parcelable.Creator<SharedLibraryInfo> CREATOR = new Parcelable.Creator<SharedLibraryInfo>(){

        @Override
        public SharedLibraryInfo createFromParcel(Parcel source) {
            return new SharedLibraryInfo(source);
        }

        public SharedLibraryInfo[] newArray(int size) {
            return new SharedLibraryInfo[size];
        }
    };

    public SharedLibraryInfo(String path, String packageName, List<String> codePaths, String name, long version, int type, VersionedPackage declaringPackage, List<VersionedPackage> dependentPackages, List<SharedLibraryInfo> dependencies) {
        this.mPath = path;
        this.mPackageName = packageName;
        this.mCodePaths = codePaths;
        this.mName = name;
        this.mVersion = version;
        this.mType = type;
        this.mDeclaringPackage = declaringPackage;
        this.mDependentPackages = dependentPackages;
        this.mDependencies = dependencies;
    }

    private SharedLibraryInfo(Parcel parcel) {
        this.mPath = parcel.readString8();
        this.mPackageName = parcel.readString8();
        this.mCodePaths = parcel.readInt() != 0 ? Arrays.asList(parcel.createString8Array()) : null;
        this.mName = parcel.readString8();
        this.mVersion = parcel.readLong();
        this.mType = parcel.readInt();
        this.mDeclaringPackage = (VersionedPackage)parcel.readParcelable(null);
        this.mDependentPackages = parcel.readArrayList(null);
        this.mDependencies = parcel.createTypedArrayList(CREATOR);
    }

    public int getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<String> getAllCodePaths() {
        if (this.getPath() != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getPath());
            return list;
        }
        return this.mCodePaths;
    }

    public void addDependency(SharedLibraryInfo info) {
        if (info == null) {
            return;
        }
        if (this.mDependencies == null) {
            this.mDependencies = new ArrayList<SharedLibraryInfo>();
        }
        this.mDependencies.add(info);
    }

    public void clearDependencies() {
        this.mDependencies = null;
    }

    public List<SharedLibraryInfo> getDependencies() {
        return this.mDependencies;
    }

    @Deprecated
    public int getVersion() {
        return this.mVersion < 0L ? (int)this.mVersion : (int)(this.mVersion & Integer.MAX_VALUE);
    }

    public long getLongVersion() {
        return this.mVersion;
    }

    public boolean isBuiltin() {
        return this.mType == 0;
    }

    public boolean isDynamic() {
        return this.mType == 1;
    }

    public boolean isStatic() {
        return this.mType == 2;
    }

    public VersionedPackage getDeclaringPackage() {
        return this.mDeclaringPackage;
    }

    public List<VersionedPackage> getDependentPackages() {
        if (this.mDependentPackages == null) {
            return Collections.emptyList();
        }
        return this.mDependentPackages;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "SharedLibraryInfo{name:" + this.mName + ", type:" + SharedLibraryInfo.typeToString(this.mType) + ", version:" + this.mVersion + (!this.getDependentPackages().isEmpty() ? " has dependents" : "") + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString8(this.mPath);
        parcel.writeString8(this.mPackageName);
        if (this.mCodePaths != null) {
            parcel.writeInt(1);
            parcel.writeString8Array(this.mCodePaths.toArray(new String[this.mCodePaths.size()]));
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString8(this.mName);
        parcel.writeLong(this.mVersion);
        parcel.writeInt(this.mType);
        parcel.writeParcelable(this.mDeclaringPackage, flags);
        parcel.writeList(this.mDependentPackages);
        parcel.writeTypedList(this.mDependencies);
    }

    private static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "builtin";
            }
            case 1: {
                return "dynamic";
            }
            case 2: {
                return "static";
            }
        }
        return "unknown";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Type {
    }
}

