/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentInterface;
import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import dalvik.system.CloseGuard;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;

public class ContentProviderClient
implements ContentInterface,
AutoCloseable {
    private static final String TAG = "ContentProviderClient";
    @GuardedBy(value={"ContentProviderClient.class"})
    private static Handler sAnrHandler;
    private final ContentResolver mContentResolver;
    @UnsupportedAppUsage
    private final IContentProvider mContentProvider;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final String mPackageName;
    private final String mAttributionTag;
    private final String mAuthority;
    private final boolean mStable;
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mAnrTimeout;
    private NotRespondingRunnable mAnrRunnable;

    @VisibleForTesting
    public ContentProviderClient(ContentResolver contentResolver, IContentProvider contentProvider, boolean stable) {
        this(contentResolver, contentProvider, "unknown", stable);
    }

    public ContentProviderClient(ContentResolver contentResolver, IContentProvider contentProvider, String authority, boolean stable) {
        this.mContentResolver = contentResolver;
        this.mContentProvider = contentProvider;
        this.mPackageName = contentResolver.mPackageName;
        this.mAttributionTag = contentResolver.mAttributionTag;
        this.mAuthority = authority;
        this.mStable = stable;
        this.mCloseGuard.open("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setDetectNotResponding(long timeoutMillis) {
        Class<ContentProviderClient> clazz = ContentProviderClient.class;
        synchronized (ContentProviderClient.class) {
            this.mAnrTimeout = timeoutMillis;
            if (timeoutMillis > 0L) {
                if (this.mAnrRunnable == null) {
                    this.mAnrRunnable = new NotRespondingRunnable();
                }
                if (sAnrHandler == null) {
                    sAnrHandler = new Handler(Looper.getMainLooper(), null, true);
                }
                Binder.allowBlocking(this.mContentProvider.asBinder());
            } else {
                this.mAnrRunnable = null;
                Binder.defaultBlocking(this.mContentProvider.asBinder());
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private void beforeRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.postDelayed(this.mAnrRunnable, this.mAnrTimeout);
        }
    }

    private void afterRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.removeCallbacks(this.mAnrRunnable);
        }
    }

    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        return this.query(url, projection, selection, selectionArgs, sortOrder, null);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) throws RemoteException {
        Bundle queryArgs = ContentResolver.createSqlQueryBundle(selection, selectionArgs, sortOrder);
        return this.query(uri, projection, queryArgs, cancellationSignal);
    }

    @Override
    public Cursor query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) throws RemoteException {
        Objects.requireNonNull(uri, "url");
        this.beforeRemote();
        try {
            Cursor cursor;
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = this.mContentProvider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            if ((cursor = this.mContentProvider.query(this.mPackageName, this.mAttributionTag, uri, projection, queryArgs, remoteCancellationSignal)) == null) {
                Cursor cursor2 = null;
                return cursor2;
            }
            CursorWrapperInner cursorWrapperInner = new CursorWrapperInner(cursor);
            return cursorWrapperInner;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public String getType(Uri url) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            String string2 = this.mContentProvider.getType(url);
            return string2;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public String[] getStreamTypes(Uri url, String mimeTypeFilter) throws RemoteException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(mimeTypeFilter, "mimeTypeFilter");
        this.beforeRemote();
        try {
            String[] stringArray = this.mContentProvider.getStreamTypes(url, mimeTypeFilter);
            return stringArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public Uri canonicalize(Uri url) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.canonicalize(this.mPackageName, this.mAttributionTag, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public Uri uncanonicalize(Uri url) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.uncanonicalize(this.mPackageName, this.mAttributionTag, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public boolean refresh(Uri url, Bundle extras, CancellationSignal cancellationSignal) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = this.mContentProvider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            boolean bl = this.mContentProvider.refresh(this.mPackageName, this.mAttributionTag, url, extras, remoteCancellationSignal);
            return bl;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public int checkUriPermission(Uri uri, int uid, int modeFlags) throws RemoteException {
        Objects.requireNonNull(uri, "uri");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.checkUriPermission(this.mPackageName, this.mAttributionTag, uri, uid, modeFlags);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public Uri insert(Uri url, ContentValues initialValues) throws RemoteException {
        return this.insert(url, initialValues, null);
    }

    @Override
    public Uri insert(Uri url, ContentValues initialValues, Bundle extras) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.insert(this.mPackageName, this.mAttributionTag, url, initialValues, extras);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public int bulkInsert(Uri url, ContentValues[] initialValues) throws RemoteException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(initialValues, "initialValues");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.bulkInsert(this.mPackageName, this.mAttributionTag, url, initialValues);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public int delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        return this.delete(url, ContentResolver.createSqlQueryBundle(selection, selectionArgs));
    }

    @Override
    public int delete(Uri url, Bundle extras) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.delete(this.mPackageName, this.mAttributionTag, url, extras);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        return this.update(url, values, ContentResolver.createSqlQueryBundle(selection, selectionArgs));
    }

    @Override
    public int update(Uri url, ContentValues values, Bundle extras) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.update(this.mPackageName, this.mAttributionTag, url, values, extras);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public ParcelFileDescriptor openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.openFile(url, mode, null);
    }

    @Override
    public ParcelFileDescriptor openFile(Uri url, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(mode, "mode");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            ParcelFileDescriptor parcelFileDescriptor = this.mContentProvider.openFile(this.mPackageName, this.mAttributionTag, url, mode, remoteSignal, null);
            return parcelFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public AssetFileDescriptor openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.openAssetFile(url, mode, null);
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri url, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(mode, "mode");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openAssetFile(this.mPackageName, this.mAttributionTag, url, mode, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts) throws RemoteException, FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, mimeType, opts, null);
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        return this.openTypedAssetFile(uri, mimeType, opts, signal);
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(mimeTypeFilter, "mimeTypeFilter");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openTypedAssetFile(this.mPackageName, this.mAttributionTag, uri, mimeTypeFilter, opts, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        return this.applyBatch(this.mAuthority, operations);
    }

    @Override
    public ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Objects.requireNonNull(operations, "operations");
        this.beforeRemote();
        try {
            ContentProviderResult[] contentProviderResultArray = this.mContentProvider.applyBatch(this.mPackageName, this.mAttributionTag, authority, operations);
            return contentProviderResultArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public Bundle call(String method, String arg, Bundle extras) throws RemoteException {
        return this.call(this.mAuthority, method, arg, extras);
    }

    @Override
    public Bundle call(String authority, String method, String arg, Bundle extras) throws RemoteException {
        Objects.requireNonNull(authority, "authority");
        Objects.requireNonNull(method, "method");
        this.beforeRemote();
        try {
            Bundle bundle = this.mContentProvider.call(this.mPackageName, this.mAttributionTag, authority, method, arg, extras);
            return bundle;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public void close() {
        this.closeInternal();
    }

    @Deprecated
    public boolean release() {
        return this.closeInternal();
    }

    private boolean closeInternal() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.setDetectNotResponding(0L);
            if (this.mStable) {
                return this.mContentResolver.releaseProvider(this.mContentProvider);
            }
            return this.mContentResolver.releaseUnstableProvider(this.mContentProvider);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public ContentProvider getLocalContentProvider() {
        return ContentProvider.coerceToLocalContentProvider(this.mContentProvider);
    }

    @Deprecated
    public static void closeQuietly(ContentProviderClient client) {
        IoUtils.closeQuietly(client);
    }

    @Deprecated
    public static void releaseQuietly(ContentProviderClient client) {
        IoUtils.closeQuietly(client);
    }

    private class CursorWrapperInner
    extends CrossProcessCursorWrapper {
        private final CloseGuard mCloseGuard;

        CursorWrapperInner(Cursor cursor) {
            super(cursor);
            this.mCloseGuard = CloseGuard.get();
            this.mCloseGuard.open("close");
        }

        @Override
        public void close() {
            this.mCloseGuard.close();
            super.close();
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private class NotRespondingRunnable
    implements Runnable {
        private NotRespondingRunnable() {
        }

        @Override
        public void run() {
            Log.w(ContentProviderClient.TAG, "Detected provider not responding: " + ContentProviderClient.this.mContentProvider);
            ContentProviderClient.this.mContentResolver.appNotRespondingViaProvider(ContentProviderClient.this.mContentProvider);
        }
    }
}

