/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class KotlinLineBreakpointBase
extends LineBreakpoint<JavaLineBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance(KotlinLineBreakpointBase.class);

    protected KotlinLineBreakpointBase(Project project, XBreakpoint xBreakpoint) {
        super(project, xBreakpoint);
    }

    @Nullable
    private static BreakpointRequest createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcess) {
        if (requestor == null) {
            KotlinLineBreakpointBase.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            KotlinLineBreakpointBase.$$$reportNull$$$0(1);
        }
        if (location != null) {
            RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
            BreakpointRequest request = requestsManager.createBreakpointRequest(requestor, location);
            requestsManager.enableRequest((EventRequest)request);
            return request;
        }
        return null;
    }

    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        if (!((Boolean)ReadAction.compute(() -> this.isInScopeOf(debugProcess, classType.name()))).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(classType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
            }
            return;
        }
        try {
            List locations = debugProcess.getPositionManager().locationsOfLine(classType, this.getSourcePosition());
            if (!locations.isEmpty()) {
                locations = ((StreamEx)((StreamEx)StreamEx.of((Collection)locations).peek(loc -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found location [codeIndex=" + loc.codeIndex() + "] for reference type " + classType.name() + " at line " + this.getLineIndex() + "; isObsolete: " + (debugProcess.getVirtualMachineProxy().versionHigher("1.4") && loc.method().isObsolete()));
                    }
                })).filter(l -> this.acceptLocation(debugProcess, classType, (Location)l))).toList();
                for (Location loc2 : locations) {
                    KotlinLineBreakpointBase.createLocationBreakpointRequest((FilteredRequestor)this, loc2, debugProcess);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Created breakpoint request for reference type " + classType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + loc2.codeIndex());
                }
            } else if (DebuggerUtilsEx.allLineLocations((ReferenceType)classType) == null) {
                debugProcess.getRequestsManager().setInvalid((Requestor)this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.no.line.info", (Object[])new Object[]{classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No line number info in " + classType.name());
                }
            } else {
                debugProcess.getRequestsManager().setInvalid((Requestor)this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No locations of type " + classType.name() + " found at line " + this.getLineIndex());
                }
            }
        }
        catch (ClassNotPreparedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + ex.getMessage());
            }
        }
        catch (ObjectCollectedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
        this.updateUI();
    }

    private boolean isInScopeOf(DebugProcessImpl debugProcess, String className) {
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            VirtualFile breakpointFile = position.getFile().getVirtualFile();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (breakpointFile != null && fileIndex.isUnderSourceRootOfType(breakpointFile, JavaModuleSourceRootTypes.SOURCES)) {
                if (debugProcess.getSearchScope().contains(breakpointFile)) {
                    return true;
                }
                Collection<VirtualFile> candidates = this.findClassCandidatesInSourceContent(className, debugProcess.getSearchScope(), fileIndex);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + (candidates == null ? "null" : Integer.valueOf(candidates.size())) + " candidate containing files for class " + className);
                }
                if (candidates == null) {
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    GlobalSearchScope scope = debugProcess.getSearchScope();
                    boolean contains = scope.contains(breakpointFile);
                    List files = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className, scope), aClass -> aClass.getContainingFile().getVirtualFile());
                    List allFiles = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className, (GlobalSearchScope)new EverythingGlobalScope(this.myProject)), aClass -> aClass.getContainingFile().getVirtualFile());
                    VirtualFile contentRoot = fileIndex.getContentRootForFile(breakpointFile);
                    Module module = fileIndex.getModuleForFile(breakpointFile);
                    LOG.debug("Did not find '" + className + "' in " + scope + "; contains=" + contains + "; contentRoot=" + contentRoot + "; module = " + module + "; all files in index are: " + files + "; all possible files are: " + allFiles);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> findClassCandidatesInSourceContent(String className, GlobalSearchScope scope, ProjectFileIndex fileIndex) {
        int dollarIndex = className.indexOf("$");
        String topLevelClassName = dollarIndex >= 0 ? className.substring(0, dollarIndex) : className;
        return (Collection)ReadAction.compute(() -> {
            PsiClass[] classes = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(topLevelClassName, scope);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found " + classes.length + " classes " + topLevelClassName + " in scope " + scope);
            }
            if (classes.length == 0) {
                return null;
            }
            ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(classes.length);
            for (PsiClass aClass : classes) {
                PsiFile psiFile = aClass.getContainingFile();
                if (LOG.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Checking class ").append(aClass.getQualifiedName());
                    msg.append("\n\t").append("PsiFile=").append(psiFile);
                    if (psiFile != null) {
                        VirtualFile vFile = psiFile.getVirtualFile();
                        msg.append("\n\t").append("VirtualFile=").append(vFile);
                        if (vFile != null) {
                            msg.append("\n\t").append("isInSourceContent=").append(fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES));
                        }
                    }
                    LOG.debug(msg.toString());
                }
                if (psiFile == null) {
                    return null;
                }
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile == null || !fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES)) {
                    return null;
                }
                list.add(vFile);
            }
            return list;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "requestor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debugProcess";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointBase";
        objectArray[2] = "createLocationBreakpointRequest";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

