/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.trello.TrelloIconBuilder;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloTask
extends Task {
    private static final TrelloIconBuilder ourIconBuilder = new TrelloIconBuilder(16);
    private final TrelloCard myCard;
    private final TaskRepository myRepository;

    public TrelloTask(TrelloCard card, TaskRepository repository) {
        this.myCard = card;
        this.myRepository = repository;
    }

    @NotNull
    public String getId() {
        return this.myCard.getId();
    }

    @NotNull
    public String getSummary() {
        return this.myCard.getName();
    }

    @Nullable
    public String getDescription() {
        return this.myCard.getDescription();
    }

    public Comment @NotNull [] getComments() {
        List<TrelloCommentAction> comments = this.myCard.getComments();
        return comments.toArray(Comment.EMPTY_ARRAY);
    }

    @NotNull
    public Icon getIcon() {
        return ourIconBuilder.buildIcon(this.myCard.getColors());
    }

    @NotNull
    public TaskType getType() {
        return TaskType.OTHER;
    }

    @Nullable
    public Date getUpdated() {
        return this.myCard.getDateLastActivity();
    }

    @Nullable
    public Date getCreated() {
        return null;
    }

    public boolean isClosed() {
        return this.myCard.isClosed() || !this.myCard.isVisible();
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        return this.myCard.getUrl();
    }

    public String getPresentableName() {
        return this.myCard.getName();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    @NotNull
    public String getNumber() {
        return this.myCard.getIdShort();
    }
}

