/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskUtil;
import org.jetbrains.annotations.NotNull;

public class CreateChangelistAction
extends BaseTaskAction {
    @Override
    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        if (event.getPresentation().isEnabled()) {
            TaskManager manager = CreateChangelistAction.getTaskManager(event);
            Presentation presentation = event.getPresentation();
            if (manager == null || !manager.isVcsEnabled()) {
                presentation.setText(this.getTemplatePresentation().getText());
                presentation.setEnabled(false);
            } else {
                presentation.setEnabled(true);
                if (manager.getActiveTask().getChangeLists().size() == 0) {
                    presentation.setText("Create changelist for '" + TaskUtil.getTrimmedSummary((Task)manager.getActiveTask()) + "'");
                } else {
                    presentation.setText("Add changelist for '" + TaskUtil.getTrimmedSummary((Task)manager.getActiveTask()) + "'");
                }
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        TaskManagerImpl manager = (TaskManagerImpl)CreateChangelistAction.getTaskManager(e);
        assert (manager != null);
        LocalTask activeTask = manager.getActiveTask();
        String name = Messages.showInputDialog((Project)CreateChangelistAction.getProject(e), (String)"Changelist name:", (String)"Create Changelist", null, (String)manager.getChangelistName((Task)activeTask), null);
        if (name != null) {
            manager.createChangeList(activeTask, name);
        }
    }
}

