/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.actions.CloseTaskDialog;
import com.intellij.tasks.impl.TaskManagerImpl;
import org.jetbrains.annotations.NotNull;

public class CloseTaskAction
extends BaseTaskAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        CustomTaskState taskState;
        Project project = e.getProject();
        assert (project != null);
        TaskManagerImpl taskManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        LocalTask task = taskManager.getActiveTask();
        CloseTaskDialog dialog = new CloseTaskDialog(project, task);
        if (dialog.showAndGet() && (taskState = dialog.getCloseIssueState()) != null) {
            try {
                TaskRepository repository = task.getRepository();
                assert (repository != null);
                repository.setTaskState((Task)task, taskState);
                repository.setPreferredCloseTaskState(taskState);
            }
            catch (Exception e1) {
                Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)"Cannot Set State For Issue");
            }
        }
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = CloseTaskAction.getProject(event);
        boolean enabled = project != null && !TaskManager.getManager((Project)project).getActiveTask().isDefault();
        presentation.setEnabled(enabled);
    }
}

