/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.spellchecker.quickfixes.DictionarySuggestionProvider;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.awt.Component;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    public RenameTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        return RenameTo.getFixName();
    }

    @Nullable
    private static DictionarySuggestionProvider findProvider() {
        for (Object extension : NameSuggestionProvider.EP_NAME.getExtensionList()) {
            if (!(extension instanceof DictionarySuggestionProvider)) continue;
            return (DictionarySuggestionProvider)((Object)extension);
        }
        return null;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        return Anchor.FIRST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        DictionarySuggestionProvider provider = RenameTo.findProvider();
        if (provider != null) {
            provider.setActive(true);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        Editor editor = this.getEditor(psiElement, project);
        if (editor == null) {
            return;
        }
        if (editor instanceof EditorWindow) {
            map.put(CommonDataKeys.EDITOR.getName(), editor);
            map.put(CommonDataKeys.PSI_ELEMENT.getName(), psiElement);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            map.put(CommonDataKeys.PSI_ELEMENT.getName(), new TextEditorPsiDataProvider().getData(CommonDataKeys.PSI_ELEMENT.getName(), editor, editor.getCaretModel().getCurrentCaret()));
        }
        Boolean selectAll = (Boolean)editor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        try {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)true);
            DataContext dataContext = SimpleDataContext.getSimpleContext(map, (DataContext)DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            RenameElementAction action = new RenameElementAction();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)dataContext);
            action.actionPerformed(event);
            if (provider != null) {
                provider.setActive(false);
            }
        }
        finally {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)selectAll);
        }
    }

    public static String getFixName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }
}

