/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.statistics.SpellcheckerLookupUsageDescriptor;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import org.jetbrains.annotations.NotNull;

public class ChangeTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    public ChangeTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        return ChangeTo.getFixName();
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        return Anchor.FIRST;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            TextRange textRange;
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            if (editor == null) {
                return;
            }
            if (InjectedLanguageManager.getInstance((Project)project).getInjectionHost(element) != null && !(editor instanceof EditorWindow)) {
                editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)element.getContainingFile());
            }
            if ((textRange = ((ProblemDescriptorBase)descriptor).getTextRange()) == null) {
                return;
            }
            int documentLength = editor.getDocument().getTextLength();
            int endOffset = ChangeTo.getDocumentOffset(textRange.getEndOffset(), documentLength);
            int startOffset = ChangeTo.getDocumentOffset(textRange.getStartOffset(), documentLength);
            editor.getSelectionModel().setSelection(startOffset, endOffset);
            String word = editor.getSelectionModel().getSelectedText();
            if (word == null || StringUtil.isEmpty((String)word)) {
                return;
            }
            LookupElement[] items = (LookupElement[])this.getSuggestions(project).stream().map(LookupElementBuilder::create).toArray(LookupElement[]::new);
            LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)project).showLookup(editor, items);
            if (lookup != null) {
                lookup.putUserDataIfAbsent(SpellcheckerLookupUsageDescriptor.Companion.getSPELLCHECKER_KEY(), (Object)true);
            }
        });
    }

    private static int getDocumentOffset(int offset, int documentLength) {
        return offset >= 0 && offset <= documentLength ? offset : documentLength;
    }

    public static String getFixName() {
        return SpellCheckerBundle.message("change.to", new Object[0]);
    }
}

