/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.PreDiffPlan;
import com.google.archivepatcher.shared.JreDeflateParameters;
import com.google.archivepatcher.shared.PatchConstants;
import com.google.archivepatcher.shared.TypedRange;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PatchWriter {
    private final PreDiffPlan plan;
    private final long deltaFriendlyOldFileSize;
    private final long deltaFriendlyNewFileSize;
    private final File deltaFile;

    public PatchWriter(PreDiffPlan plan, long deltaFriendlyOldFileSize, long deltaFriendlyNewFileSize, File deltaFile) {
        this.plan = plan;
        this.deltaFriendlyOldFileSize = deltaFriendlyOldFileSize;
        this.deltaFriendlyNewFileSize = deltaFriendlyNewFileSize;
        this.deltaFile = deltaFile;
    }

    public void writeV1Patch(OutputStream out) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.write("GFbFv1_0".getBytes("US-ASCII"));
        dataOut.writeInt(0);
        dataOut.writeLong(this.deltaFriendlyOldFileSize);
        dataOut.writeInt(this.plan.getOldFileUncompressionPlan().size());
        for (TypedRange<Void> typedRange : this.plan.getOldFileUncompressionPlan()) {
            dataOut.writeLong(typedRange.getOffset());
            dataOut.writeLong(typedRange.getLength());
        }
        dataOut.writeInt(this.plan.getDeltaFriendlyNewFileRecompressionPlan().size());
        for (TypedRange<Void> typedRange : this.plan.getDeltaFriendlyNewFileRecompressionPlan()) {
            dataOut.writeLong(typedRange.getOffset());
            dataOut.writeLong(typedRange.getLength());
            dataOut.write(PatchConstants.CompatibilityWindowId.DEFAULT_DEFLATE.patchValue);
            dataOut.write(((JreDeflateParameters)typedRange.getMetadata()).level);
            dataOut.write(((JreDeflateParameters)typedRange.getMetadata()).strategy);
            dataOut.write(((JreDeflateParameters)typedRange.getMetadata()).nowrap ? 1 : 0);
        }
        dataOut.writeInt(1);
        dataOut.write(PatchConstants.DeltaFormat.BSDIFF.patchValue);
        dataOut.writeLong(0L);
        dataOut.writeLong(this.deltaFriendlyOldFileSize);
        dataOut.writeLong(0L);
        dataOut.writeLong(this.deltaFriendlyNewFileSize);
        dataOut.writeLong(this.deltaFile.length());
        Throwable throwable = null;
        try (FileInputStream deltaFileIn = new FileInputStream(this.deltaFile);
             BufferedInputStream deltaIn = new BufferedInputStream(deltaFileIn);){
            byte[] buffer = new byte[32768];
            int numRead = 0;
            while ((numRead = deltaIn.read(buffer)) >= 0) {
                dataOut.write(buffer, 0, numRead);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        dataOut.flush();
    }
}

