/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.stream.ChunkedStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "pageFileExtensions", "", "", "getPageFileExtensions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "processSsi", "", "file", "Ljava/nio/file/Path;", "path", "intellij.platform.builtInServer.impl"})
final class StaticFileHandler
extends WebServerFileHandler {
    @NotNull
    private final String[] pageFileExtensions = new String[]{"html", "htm", "shtml", "stm", "shtm"};
    private SsiProcessor ssiProcessor;

    @Override
    @NotNull
    public String[] getPageFileExtensions() {
        return this.pageFileExtensions;
    }

    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        block12: {
            Path path;
            block11: {
                if (pathInfo.getIoFile() != null) break block11;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block12;
            }
            if ((path = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                path = Paths.get(virtualFile.getPath(), new String[0]);
            }
            Path ioFile = path;
            String nameSequence = ((Object)ioFile.getFileName()).toString();
            if (StringsKt.endsWith((String)nameSequence, (String)".shtml", (boolean)true) || StringsKt.endsWith((String)nameSequence, (String)".stm", (boolean)true) || StringsKt.endsWith((String)nameSequence, (String)".shtm", (boolean)true)) {
                this.processSsi(ioFile, PathUtilRt.getParentPath((String)((Object)canonicalPath).toString()), project, request, channel, extraHeaders);
                return true;
            }
            FileResponses.INSTANCE.sendFile((HttpRequest)request, channel, ioFile, extraHeaders);
            return true;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile file = virtualFile;
        HttpResponse httpResponse = FileResponses.INSTANCE.prepareSend((HttpRequest)request, channel, file.getTimeStamp(), file.getName(), extraHeaders);
        if (httpResponse == null) {
            return true;
        }
        HttpResponse response = httpResponse;
        boolean isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)((HttpRequest)request));
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file.getLength());
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            channel.write((Object)new ChunkedStream(file.getInputStream()));
        }
        FileResponsesKt.flushChunkedResponse((Channel)channel, (boolean)isKeepAlive);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(Path file, String path, Project project, FullHttpRequest request, Channel channel, HttpHeaders extraHeaders) {
        boolean releaseBuffer;
        boolean isKeepAlive;
        ByteBuf buffer;
        block9: {
            long lastModified;
            if (this.ssiProcessor == null) {
                this.ssiProcessor = new SsiProcessor();
            }
            buffer = channel.alloc().ioBuffer();
            isKeepAlive = false;
            releaseBuffer = true;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            if (ssiProcessor == null) {
                Intrinsics.throwNpe();
            }
            if (FileResponses.INSTANCE.prepareSend((HttpRequest)request, channel, lastModified = ssiProcessor.process(new SsiExternalResolver(project, (HttpRequest)request, path, file.getParent()), file, new ByteBufUtf8Writer(buffer)), ((Object)file.getFileName()).toString(), extraHeaders) != null) break block9;
            buffer.release();
            return;
        }
        try {
            HttpResponse httpResponse;
            HttpResponse response = httpResponse;
            isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)((HttpRequest)request));
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        FileResponsesKt.flushChunkedResponse((Channel)channel, (boolean)isKeepAlive);
    }
}

