/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.NetUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c\u001a*\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&\u001a\u0010\u0010%\u001a\u0004\u0018\u00010(2\u0006\u0010'\u001a\u00020(\u001a\b\u0010)\u001a\u00020\u0017H\u0000\u001a\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0001H\u0000\u001a\u001a\u0010,\u001a\u0004\u0018\u00010\u00012\u0006\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020/H\u0002\u001a \u00100\u001a\u0004\u0018\u0001012\u0006\u0010 \u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0017\u001a\n\u00105\u001a\u00020\u0017*\u000202\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0011\u0010\u0012\"N\u0010\u0014\u001aB\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00170\u0017 \u0016* \u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"IDE_TOKEN_FILE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "STANDARD_COOKIE", "Lio/netty/handler/codec/http/cookie/DefaultCookie;", "getSTANDARD_COOKIE", "()Lio/netty/handler/codec/http/cookie/DefaultCookie;", "STANDARD_COOKIE$delegate", "Lkotlin/Lazy;", "TOKEN_HEADER_NAME", "TOKEN_PARAM_NAME", "notificationManager", "Lcom/intellij/notification/SingletonNotificationManager;", "getNotificationManager", "()Lcom/intellij/notification/SingletonNotificationManager;", "notificationManager$delegate", "tokens", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "", "acquireToken", "compareNameAndProjectBasePath", "projectName", "project", "Lcom/intellij/openapi/project/Project;", "doProcess", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectNameAsHost", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "Ljava/nio/file/Path;", "isActivatable", "isOwnHostName", "host", "toIdeaPath", "decodedPath", "offset", "", "validateToken", "Lio/netty/handler/codec/http/HttpHeaders;", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "isSignedRequest", "intellij.platform.builtInServer.impl"})
public final class BuiltInWebServerKt {
    @NotNull
    private static final Logger LOG;
    private static final String IDE_TOKEN_FILE = "user.web.token";
    private static final Lazy notificationManager$delegate;
    @NotNull
    public static final String TOKEN_PARAM_NAME = "_ijt";
    @NotNull
    public static final String TOKEN_HEADER_NAME = "x-ijt";
    private static final Lazy STANDARD_COOKIE$delegate;
    private static final Cache<String, Boolean> tokens;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final SingletonNotificationManager getNotificationManager() {
        Lazy lazy = notificationManager$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (SingletonNotificationManager)lazy.getValue();
    }

    public static final boolean isActivatable() {
        return Registry.is((String)"ide.built.in.web.server.activatable", (boolean)false);
    }

    private static final DefaultCookie getSTANDARD_COOKIE() {
        Lazy lazy = STANDARD_COOKIE$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (DefaultCookie)lazy.getValue();
    }

    @NotNull
    public static final String acquireToken() {
        String token = (String)CollectionsKt.firstOrNull((Iterable)tokens.asMap().keySet());
        if (token == null) {
            token = DigestUtil.randomToken();
            tokens.put((Object)token, (Object)Boolean.TRUE);
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean doProcess(QueryStringDecoder urlDecoder, FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
        block19: {
            decodedPath = urlDecoder.path();
            offset = 0;
            isEmptyPath = false;
            isCustomHost = projectNameAsHost != null;
            projectName = null;
            if (isCustomHost) {
                v0 = projectNameAsHost;
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                projectName = v0;
                offset = 0;
                var9_9 = decodedPath;
                var10_10 = 0;
                isEmptyPath = var9_9.length() == 0;
            } else {
                offset = StringsKt.indexOf$default((CharSequence)decodedPath, (char)'/', (int)1, (boolean)false, (int)4, null);
                var9_9 = decodedPath;
                var10_10 = 1;
                var11_12 = offset == -1 ? decodedPath.length() : offset;
                var12_14 = false;
                v1 = var9_9;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v2 = v1.substring(var10_10, var11_12);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                projectName = v2;
                isEmptyPath = offset == -1;
            }
            candidateByDirectoryName = null;
            $this$firstOrNull$iv = ProjectManager.getInstance().getOpenProjects();
            $i$f$firstOrNull = false;
            var13_16 = $this$firstOrNull$iv;
            var14_17 = var13_16.length;
            for (var15_19 = 0; var15_19 < var14_17; ++var15_19) {
                block21: {
                    block22: {
                        block20: {
                            project = element$iv = var13_16[var15_19];
                            $i$a$-firstOrNull-BuiltInWebServerKt$doProcess$project$1 = false;
                            if (!project.isDisposed()) break block20;
                            v3 = false;
                            break block21;
                        }
                        name = project.getName();
                        if (!isCustomHost) break block22;
                        if (!StringsKt.equals((String)projectName, (String)name, (boolean)true)) ** GOTO lbl-1000
                        if (!SystemInfo.isFileSystemCaseSensitive) {
                            projectName = name;
                        }
                        v3 = true;
                        break block21;
                    }
                    if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)name, (int)0, (int)name.length(), (boolean)(SystemInfo.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                    v4 = isEmptyPathCandidate = decodedPath.length() == name.length() + 1;
                    if (isEmptyPathCandidate || decodedPath.charAt(name.length() + 1) == '/') {
                        projectName = name;
                        offset = name.length() + 1;
                        isEmptyPath = isEmptyPathCandidate;
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if (candidateByDirectoryName == null && BuiltInWebServerKt.compareNameAndProjectBasePath(projectName, project)) {
                            candidateByDirectoryName = project;
                        }
                        v3 = false;
                    }
                }
                if (!v3) continue;
                v5 = element$iv;
                break block19;
            }
            v5 = v6 = null;
        }
        if (v5 == null) {
            v6 = candidateByDirectoryName;
        }
        if (v6 == null) {
            return false;
        }
        project = v6;
        if (BuiltInWebServerKt.isActivatable() && !PropertiesComponent.getInstance().getBoolean("ide.built.in.web.server.active")) {
            BuiltInWebServerKt.getNotificationManager().notify(BuiltInServerBundle.message((String)"notification.content.built.in.web.server.is.deactivated", (Object[])new Object[0]), null);
            return false;
        }
        if (isEmptyPath) {
            WebServerPathHandlerKt.redirectToDirectory((HttpRequest)request, context.channel(), projectName, null);
            return true;
        }
        path = BuiltInWebServerKt.toIdeaPath(decodedPath, offset);
        if (path == null) {
            Responses.send$default((HttpResponseStatus)Responses.orInSafeMode((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (HttpResponseStatus)HttpResponseStatus.NOT_FOUND), (Channel)context.channel(), (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        for (WebServerPathHandler pathHandler : WebServerPathHandler.Companion.getEP_NAME$intellij_platform_builtInServer_impl().getExtensionList()) {
            $this$runAndLogException$iv = BuiltInWebServerKt.LOG;
            $i$f$runAndLogException = false;
            try {
                $i$a$-runAndLogException-BuiltInWebServerKt$doProcess$1 = false;
                if (!pathHandler.process(path, project, request, context, projectName, decodedPath, isCustomHost)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (CancellationException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (Throwable e$iv) {
                $this$runAndLogException$iv.error(e$iv);
            }
        }
        return false;
    }

    public static final boolean isSignedRequest(@NotNull HttpRequest $this$isSignedRequest) {
        String string;
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return true;
        }
        String string2 = $this$isSignedRequest.headers().get(TOKEN_HEADER_NAME);
        if (string2 == null) {
            List list = (List)new QueryStringDecoder($this$isSignedRequest.uri()).parameters().get(TOKEN_PARAM_NAME);
            string2 = string = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
        }
        if (string2 == null) {
            String string3 = NettyKt.getReferrer((HttpRequest)$this$isSignedRequest);
            if (string3 != null) {
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                List list = (List)new QueryStringDecoder(it).parameters().get(TOKEN_PARAM_NAME);
                string = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
            } else {
                string = null;
            }
        }
        String token = string;
        return token != null && tokens.getIfPresent((Object)token) != null;
    }

    @Nullable
    public static final HttpHeaders validateToken(@NotNull HttpRequest request, @NotNull Channel channel, boolean isSignedRequest) {
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
        }
        String string = request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            for (Cookie cookie : ServerCookieDecoder.STRICT.decode(it)) {
                if (!Intrinsics.areEqual((Object)cookie.name(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().name())) continue;
                if (!Intrinsics.areEqual((Object)cookie.value(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().value())) break;
                return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
            }
        }
        if (isSignedRequest) {
            return new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)(ServerCookieEncoder.STRICT.encode((Cookie)BuiltInWebServerKt.getSTANDARD_COOKIE()) + "; SameSite=strict"));
        }
        QueryStringDecoder urlDecoder = new QueryStringDecoder(request.uri());
        if (!StringsKt.endsWith$default((String)urlDecoder.path(), (String)"/favicon.ico", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append(NettyKt.getUriScheme((Channel)channel)).append("://");
            String string3 = NettyKt.getHost((HttpRequest)request);
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String url = stringBuilder.append(string3).append(urlDecoder.path()).toString();
            SwingUtilities.invokeAndWait(new Runnable(url){
                final /* synthetic */ String $url;

                public final void run() {
                    ProjectUtil.focusProjectWindow(null, (boolean)true);
                    if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"", (String)BuiltInServerBundle.message((String)"dialog.message.page", (Object[])new Object[]{StringUtil.trimMiddle((String)this.$url, (int)50)})).icon(Messages.getWarningIcon())).yesText(BuiltInServerBundle.message((String)"dialog.button.copy.authorization.url.to.clipboard", (Object[])new Object[0]))).show() == 0) {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.$url + "?" + "_ijt" + "=" + BuiltInWebServerKt.acquireToken()));
                    }
                }
                {
                    this.$url = string;
                }
            });
        }
        Responses.send$default((HttpResponseStatus)Responses.orInSafeMode((HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (HttpResponseStatus)HttpResponseStatus.NOT_FOUND), (Channel)channel, (HttpRequest)request, null, null, (int)12, null);
        return null;
    }

    private static final String toIdeaPath(String decodedPath, int offset) {
        String string = decodedPath;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(offset);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String path = string3;
        if (!StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        string = FileUtil.toCanonicalPath((String)path, (char)'/');
        n = 1;
        boolean bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        return string5;
    }

    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        String basePath = project.getBasePath();
        return basePath != null && FileUtilKt.endsWithName((String)basePath, (String)projectName);
    }

    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        VirtualFile[] children2;
        block7: {
            block6: {
                children2 = basedir.getChildren();
                if (children2 == null) break block6;
                VirtualFile[] virtualFileArray = children2;
                int n = 0;
                if (!(virtualFileArray.length == 0)) break block7;
            }
            return null;
        }
        for (String indexNamePrefix : new String[]{"index.", "default."}) {
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (VirtualFile child : children2) {
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final Path findIndexFile(@NotNull Path basedir) {
        Iterable iterable;
        Path path = basedir;
        Function1 filter$iv = findIndexFile.children.1.INSTANCE;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    return (Boolean)this.$filter.invoke((Object)it);
                }
            });
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Iterable it = (DirectoryStream)closeable;
                boolean bl3 = false;
                it = CollectionsKt.toList((Iterable)it);
                iterable = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = null;
        }
        if (iterable == null) {
            return null;
        }
        Iterable children2 = iterable;
        for (String indexNamePrefix : new String[]{"index.", "default."}) {
            Path index = null;
            String preferredName = indexNamePrefix + "html";
            for (Path child : children2) {
                if (PathKt.isDirectory((Path)child)) continue;
                String name = ((Object)child.getFileName()).toString();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@NotNull String host) {
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress()) || StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return StringsKt.equals((String)localHostName, (String)host, (boolean)true) || StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2, null) && StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    static {
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(BuiltInWebServer.class);
        notificationManager$delegate = LazyKt.lazy((Function0)notificationManager.2.INSTANCE);
        STANDARD_COOKIE$delegate = LazyKt.lazy((Function0)STANDARD_COOKIE.2.INSTANCE);
        tokens = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    public static final /* synthetic */ boolean access$doProcess(QueryStringDecoder urlDecoder, FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
        return BuiltInWebServerKt.doProcess(urlDecoder, request, context, projectNameAsHost);
    }
}

