/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.watchFaceService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"myAnalogWatchFaceServiceJava", "", "isInteractive", "", "packageName", "serviceClass", "useAndroidX", "intellij.android.wizardTemplate.impl"})
public final class MyAnalogWatchFaceServiceJavaKt {
    @NotNull
    public static final String myAnalogWatchFaceServiceJava(boolean isInteractive2, @NotNull String packageName, @NotNull String serviceClass2, boolean useAndroidX) {
        String string;
        String string2;
        boolean bl;
        String it$iv;
        boolean bl2;
        String string3;
        boolean bl3;
        String string4;
        String string5;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder().append("\npackage ").append(packageName).append(";\n\nimport android.content.BroadcastReceiver;\nimport android.content.Context;\nimport android.content.Intent;\nimport android.content.IntentFilter;\nimport android.graphics.Bitmap;\nimport android.graphics.BitmapFactory;\nimport android.graphics.Canvas;\nimport android.graphics.Color;\nimport android.graphics.ColorMatrix;\nimport android.graphics.ColorMatrixColorFilter;\nimport android.graphics.Paint;\nimport android.graphics.Rect;\nimport android.os.Bundle;\nimport android.os.Handler;\nimport android.os.Message;\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.support.v7.graphics.Palette", useAndroidX)).append(";\nimport android.support.wearable.watchface.CanvasWatchFaceService;\nimport android.support.wearable.watchface.WatchFaceService;\nimport android.support.wearable.watchface.WatchFaceStyle;\nimport android.view.SurfaceHolder;\n");
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isInteractive2) {
            stringBuilder = stringBuilder2;
            boolean bl4 = false;
            string5 = "import android.widget.Toast;";
            stringBuilder2 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string3 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string3 = string4;
            if (string3 == null) {
                string3 = "";
            }
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append("\n\nimport java.lang.ref.WeakReference;\nimport java.util.Calendar;\nimport java.util.TimeZone;\nimport java.util.concurrent.TimeUnit;\n\n/**\n * Analog watch face with a ticking second hand. In ambient mode, the second hand isn\"t\n * shown. On devices with low-bit ambient mode, the hands are drawn without anti-aliasing in ambient\n * mode. The watch face is drawn with less contrast in mute mode.\n *\n * Important Note: Because watch face apps do not have a default Activity in\n * their project, you will need to set your Configurations to\n * \"Do not launch Activity\" for both the Wear and/or Application modules. If you\n * are unsure how to do this, please review the \"Run Starter project\" section\n * in the Google Watch Face Code Lab:\n * https://codelabs.developers.google.com/codelabs/watchface/index.html#0\n */\npublic class ").append(serviceClass2).append(" extends CanvasWatchFaceService {\n\n    /*\n     * Updates rate in milliseconds for interactive mode. We update once a second to advance the\n     * second hand.\n     */\n    private static final long INTERACTIVE_UPDATE_RATE_MS = TimeUnit.SECONDS.toMillis(1);\n\n    /**\n     * Handler message id for updating the time periodically in interactive mode.\n     */\n    private static final int MSG_UPDATE_TIME = 0;\n\n    @Override\n    public Engine onCreateEngine() {\n        return new Engine();\n    }\n\n    private class Engine extends CanvasWatchFaceService.Engine {\n        private static final float HOUR_STROKE_WIDTH = 5f;\n        private static final float MINUTE_STROKE_WIDTH = 3f;\n        private static final float SECOND_TICK_STROKE_WIDTH = 2f;\n\n        private static final float CENTER_GAP_AND_CIRCLE_RADIUS = 4f;\n\n        private static final int SHADOW_RADIUS = 6;\n\n        private Calendar mCalendar;\n        private boolean mRegisteredTimeZoneReceiver = false;\n        private boolean mMuteMode;\n\n        private float mCenterX;\n        private float mCenterY;\n\n        private float mSecondHandLength;\n        private float sMinuteHandLength;\n        private float sHourHandLength;\n\n        /* Colors for all hands (hour, minute, seconds, ticks) based on photo loaded. */\n        private int mWatchHandColor;\n        private int mWatchHandHighlightColor;\n        private int mWatchHandShadowColor;\n\n        private Paint mHourPaint;\n        private Paint mMinutePaint;\n        private Paint mSecondPaint;\n        private Paint mTickAndCirclePaint;\n\n        private Paint mBackgroundPaint;\n        private Bitmap mBackgroundBitmap;\n        private Bitmap mGrayBackgroundBitmap;\n\n        private boolean mAmbient;\n        private boolean mLowBitAmbient;\n        private boolean mBurnInProtection;\n\n        private final BroadcastReceiver mTimeZoneReceiver = new BroadcastReceiver() {\n            @Override\n            public void onReceive(Context context, Intent intent) {\n                mCalendar.setTimeZone(TimeZone.getDefault());\n                invalidate();\n            }\n        };\n\n        /* Handler to update the time once a second in interactive mode. */\n        private final Handler mUpdateTimeHandler = new EngineHandler(this);\n\n        @Override\n        public void onCreate(SurfaceHolder holder) {\n            super.onCreate(holder);\n\n            setWatchFaceStyle(new WatchFaceStyle.Builder(").append(serviceClass2).append(".this)\n                     ");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive2) {
            stringBuilder = stringBuilder3;
            boolean bl5 = false;
            string5 = ".setAcceptsTapEvents(true)";
            stringBuilder3 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string2 = string4;
            if (string2 == null) {
                string2 = "";
            }
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string2).append("\n                    .build());\n\n            mCalendar = Calendar.getInstance();\n\n            initializeBackground();\n            initializeWatchFace();\n        }\n\n        private void initializeBackground() {\n            mBackgroundPaint = new Paint();\n            mBackgroundPaint.setColor(Color.BLACK);\n            mBackgroundBitmap = BitmapFactory.decodeResource(getResources(), R.drawable.watchface_service_bg);\n\n            /* Extracts colors from background image to improve watchface style. */\n            Palette.from(mBackgroundBitmap).generate(new Palette.PaletteAsyncListener() {\n                @Override\n                public void onGenerated(Palette palette) {\n                    if (palette != null) {\n                        mWatchHandHighlightColor = palette.getVibrantColor(Color.RED);\n                        mWatchHandColor = palette.getLightVibrantColor(Color.WHITE);\n                        mWatchHandShadowColor = palette.getDarkMutedColor(Color.BLACK);\n                        updateWatchHandStyle();\n                    }\n                }\n            });\n        }\n\n        private void initializeWatchFace() {\n            /* Set defaults for colors */\n            mWatchHandColor = Color.WHITE;\n            mWatchHandHighlightColor = Color.RED;\n            mWatchHandShadowColor = Color.BLACK;\n\n            mHourPaint = new Paint();\n            mHourPaint.setColor(mWatchHandColor);\n            mHourPaint.setStrokeWidth(HOUR_STROKE_WIDTH);\n            mHourPaint.setAntiAlias(true);\n            mHourPaint.setStrokeCap(Paint.Cap.ROUND);\n            mHourPaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n\n            mMinutePaint = new Paint();\n            mMinutePaint.setColor(mWatchHandColor);\n            mMinutePaint.setStrokeWidth(MINUTE_STROKE_WIDTH);\n            mMinutePaint.setAntiAlias(true);\n            mMinutePaint.setStrokeCap(Paint.Cap.ROUND);\n            mMinutePaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n\n            mSecondPaint = new Paint();\n            mSecondPaint.setColor(mWatchHandHighlightColor);\n            mSecondPaint.setStrokeWidth(SECOND_TICK_STROKE_WIDTH);\n            mSecondPaint.setAntiAlias(true);\n            mSecondPaint.setStrokeCap(Paint.Cap.ROUND);\n            mSecondPaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n\n            mTickAndCirclePaint = new Paint();\n            mTickAndCirclePaint.setColor(mWatchHandColor);\n            mTickAndCirclePaint.setStrokeWidth(SECOND_TICK_STROKE_WIDTH);\n            mTickAndCirclePaint.setAntiAlias(true);\n            mTickAndCirclePaint.setStyle(Paint.Style.STROKE);\n            mTickAndCirclePaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n        }\n\n        @Override\n        public void onDestroy() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME);\n            super.onDestroy();\n        }\n\n        @Override\n        public void onPropertiesChanged(Bundle properties) {\n            super.onPropertiesChanged(properties);\n            mLowBitAmbient = properties.getBoolean(PROPERTY_LOW_BIT_AMBIENT, false);\n            mBurnInProtection = properties.getBoolean(PROPERTY_BURN_IN_PROTECTION, false);\n        }\n\n        @Override\n        public void onTimeTick() {\n            super.onTimeTick();\n            invalidate();\n        }\n\n        @Override\n        public void onAmbientModeChanged(boolean inAmbientMode) {\n            super.onAmbientModeChanged(inAmbientMode);\n            mAmbient = inAmbientMode;\n\n            updateWatchHandStyle();\n\n            /* Check and trigger whether or not timer should be running (only in active mode). */\n            updateTimer();\n        }\n\n        private void updateWatchHandStyle(){\n            if (mAmbient){\n                mHourPaint.setColor(Color.WHITE);\n                mMinutePaint.setColor(Color.WHITE);\n                mSecondPaint.setColor(Color.WHITE);\n                mTickAndCirclePaint.setColor(Color.WHITE);\n\n                mHourPaint.setAntiAlias(false);\n                mMinutePaint.setAntiAlias(false);\n                mSecondPaint.setAntiAlias(false);\n                mTickAndCirclePaint.setAntiAlias(false);\n\n                mHourPaint.clearShadowLayer();\n                mMinutePaint.clearShadowLayer();\n                mSecondPaint.clearShadowLayer();\n                mTickAndCirclePaint.clearShadowLayer();\n\n            } else {\n                mHourPaint.setColor(mWatchHandColor);\n                mMinutePaint.setColor(mWatchHandColor);\n                mSecondPaint.setColor(mWatchHandHighlightColor);\n                mTickAndCirclePaint.setColor(mWatchHandColor);\n\n                mHourPaint.setAntiAlias(true);\n                mMinutePaint.setAntiAlias(true);\n                mSecondPaint.setAntiAlias(true);\n                mTickAndCirclePaint.setAntiAlias(true);\n\n                mHourPaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n                mMinutePaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n                mSecondPaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n                mTickAndCirclePaint.setShadowLayer(SHADOW_RADIUS, 0, 0, mWatchHandShadowColor);\n            }\n        }\n\n        @Override\n        public void onInterruptionFilterChanged(int interruptionFilter) {\n            super.onInterruptionFilterChanged(interruptionFilter);\n            boolean inMuteMode = (interruptionFilter == WatchFaceService.INTERRUPTION_FILTER_NONE);\n\n            /* Dim display in mute mode. */\n            if (mMuteMode != inMuteMode) {\n                mMuteMode = inMuteMode;\n                mHourPaint.setAlpha(inMuteMode ? 100 : 255);\n                mMinutePaint.setAlpha(inMuteMode ? 100 : 255);\n                mSecondPaint.setAlpha(inMuteMode ? 80 : 255);\n                invalidate();\n            }\n        }\n\n        @Override\n        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {\n            super.onSurfaceChanged(holder, format, width, height);\n\n            /*\n             * Find the coordinates of the center point on the screen, and ignore the window\n             * insets, so that, on round watches with a \"chin\", the watch face is centered on the\n             * entire screen, not just the usable portion.\n             */\n            mCenterX = width / 2f;\n            mCenterY = height / 2f;\n\n            /*\n             * Calculate lengths of different hands based on watch screen size.\n             */\n            mSecondHandLength = (float) (mCenterX * 0.875);\n            sMinuteHandLength = (float) (mCenterX * 0.75);\n            sHourHandLength = (float) (mCenterX * 0.5);\n\n\n            /* Scale loaded background image (more efficient) if surface dimensions change. */\n            float scale = ((float) width) / (float) mBackgroundBitmap.getWidth();\n\n            mBackgroundBitmap = Bitmap.createScaledBitmap(mBackgroundBitmap,\n                    (int) (mBackgroundBitmap.getWidth() * scale),\n                    (int) (mBackgroundBitmap.getHeight() * scale), true);\n\n            /*\n             * Create a gray version of the image only if it will look nice on the device in\n             * ambient mode. That means we don\"t want devices that support burn-in\n             * protection (slight movements in pixels, not great for images going all the way to\n             * edges) and low ambient mode (degrades image quality).\n             *\n             * Also, if your watch face will know about all images ahead of time (users aren\"t\n             * selecting their own photos for the watch face), it will be more\n             * efficient to create a black/white version (png, etc.) and load that when you need it.\n             */\n            if (!mBurnInProtection && !mLowBitAmbient) {\n                initGrayBackgroundBitmap();\n            }\n        }\n\n        private void initGrayBackgroundBitmap() {\n            mGrayBackgroundBitmap = Bitmap.createBitmap(\n                    mBackgroundBitmap.getWidth(),\n                    mBackgroundBitmap.getHeight(),\n                    Bitmap.Config.ARGB_8888);\n            Canvas canvas = new Canvas(mGrayBackgroundBitmap);\n            Paint grayPaint = new Paint();\n            ColorMatrix colorMatrix = new ColorMatrix();\n            colorMatrix.setSaturation(0);\n            ColorMatrixColorFilter filter = new ColorMatrixColorFilter(colorMatrix);\n            grayPaint.setColorFilter(filter);\n            canvas.drawBitmap(mBackgroundBitmap, 0, 0, grayPaint);\n        }\n");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive2) {
            stringBuilder = stringBuilder4;
            boolean bl6 = false;
            string5 = "\n        /**\n         * Captures tap event (and tap type). The {@link WatchFaceService#TAP_TYPE_TAP} case can be\n         * used for implementing specific logic to handle the gesture.\n         */\n        @Override\n        public void onTapCommand(int tapType, int x, int y, long eventTime) {\n            switch (tapType) {\n                case TAP_TYPE_TOUCH:\n                    // The user has started touching the screen.\n                    break;\n                case TAP_TYPE_TOUCH_CANCEL:\n                    // The user has started a different gesture or otherwise cancelled the tap.\n                    break;\n                case TAP_TYPE_TAP:\n                    // The user has completed the tap gesture.\n                    // TODO: Add code to handle the tap gesture.\n                    Toast.makeText(getApplicationContext(), R.string.message, Toast.LENGTH_SHORT)\n                            .show();\n                    break;\n            }\n            invalidate();\n        }\n";
            stringBuilder4 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string = string4;
            if (string == null) {
                string = "";
            }
        }
        return stringBuilder4.append(string).append("\n\n        @Override\n        public void onDraw(Canvas canvas, Rect bounds) {\n            long now = System.currentTimeMillis();\n            mCalendar.setTimeInMillis(now);\n\n            drawBackground(canvas);\n            drawWatchFace(canvas);\n        }\n\n        private void drawBackground(Canvas canvas) {\n\n            if (mAmbient && (mLowBitAmbient || mBurnInProtection)) {\n                canvas.drawColor(Color.BLACK);\n            } else if (mAmbient) {\n                canvas.drawBitmap(mGrayBackgroundBitmap, 0, 0, mBackgroundPaint);\n            } else {\n                canvas.drawBitmap(mBackgroundBitmap, 0, 0, mBackgroundPaint);\n            }\n        }\n\n        private void drawWatchFace(Canvas canvas) {\n\n            /*\n             * Draw ticks. Usually you will want to bake this directly into the photo, but in\n             * cases where you want to allow users to select their own photos, this dynamically\n             * creates them on top of the photo.\n             */\n            float innerTickRadius = mCenterX - 10;\n            float outerTickRadius = mCenterX;\n            for (int tickIndex = 0; tickIndex < 12; tickIndex++) {\n                float tickRot = (float) (tickIndex * Math.PI * 2 / 12);\n                float innerX = (float) Math.sin(tickRot) * innerTickRadius;\n                float innerY = (float) -Math.cos(tickRot) * innerTickRadius;\n                float outerX = (float) Math.sin(tickRot) * outerTickRadius;\n                float outerY = (float) -Math.cos(tickRot) * outerTickRadius;\n                canvas.drawLine(mCenterX + innerX, mCenterY + innerY,\n                        mCenterX + outerX, mCenterY + outerY, mTickAndCirclePaint);\n            }\n\n            /*\n             * These calculations reflect the rotation in degrees per unit of time, e.g.,\n             * 360 / 60 = 6 and 360 / 12 = 30.\n             */\n            final float seconds =\n                    (mCalendar.get(Calendar.SECOND) + mCalendar.get(Calendar.MILLISECOND) / 1000f);\n            final float secondsRotation = seconds * 6f;\n\n            final float minutesRotation = mCalendar.get(Calendar.MINUTE) * 6f;\n\n            final float hourHandOffset = mCalendar.get(Calendar.MINUTE) / 2f;\n            final float hoursRotation = (mCalendar.get(Calendar.HOUR) * 30) + hourHandOffset;\n\n            /*\n             * Save the canvas state before we can begin to rotate it.\n             */\n            canvas.save();\n\n            canvas.rotate(hoursRotation, mCenterX, mCenterY);\n            canvas.drawLine(\n                    mCenterX,\n                    mCenterY - CENTER_GAP_AND_CIRCLE_RADIUS,\n                    mCenterX,\n                    mCenterY - sHourHandLength,\n                    mHourPaint);\n\n            canvas.rotate(minutesRotation - hoursRotation, mCenterX, mCenterY);\n            canvas.drawLine(\n                    mCenterX,\n                    mCenterY - CENTER_GAP_AND_CIRCLE_RADIUS,\n                    mCenterX,\n                    mCenterY - sMinuteHandLength,\n                    mMinutePaint);\n\n            /*\n             * Ensure the \"seconds\" hand is drawn only when we are in interactive mode.\n             * Otherwise, we only update the watch face once a minute.\n             */\n            if (!mAmbient) {\n                canvas.rotate(secondsRotation - minutesRotation, mCenterX, mCenterY);\n                canvas.drawLine(\n                        mCenterX,\n                        mCenterY - CENTER_GAP_AND_CIRCLE_RADIUS,\n                        mCenterX,\n                        mCenterY - mSecondHandLength,\n                        mSecondPaint);\n\n            }\n            canvas.drawCircle(\n                    mCenterX,\n                    mCenterY,\n                    CENTER_GAP_AND_CIRCLE_RADIUS,\n                    mTickAndCirclePaint);\n\n            /* Restore the canvas\" original orientation. */\n            canvas.restore();\n        }\n\n        @Override\n        public void onVisibilityChanged(boolean visible) {\n            super.onVisibilityChanged(visible);\n\n            if (visible) {\n                registerReceiver();\n                /* Update time zone in case it changed while we weren\"t visible. */\n                mCalendar.setTimeZone(TimeZone.getDefault());\n                invalidate();\n            } else {\n                unregisterReceiver();\n            }\n\n            /* Check and trigger whether or not timer should be running (only in active mode). */\n            updateTimer();\n        }\n\n        private void registerReceiver() {\n            if (mRegisteredTimeZoneReceiver) {\n                return;\n            }\n            mRegisteredTimeZoneReceiver = true;\n            IntentFilter filter = new IntentFilter(Intent.ACTION_TIMEZONE_CHANGED);\n            ").append(serviceClass2).append(".this.registerReceiver(mTimeZoneReceiver, filter);\n        }\n\n        private void unregisterReceiver() {\n            if (!mRegisteredTimeZoneReceiver) {\n                return;\n            }\n            mRegisteredTimeZoneReceiver = false;\n            ").append(serviceClass2).append(".this.unregisterReceiver(mTimeZoneReceiver);\n        }\n\n        /**\n         * Starts/stops the {@link #mUpdateTimeHandler} timer based on the state of the watch face.\n         */\n        private void updateTimer() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME);\n            if (shouldTimerBeRunning()) {\n                mUpdateTimeHandler.sendEmptyMessage(MSG_UPDATE_TIME);\n            }\n        }\n\n        /**\n         * Returns whether the {@link #mUpdateTimeHandler} timer should be running. The timer\n         * should only run in active mode.\n         */\n        private boolean shouldTimerBeRunning() {\n            return isVisible() && !mAmbient;\n        }\n\n        /**\n         * Handle updating the time periodically in interactive mode.\n         */\n        private void handleUpdateTimeMessage() {\n            invalidate();\n            if (shouldTimerBeRunning()) {\n                long timeMs = System.currentTimeMillis();\n                long delayMs = INTERACTIVE_UPDATE_RATE_MS\n                        - (timeMs % INTERACTIVE_UPDATE_RATE_MS);\n                mUpdateTimeHandler.sendEmptyMessageDelayed(MSG_UPDATE_TIME, delayMs);\n            }\n        }\n    }\n\n    private static class EngineHandler extends Handler {\n        private final WeakReference<").append(serviceClass2).append(".Engine> mWeakReference;\n\n        public EngineHandler(").append(serviceClass2).append(".Engine reference) {\n            mWeakReference = new WeakReference<>(reference);\n        }\n\n        @Override\n        public void handleMessage(Message msg) {\n            ").append(serviceClass2).append(".Engine engine = mWeakReference.get();\n            if (engine != null) {\n                switch (msg.what) {\n                    case MSG_UPDATE_TIME:\n                        engine.handleUpdateTimeMessage();\n                        break;\n                }\n            }\n        }\n    }\n}\n").toString();
    }
}

