/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.instantapps.sdk.api;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import javax.annotation.Nullable;

public interface HandlerResult {
    public Severity getSeverity();

    public boolean isFatal();

    public boolean isError();

    public String getMessage();

    @Nullable
    public String getSplitName();

    @Nullable
    public String getFilename();

    @Nullable
    public String getDetail();

    public ImmutableList<Hyperlink> getLinks();

    public static interface Hyperlink {
        public String getTitle();

        public URI getHref();
    }

    public static enum Severity {
        FATAL(4),
        ERROR(3),
        WARNING(2),
        INFO(1);

        private final int code;

        private Severity(int code) {
            this.code = code;
        }

        public boolean worseThan(Severity other) {
            return this.code > other.code;
        }
    }
}

