/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import org.gradle.internal.impldep.org.simpleframework.http.core.ArrayConsumer;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.Allocator;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.Buffer;

class BoundaryConsumer
extends ArrayConsumer {
    private static final byte[] LAST = new byte[]{45, 45, 13, 10};
    private static final byte[] LINE = new byte[]{13, 10};
    private static final byte[] TOKEN = new byte[]{45, 45};
    private Allocator allocator;
    private Buffer buffer;
    private byte[] boundary;
    private int seek;

    public BoundaryConsumer(Allocator allocator, byte[] boundary) {
        this.chunk = boundary.length + 6;
        this.allocator = allocator;
        this.boundary = boundary;
    }

    protected Buffer allocate() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate(this.chunk);
        }
        return this.buffer;
    }

    protected void process() throws IOException {
        this.append(TOKEN);
        this.append(this.boundary);
        if (this.seek == this.chunk) {
            this.append(TOKEN);
        }
        this.append(LINE);
    }

    protected int scan() throws IOException {
        int size = this.boundary.length;
        if (this.count >= size + 4) {
            if (this.array[size + 2] == LAST[0]) {
                return this.boundary(LAST);
            }
            return this.boundary(LINE);
        }
        return 0;
    }

    private int boundary(byte[] terminal) throws IOException {
        int size = this.boundary.length + 2;
        if (this.count >= size + terminal.length) {
            this.scan(TOKEN);
            this.scan(this.boundary);
            this.scan(terminal);
            this.done = true;
            return this.count - this.seek;
        }
        return 0;
    }

    private boolean scan(byte[] data) throws IOException {
        int size = data.length;
        int pos = 0;
        while (this.seek < this.count) {
            if (this.array[this.seek++] != data[pos++]) {
                throw new IOException("Invalid boundary");
            }
            if (pos != data.length) continue;
            return true;
        }
        return pos == size;
    }

    public boolean isEnd() {
        return this.seek == this.chunk;
    }

    public void clear() {
        this.done = false;
        this.seek = 0;
        this.count = 0;
    }
}

