/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.NonRecursiveVisitor;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public abstract class Instance {
    protected final long mId;
    protected final StackTrace mStack;
    long mClassId;
    Heap mHeap;
    int mSize;
    long mNativeSize;
    int mTopologicalOrder;
    int mDistanceToGcRoot = Integer.MAX_VALUE;
    Instance mNextInstanceToGcRoot = null;
    private Instance mImmediateDominator;
    private long[] mRetainedSizes;
    protected final ArrayList<Instance> mHardForwardReferences = new ArrayList();
    protected Instance mSoftForwardReference = null;
    protected final ArrayList<Instance> mHardReverseReferences = new ArrayList();
    protected ArrayList<Instance> mSoftReverseReferences = null;

    Instance(long id, StackTrace stackTrace) {
        this.mId = id;
        this.mStack = stackTrace;
    }

    public abstract void resolveReferences();

    public abstract void accept(Visitor var1);

    public void compactMemory() {
        this.mHardReverseReferences.trimToSize();
        if (this.mSoftReverseReferences != null) {
            this.mSoftReverseReferences.trimToSize();
        }
    }

    public long getId() {
        return this.mId;
    }

    public long getUniqueId() {
        return this.getId() & this.mHeap.mSnapshot.getIdSizeMask();
    }

    public void setClassId(long classId) {
        this.mClassId = classId;
    }

    public ClassObj getClassObj() {
        return this.mHeap.mSnapshot.findClass(this.mClassId);
    }

    public final int getCompositeSize() {
        CompositeSizeVisitor visitor2 = new CompositeSizeVisitor();
        visitor2.doVisit((Iterable<? extends Instance>)ImmutableList.of((Object)this));
        return visitor2.getCompositeSize();
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public long getNativeSize() {
        return this.mNativeSize;
    }

    public void setNativeSize(long nativeSize) {
        this.mNativeSize = nativeSize;
    }

    public void setHeap(Heap heap) {
        this.mHeap = heap;
    }

    public Heap getHeap() {
        return this.mHeap;
    }

    public int getTopologicalOrder() {
        return this.mTopologicalOrder;
    }

    public void setTopologicalOrder(int topologicalOrder) {
        this.mTopologicalOrder = topologicalOrder;
    }

    public Instance getImmediateDominator() {
        return this.mImmediateDominator;
    }

    public void setImmediateDominator(Instance dominator) {
        this.mImmediateDominator = dominator;
    }

    public int getDistanceToGcRoot() {
        return this.mDistanceToGcRoot;
    }

    public Instance getNextInstanceToGcRoot() {
        return this.mNextInstanceToGcRoot;
    }

    public void setDistanceToGcRoot(int newDistance) {
        assert (newDistance < this.mDistanceToGcRoot);
        this.mDistanceToGcRoot = newDistance;
    }

    public void setNextInstanceToGcRoot(Instance instance) {
        this.mNextInstanceToGcRoot = instance;
    }

    public boolean isReachable() {
        return this.mDistanceToGcRoot != Integer.MAX_VALUE;
    }

    public void resetRetainedSize() {
        ArrayList<Heap> allHeaps = this.mHeap.mSnapshot.mHeaps;
        if (this.mRetainedSizes == null) {
            this.mRetainedSizes = new long[allHeaps.size()];
        } else {
            Arrays.fill(this.mRetainedSizes, 0L);
        }
        this.mRetainedSizes[allHeaps.indexOf((Object)this.mHeap)] = (long)this.getSize() + this.getNativeSize();
    }

    public void addRetainedSize(int heapIndex, long size) {
        int n = heapIndex;
        this.mRetainedSizes[n] = this.mRetainedSizes[n] + size;
    }

    public void addRetainedSizes(Instance other) {
        for (int i = 0; i < this.mRetainedSizes.length; ++i) {
            int n = i;
            this.mRetainedSizes[n] = this.mRetainedSizes[n] + other.mRetainedSizes[i];
        }
    }

    public long getRetainedSize(int heapIndex) {
        return this.mRetainedSizes[heapIndex];
    }

    public long getTotalRetainedSize() {
        if (this.mRetainedSizes == null) {
            return 0L;
        }
        long totalSize = 0L;
        for (long mRetainedSize : this.mRetainedSizes) {
            totalSize += mRetainedSize;
        }
        return totalSize;
    }

    public void addReverseReference(Field field, Instance reference) {
        if (field != null && field.getName().equals("referent") && reference.getIsSoftReference()) {
            if (this.mSoftReverseReferences == null) {
                this.mSoftReverseReferences = new ArrayList();
            }
            this.mSoftReverseReferences.add(reference);
        } else {
            this.mHardReverseReferences.add(reference);
        }
    }

    public ArrayList<Instance> getHardForwardReferences() {
        return this.mHardForwardReferences;
    }

    public Instance getSoftForwardReference() {
        return this.mSoftForwardReference;
    }

    public ArrayList<Instance> getHardReverseReferences() {
        return this.mHardReverseReferences;
    }

    public ArrayList<Instance> getSoftReverseReferences() {
        return this.mSoftReverseReferences;
    }

    public void dedupeReferences() {
        HashSet<Instance> dedupeSet = new HashSet<Instance>(this.mHardReverseReferences.size());
        dedupeSet.addAll(this.mHardReverseReferences);
        dedupeSet.remove(this);
        this.mHardReverseReferences.clear();
        this.mHardReverseReferences.addAll(dedupeSet);
        this.mHardReverseReferences.trimToSize();
        if (this.getSoftReverseReferences() != null) {
            dedupeSet.clear();
            dedupeSet.addAll(this.getSoftReverseReferences());
            this.mSoftReverseReferences.clear();
            this.mSoftReverseReferences.addAll(dedupeSet);
            this.mSoftReverseReferences.trimToSize();
        }
    }

    public boolean getIsSoftReference() {
        return false;
    }

    protected Object readValue(Type type) {
        switch (type) {
            case OBJECT: {
                long id = this.readId();
                return this.mHeap.mSnapshot.findInstance(id);
            }
            case BOOLEAN: {
                return this.getBuffer().readByte() != 0;
            }
            case CHAR: {
                return Character.valueOf(this.getBuffer().readChar());
            }
            case FLOAT: {
                return Float.valueOf(this.getBuffer().readFloat());
            }
            case DOUBLE: {
                return this.getBuffer().readDouble();
            }
            case BYTE: {
                return this.getBuffer().readByte();
            }
            case SHORT: {
                return this.getBuffer().readShort();
            }
            case INT: {
                return this.getBuffer().readInt();
            }
            case LONG: {
                return this.getBuffer().readLong();
            }
        }
        return null;
    }

    protected long readId() {
        switch (this.mHeap.mSnapshot.getTypeSize(Type.OBJECT)) {
            case 1: {
                return this.getBuffer().readByte();
            }
            case 2: {
                return this.getBuffer().readShort();
            }
            case 4: {
                return this.getBuffer().readInt();
            }
            case 8: {
                return this.getBuffer().readLong();
            }
        }
        return 0L;
    }

    protected int readUnsignedByte() {
        return UnsignedBytes.toInt((byte)this.getBuffer().readByte());
    }

    protected int readUnsignedShort() {
        return this.getBuffer().readShort() & 0xFFFF;
    }

    protected DataBuffer getBuffer() {
        return this.mHeap.mSnapshot.getBuffer();
    }

    public StackTrace getStack() {
        return this.mStack;
    }

    public static class CompositeSizeVisitor
    extends NonRecursiveVisitor {
        int mSize = 0;

        @Override
        protected void defaultAction(Instance node) {
            this.mSize = (int)((long)this.mSize + ((long)node.getSize() + node.getNativeSize()));
        }

        public int getCompositeSize() {
            return this.mSize;
        }
    }
}

