/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/SharedPrefsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class SharedPrefsDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"getStringSet");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        if (!context2.getEvaluator().isMemberInClass((PsiMember)method, "android.content.SharedPreferences")) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true);
        if (uMethod == null) {
            return;
        }
        UMethod surrounding = uMethod;
        surrounding.accept((UastVisitor)new DataFlowAnalyzer(context2, node, CollectionsKt.listOf((Object)node), SetsKt.emptySet()){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $node;

            public void receiver(@NotNull UCallExpression call) {
                String string = Lint.getMethodName(call);
                if (string == null) {
                    return;
                }
                String methodName = string;
                if (StringsKt.startsWith$default((String)methodName, (String)"add", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)methodName, (String)"remove", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)methodName, (Object)"retainAll") || Intrinsics.areEqual((Object)methodName, (Object)"clear")) {
                    JavaContext.report$default(this.$context, SharedPrefsDetector.ISSUE, (UElement)call, this.$context.getLocation((UElement)call), "Do not modify the set returned by `SharedPreferences.getStringSet()``", null, 16, null);
                }
            }
            {
                this.$context = $captured_local_variable$0;
                this.$node = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        });
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(SharedPrefsDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default(Issue.Companion, "MutatingSharedPrefs", "Mutating an Immutable SharedPrefs Set", "\n                As stated in the docs for `SharedPreferences.getStringSet`, you must \\\n                not modify the set returned by `getStringSet`:\n\n                  \"Note that you <em>must not</em> modify the set instance returned \\\n                   by this call.  The consistency of the stored data is not guaranteed \\\n                   if you do, nor is your ability to modify the instance at all.\"\n                ", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3344, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/SharedPrefsDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

