/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/ScopedStorageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "cachedStoragePermissions", "Lcom/android/tools/lint/checks/ScopedStorageDetector$StoragePermissions;", "getApplicableElements", "", "", "getMaxSdk", "", "element", "Lorg/w3c/dom/Element;", "getStoragePermissions", "context", "Lcom/android/tools/lint/detector/api/Context;", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "Companion", "StoragePermissions", "android.sdktools.lint-checks"})
public final class ScopedStorageDetector
extends Detector
implements XmlScanner {
    private StoragePermissions cachedStoragePermissions;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr permission = attr;
        if (Intrinsics.areEqual((Object)permission.getValue(), (Object)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            int n = context2.getMainProject().getTargetSdk();
            int n2 = this.getMaxSdk(element);
            boolean bl = false;
            int sdk = Math.min(n, n2);
            if (sdk < 29) {
                return;
            }
            StoragePermissions storagePermissions = this.getStoragePermissions(context2);
            if (storagePermissions == null) {
                return;
            }
            StoragePermissions permissions = storagePermissions;
            if (permissions.getCanManageStorage()) {
                return;
            }
            if (sdk == 29 && permissions.getRequestedLegacyStorage()) {
                return;
            }
            String msg = "WRITE_EXTERNAL_STORAGE no longer provides write access when targeting ";
            msg = msg + (permissions.getRequestedLegacyStorage() ? "Android 11+, even when using `requestLegacyExternalStorage`" : (sdk == 29 ? "Android 10, unless you use `requestLegacyExternalStorage`" : "Android 10+"));
            Context.report$default(context2, ISSUE, context2.getValueLocation(permission), msg, null, 8, null);
        }
        if (Intrinsics.areEqual((Object)permission.getValue(), (Object)"android.permission.MANAGE_EXTERNAL_STORAGE")) {
            Context.report$default(context2, ISSUE, context2.getValueLocation(permission), "Most apps are not allowed to use MANAGE_EXTERNAL_STORAGE", null, 8, null);
        }
    }

    private final int getMaxSdk(Element element) {
        Attr maxSdkAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "maxSdkVersion");
        Object object = maxSdkAttr;
        return object != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : Integer.MAX_VALUE;
    }

    /*
     * Unable to fully structure code
     */
    private final StoragePermissions getStoragePermissions(Context context) {
        v0 = this.cachedStoragePermissions;
        if (v0 != null) {
            var2_2 = v0;
            var3_4 = false;
            var4_6 = false;
            it = var2_2;
            $i$a$-let-ScopedStorageDetector$getStoragePermissions$1 = false;
            return it;
        }
        v1 = context.getMainProject().getMergedManifest();
        if (v1 == null) {
            return null;
        }
        manifest = v1;
        canManageStorage = false;
        requestedLegacyStorage = false;
        var6_11 = DomExtensions.iterator((Element)manifest.getDocumentElement());
        while (var6_11.hasNext()) {
            tag = (Element)var6_11.next();
            if (tag.getNodeName() == null) continue;
            switch (var7_13.hashCode()) {
                case 599862896: {
                    if (!var7_13.equals("uses-permission")) ** break;
                    break;
                }
                case 1554253136: {
                    if (!var7_13.equals("application") || !Intrinsics.areEqual((Object)(legacy = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "requestLegacyExternalStorage")), (Object)"true")) ** break;
                    requestedLegacyStorage = true;
                    ** break;
                }
            }
            permission = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            if (!Intrinsics.areEqual((Object)permission, (Object)"android.permission.MANAGE_EXTERNAL_STORAGE")) ** break;
            canManageStorage = true;
            ** break;
lbl31:
            // 6 sources

        }
        var5_9 = new StoragePermissions(canManageStorage, requestedLegacyStorage);
        var6_12 = false;
        var7_14 = false;
        it = var5_9;
        $i$a$-also-ScopedStorageDetector$getStoragePermissions$2 = false;
        this.cachedStoragePermissions = it;
        return var5_9;
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        String string = "https://developer.android.com/preview/privacy/storage#scoped-storage";
        boolean bl = false;
        Implementation implementation = new Implementation(ScopedStorageDetector.class, Scope.MANIFEST_SCOPE);
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 8;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default(Issue.Companion, "ScopedStorage", "Affected by scoped storage", "\n                Scoped storage is enforced on Android 10+ (or Android 11+ if using \\\n                `requestLegacyExternalStorage`). In particular, `WRITE_EXTERNAL_STORAGE` \\\n                will no longer provide write access to all files; it will provide the \\\n                equivalent of `READ_EXTERNAL_STORAGE` instead.\n\n                The `MANAGE_EXTERNAL_STORAGE` permission can be used to manage all files, but \\\n                it is rarely necessary and most apps on Google Play are not allowed to use it. \\\n                Most apps should instead migrate to use scoped storage. To modify or delete files, \\\n                apps should request write access from the user as described at \\\n                https://developer.android.com/reference/android/provider/MediaStore#createWriteRequest.\n            ", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3328, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ScopedStorageDetector$StoragePermissions;", "", "canManageStorage", "", "requestedLegacyStorage", "(ZZ)V", "getCanManageStorage", "()Z", "getRequestedLegacyStorage", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    private static final class StoragePermissions {
        private final boolean canManageStorage;
        private final boolean requestedLegacyStorage;

        public final boolean getCanManageStorage() {
            return this.canManageStorage;
        }

        public final boolean getRequestedLegacyStorage() {
            return this.requestedLegacyStorage;
        }

        public StoragePermissions(boolean canManageStorage, boolean requestedLegacyStorage) {
            this.canManageStorage = canManageStorage;
            this.requestedLegacyStorage = requestedLegacyStorage;
        }

        public final boolean component1() {
            return this.canManageStorage;
        }

        public final boolean component2() {
            return this.requestedLegacyStorage;
        }

        @NotNull
        public final StoragePermissions copy(boolean canManageStorage, boolean requestedLegacyStorage) {
            return new StoragePermissions(canManageStorage, requestedLegacyStorage);
        }

        public static /* synthetic */ StoragePermissions copy$default(StoragePermissions storagePermissions, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = storagePermissions.canManageStorage;
            }
            if ((n & 2) != 0) {
                bl2 = storagePermissions.requestedLegacyStorage;
            }
            return storagePermissions.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "StoragePermissions(canManageStorage=" + this.canManageStorage + ", requestedLegacyStorage=" + this.requestedLegacyStorage + ")";
        }

        public int hashCode() {
            int n = this.canManageStorage ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.requestedLegacyStorage ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StoragePermissions)) break block3;
                    StoragePermissions storagePermissions = (StoragePermissions)object;
                    if (this.canManageStorage != storagePermissions.canManageStorage || this.requestedLegacyStorage != storagePermissions.requestedLegacyStorage) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ScopedStorageDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

