/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ResourceCycleDetector;
import com.android.tools.lint.checks.ResourceCycleDetector$WhenMappings;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JH\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0002J,\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\"H\u0016J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001e\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J0\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J(\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J \u0010+\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010,\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u0018H\u0016R(\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "mChains", "", "Lcom/android/resources/ResourceType;", "", "", "mLocations", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/detector/api/Location;", "mReferences", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "checkCrashItem", "Lcom/android/tools/lint/detector/api/XmlContext;", "item", "Lorg/w3c/dom/Element;", "dfs", "map", "from", "visiting", "", "visited", "findCycles", "type", "getApplicableAttributes", "", "getApplicableElements", "getLocationMap", "getTypeMap", "handleReference", "node", "Lorg/w3c/dom/Node;", "to", "recordLocation", "recordReference", "visitAttribute", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Companion", "android.sdktools.lint-checks"})
public final class ResourceCycleDetector
extends ResourceXmlDetector {
    private Map<ResourceType, Multimap<String, String>> mReferences;
    private Map<ResourceType, Multimap<String, Location>> mLocations;
    private Map<ResourceType, List<List<String>>> mChains;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue CYCLE;
    @JvmField
    @NotNull
    public static final Issue CRASH;
    public static final Companion Companion;

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        if (context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.mReferences = Maps.newEnumMap(ResourceType.class);
        }
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.FONT || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    @Nullable
    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "style", "color", "item", "font", "string", "dimen");
    }

    @Override
    @Nullable
    public Collection<String> getApplicableAttributes() {
        return ResourceXmlDetector.ALL;
    }

    private final void recordReference(ResourceType type, String from, String to) {
        String string;
        CharSequence charSequence = to;
        boolean bl = false;
        if (charSequence.length() == 0 || StringsKt.startsWith$default((String)to, (String)"@android:", (boolean)false, (int)2, null)) {
            return;
        }
        Multimap<String, String> multimap = this.getTypeMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, String> map = multimap;
        if (to.charAt(0) == '@') {
            int index = StringsKt.indexOf$default((CharSequence)to, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string2 = to;
                int n = index + 1;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = to;
            }
        } else {
            string = to;
        }
        String name = string;
        map.put((Object)from, (Object)name);
    }

    private final Multimap<String, String> getTypeMap(ResourceType type) {
        Map<ResourceType, Multimap<String, String>> map = this.mReferences;
        if (map == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, String>> references2 = map;
        Multimap<String, String> map2 = references2.get(type);
        if (map2 != null) {
            return map2;
        }
        Multimap newMap2 = (Multimap)Multimaps.newListMultimap((Map)new TreeMap(), (Supplier)getTypeMap.newMap.1.INSTANCE);
        references2.put(type, (Multimap<String, String>)newMap2);
        return newMap2;
    }

    private final void recordLocation(XmlContext context2, Node node, ResourceType type, String from) {
        Multimap<String, Location> multimap = this.getLocationMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, Location> map = multimap;
        Location location = context2.getLocation(node);
        map.put((Object)from, (Object)location);
    }

    private final Multimap<String, Location> getLocationMap(ResourceType type) {
        Map<ResourceType, Multimap<String, Location>> map = this.mLocations;
        if (map == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, Location>> locations = map;
        Multimap<String, Location> map2 = locations.get(type);
        if (map2 != null) {
            return map2;
        }
        Multimap newMap2 = (Multimap)ArrayListMultimap.create((int)30, (int)4);
        locations.put(type, (Multimap<String, Location>)newMap2);
        return newMap2;
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Attr text;
        String tagName = element.getTagName();
        if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
            String drawable;
            if (this.mReferences == null) {
                return;
            }
            ResourceFolderType folderType = context2.getResourceFolderType();
            if (folderType == ResourceFolderType.VALUES) {
                Attr typeNode = element.getAttributeNode("type");
                if (typeNode != null) {
                    String typeName = typeNode.getValue();
                    ResourceType type = ResourceType.fromXmlValue((String)typeName);
                    Attr nameNode2 = element.getAttributeNode("name");
                    if (type != null && nameNode2 != null) {
                        NodeList childNodes2 = element.getChildNodes();
                        int n = childNodes2.getLength();
                        for (int i2 = 0; i2 < n; ++i2) {
                            char c;
                            Node child = childNodes2.item(i2);
                            if (child.getNodeType() != 3) continue;
                            String text2 = child.getNodeValue();
                            int max = text2.length();
                            for (int k = 0; k < max && !Character.isWhitespace(c = text2.charAt(k)) && c == '@' && StringsKt.startsWith$default((String)text2, (String)type.getName(), (int)(k + 1), (boolean)false, (int)4, null); ++k) {
                                String $this$trim$iv = text2;
                                boolean $i$f$trim = false;
                                CharSequence $this$trim$iv$iv = $this$trim$iv;
                                boolean $i$f$trim2 = false;
                                int startIndex$iv$iv = 0;
                                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                boolean startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                String to = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                if (this.mReferences == null) continue;
                                String name = nameNode2.getValue();
                                if (this.mLocations != null) {
                                    this.recordLocation(context2, child, type, name);
                                    continue;
                                }
                                this.recordReference(type, name, to);
                            }
                        }
                    }
                }
            } else if (folderType == ResourceFolderType.COLOR) {
                String color = element.getAttributeNS("http://schemas.android.com/apk/res/android", "color");
                if (color != null && StringsKt.startsWith$default((String)color, (String)"@color/", (boolean)false, (int)2, null)) {
                    String currentColor = Lint.getBaseName(context2.file.getName());
                    Node node = element;
                    String type = color;
                    int nameNode2 = "@color/".length();
                    boolean childNodes2 = false;
                    String string = type.substring(nameNode2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                    this.handleReference(context2, node, ResourceType.COLOR, currentColor, string);
                }
            } else if (folderType == ResourceFolderType.DRAWABLE && (drawable = element.getAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) != null && StringsKt.startsWith$default((String)drawable, (String)"@drawable/", (boolean)false, (int)2, null)) {
                String currentColor = Lint.getBaseName(context2.file.getName());
                Node node = element;
                String type = drawable;
                int nameNode2 = "@drawable/".length();
                boolean childNodes2 = false;
                String string = type.substring(nameNode2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                this.handleReference(context2, node, ResourceType.DRAWABLE, currentColor, string);
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"style")) {
            int index;
            boolean n;
            int i2;
            String name;
            Attr nameNode = element.getAttributeNode("name");
            Attr parentNode = element.getAttributeNode("parent");
            if (parentNode != null && nameNode != null) {
                name = nameNode.getValue();
                String parent = parentNode.getValue();
                if (StringsKt.startsWith$default((String)parent, (String)"@style/", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)parent, (String)name, (int)"@style/".length(), (boolean)false, (int)4, null) && StringsKt.startsWith$default((String)parent, (String)".", (int)("@style/".length() + name.length()), (boolean)false, (int)4, null)) {
                    if (context2.isEnabled(CYCLE) && context2.getDriver().getPhase() == 1) {
                        Node node = parentNode;
                        Location location = context2.getLocation(parentNode);
                        StringBuilder stringBuilder = new StringBuilder().append("Potential cycle: `").append(name).append("` is the implied parent of `");
                        String nameNode2 = parent;
                        int childNodes2 = "@style/".length();
                        boolean i2 = false;
                        String string = nameNode2;
                        if (string == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = string.substring(childNodes2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        XmlContext.report$default(context2, CYCLE, node, location, stringBuilder.append(string2).append("` and ").append("this defines the opposite").toString(), null, 16, null);
                    }
                    return;
                }
                CharSequence nameNode2 = parent;
                boolean childNodes2 = false;
                if (!(nameNode2.length() == 0) && !StringsKt.startsWith$default((String)parent, (String)"@android:style/", (boolean)false, (int)2, null)) {
                    String childNodes2 = parent;
                    i2 = StringsKt.lastIndexOf$default((CharSequence)parent, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                    n = false;
                    String string = childNodes2;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string.substring(i2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String parentName = string3;
                    this.handleReference(context2, parentNode, ResourceType.STYLE, name, parentName);
                    if (StringsKt.startsWith$default((String)parent, (String)"@", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)parent, (CharSequence)"style/", (boolean)false, (int)2, null)) {
                        XmlContext.report$default(context2, CYCLE, parentNode, context2.getLocation(parentNode), "Invalid parent reference: expected a @style", null, 16, null);
                    }
                }
            } else if (this.mReferences != null && nameNode != null && (index = StringsKt.lastIndexOf$default((CharSequence)(name = nameNode.getValue()), (char)'.', (int)0, (boolean)false, (int)6, null)) > 0) {
                String childNodes2 = name;
                i2 = 0;
                n = false;
                String string = childNodes2;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string.substring(i2, index);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String parent = string4;
                if (this.mReferences != null) {
                    if (this.mLocations != null) {
                        Attr node = element.getAttributeNode("name");
                        this.recordLocation(context2, node, ResourceType.STYLE, name);
                    } else {
                        this.recordReference(ResourceType.STYLE, name, parent);
                    }
                }
            }
            if (context2.isEnabled(CRASH) && context2.getDriver().getPhase() == 1) {
                for (Element item : XmlUtils.getSubTags((Node)element)) {
                    if (!Intrinsics.areEqual((Object)"android:id", (Object)item.getAttribute("name"))) continue;
                    this.checkCrashItem(context2, item);
                }
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"include")) {
            String layout;
            Attr layoutNode = element.getAttributeNode("layout");
            if (layoutNode != null && StringsKt.startsWith$default((String)(layout = layoutNode.getValue()), (String)"@layout/", (boolean)false, (int)2, null)) {
                String currentLayout = Lint.getBaseName(context2.file.getName());
                this.handleReference(context2, layoutNode, ResourceType.LAYOUT, currentLayout, layout);
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"color") || Intrinsics.areEqual((Object)tagName, (Object)"string") || Intrinsics.areEqual((Object)tagName, (Object)"dimen")) {
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                char c;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 3) continue;
                String text3 = child.getNodeValue();
                int max = text3.length();
                for (int k = 0; k < max && !Character.isWhitespace(c = text3.charAt(k)) && c == '@' && StringsKt.startsWith$default((String)text3, (String)tagName, (int)(k + 1), (boolean)false, (int)4, null); ++k) {
                    String to;
                    String $this$trim$iv = text3;
                    int $i$f$trim = 0;
                    CharSequence $this$trim$iv$iv22 = $this$trim$iv;
                    boolean $i$f$trim3 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv22.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $this$trim$iv = ((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    $i$f$trim = tagName.length() + 2;
                    boolean $this$trim$iv$iv22 = false;
                    String string = $this$trim$iv;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring($i$f$trim), (String)"(this as java.lang.String).substring(startIndex)");
                    String name = element.getAttribute("name");
                    ResourceType type = ResourceType.fromXmlTagName((String)tagName);
                    if (type == null) continue;
                    this.handleReference(context2, child, type, name, to);
                }
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"font") && (text = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "font")) != null && StringsKt.startsWith$default((String)text.getValue(), (String)"@font/", (boolean)false, (int)2, null)) {
            String $this$trim$iv = text.getValue();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            int n = "@font/".length();
            boolean bl = false;
            String string = $this$trim$iv;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String font = string5;
            String currentFont = Lint.getBaseName(context2.file.getName());
            this.handleReference(context2, text, ResourceType.FONT, currentFont, font);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        ResourceType resourceType = this.mReferences;
        if (resourceType == null) {
            return;
        }
        ResourceType references2 = resourceType;
        int phase = context2.getDriver().getPhase();
        if (phase == 1) {
            ResourceType resourceType2 = references2;
            boolean bl = false;
            Iterator<Map.Entry<ResourceType, Multimap<String, String>>> iterator = resourceType2.entrySet().iterator();
            while (iterator.hasNext()) {
                void type;
                Map.Entry<ResourceType, Multimap<String, String>> entry;
                Map.Entry<ResourceType, Multimap<String, String>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                resourceType2 = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Multimap<String, String> map = entry2.getValue();
                this.findCycles(context2, (ResourceType)type, map);
            }
        } else {
            boolean bl = phase == 2;
            boolean bl3 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ResourceType resourceType3 = this.mChains;
            if (resourceType3 == null) {
                return;
            }
            ResourceType chainsMap = resourceType3;
            Map<ResourceType, Multimap<String, Location>> map = this.mLocations;
            if (map == null) {
                return;
            }
            Map<ResourceType, Multimap<String, Location>> locationMap = map;
            ResourceType resourceType4 = chainsMap;
            boolean bl6 = false;
            Iterator<Map.Entry<ResourceType, List<List<String>>>> iterator = resourceType4.entrySet().iterator();
            while (iterator.hasNext()) {
                void type;
                Map.Entry<ResourceType, List<List<String>>> entry;
                Map.Entry<ResourceType, List<List<String>>> entry3 = entry = iterator.next();
                boolean bl7 = false;
                resourceType4 = entry3.getKey();
                entry3 = entry;
                bl7 = false;
                List<List<String>> chains = entry3.getValue();
                Multimap multimap = locationMap.get(type);
                if (multimap == null) {
                    multimap = (Multimap)ArrayListMultimap.create();
                }
                Multimap locations = multimap;
                for (List<String> chain : chains) {
                    String message2;
                    Location location = null;
                    boolean bl8 = !chain.isEmpty();
                    boolean bl9 = false;
                    boolean bl10 = false;
                    if (_Assertions.ENABLED && !bl8) {
                        boolean bl11 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    int n = chain.size();
                    for (int i = 0; i < n; ++i) {
                        String item = chain.get(i);
                        Collection itemLocations = locations.get((Object)item);
                        if (itemLocations.isEmpty()) continue;
                        Location itemLocation = (Location)itemLocations.iterator().next();
                        String next = chain.get((i + 1) % chain.size());
                        String label = "Reference from @" + type.getName() + "/" + item + " to " + type.getName() + "/" + next + " here";
                        itemLocation.setMessage(label);
                        itemLocation.setSecondary(location);
                        location = itemLocation;
                    }
                    if (location == null) {
                        location = Location.Companion.create(context2.getProject().getDir());
                    } else {
                        Location curr = location.getSecondary();
                        while (curr != null) {
                            Location next = curr.getSecondary();
                            if (next == location) {
                                curr.setSecondary(null);
                                break;
                            }
                            curr = next;
                        }
                    }
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "%1$s Resource definition cycle: %2$s";
                    Object[] objectArray = new Object[]{type.getDisplayName(), Joiner.on((String)" => ").join((Iterable)chain)};
                    boolean bl12 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    Context.report$default(context2, CYCLE, location, message2, null, 8, null);
                }
            }
        }
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        ResourceFolderType resourceFolderType = context2.getResourceFolderType();
        if (resourceFolderType == null || resourceFolderType == ResourceFolderType.VALUES) {
            return;
        }
        String value = attribute.getValue();
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() == 0 || !StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@id/", (boolean)false, (int)2, null)) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType);
        String primary = ((ResourceType)types.get(0)).getName();
        if (!StringsKt.regionMatches((String)value, (int)1, (String)primary, (int)0, (int)primary.length(), (boolean)false)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl url = resourceUrl;
        if (!types.contains(url.type)) {
            return;
        }
        if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)attribute.getNamespaceURI())) {
            return;
        }
        String from = Lint.getBaseName(context2.file.getName());
        this.handleReference(context2, attribute, url.type, from, url.name);
    }

    private final void handleReference(XmlContext context2, Node node, ResourceType type, String from, String to) {
        if (Intrinsics.areEqual((Object)from, (Object)to)) {
            if (context2.isEnabled(CYCLE) && context2.getDriver().getPhase() == 1) {
                String string;
                Location location = context2.getLocation(node);
                StringBuilder stringBuilder = new StringBuilder().append(type.getDisplayName()).append(" `").append(to).append("` should not ");
                switch (ResourceCycleDetector$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        string = "include";
                        break;
                    }
                    case 2: {
                        string = "extend";
                        break;
                    }
                    default: {
                        string = "reference";
                    }
                }
                XmlContext.report$default(context2, CYCLE, node, location, stringBuilder.append(string).append(" itself").toString(), null, 16, null);
            }
        } else if (this.mReferences != null) {
            if (this.mLocations != null) {
                this.recordLocation(context2, node, type, from);
            } else {
                this.recordReference(type, from, to);
            }
        }
    }

    private final void findCycles(Context context2, ResourceType type, Multimap<String, String> map) {
        HashSet visiting = Sets.newHashSet();
        HashSet visited = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet seen = Sets.newHashSetWithExpectedSize((int)map.size());
        for (String from : map.keySet()) {
            List<String> chain;
            if (seen.contains(from) || (chain = this.dfs(map, from, visiting, visited)) == null || chain.size() <= 2) continue;
            seen.addAll((Collection)chain);
            CollectionsKt.reverse(chain);
            Map map2 = this.mChains;
            if (map2 == null) {
                ResourceCycleDetector resourceCycleDetector = this;
                boolean bl = false;
                boolean bl2 = false;
                ResourceCycleDetector $this$run = resourceCycleDetector;
                boolean bl3 = false;
                EnumMap newMap2 = Maps.newEnumMap(ResourceType.class);
                $this$run.mChains = newMap2;
                $this$run.mLocations = Maps.newEnumMap(ResourceType.class);
                context2.getDriver().requestRepeat($this$run, Scope.RESOURCE_FILE_SCOPE);
                map2 = newMap2;
            }
            Map chains = map2;
            List<List<String>> list2 = chains.get(type);
            if (list2 == null) {
                chains.put((ResourceType)type, (List<List<String>>)CollectionsKt.mutableListOf((Object[])new List[]{chain}));
                continue;
            }
            list2.add(chain);
        }
    }

    private final void checkCrashItem(XmlContext context2, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int max = text.length();
            for (int k = 0; k < max; ++k) {
                String name;
                String string;
                int n2;
                char c = text.charAt(k);
                if (Character.isWhitespace(c)) {
                    return;
                }
                if (StringsKt.startsWith$default((String)text, (String)"@+id/", (int)k, (boolean)false, (int)4, null)) {
                    String $this$trim$iv = text;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    n2 = "@+id/".length();
                    boolean bl = false;
                    string = $this$trim$iv;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                } else {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                String message2 = "This construct can potentially crash `aapt` during a build. Change `@+id/" + name + "` to `@id/" + name + "` and define " + "the id explicitly using " + "`<item type=\"id\" name=\"" + name + "\"/>` instead.";
                XmlContext.report$default(context2, CRASH, item, context2.getLocation(item), message2, null, 16, null);
            }
        }
    }

    private final List<String> dfs(Multimap<String, String> map, String from, Set<String> visiting, Set<String> visited) {
        visiting.add(from);
        visited.add(from);
        Collection targets = map.get((Object)from);
        if (targets != null && !targets.isEmpty()) {
            for (String target2 : targets) {
                List<Object> chain;
                if (visiting.contains(target2)) {
                    chain = Lists.newArrayList();
                    ((ArrayList)chain).add(target2);
                    ((ArrayList)chain).add(from);
                    return chain;
                }
                if (visited.contains(target2) || (chain = this.dfs(map, target2, visiting, visited)) == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ResourceCycleDetector.class, Scope.RESOURCE_FILE_SCOPE);
        CYCLE = Issue.Companion.create("ResourceCycle", "Cycle in resource definitions", "\n                There should be no cycles in resource definitions as this can lead to \\\n                runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
        CRASH = Issue.Companion.create("AaptCrash", "Potential AAPT crash", "\n                Defining a style which sets `android:id` to a dynamically generated id can \\\n                cause many versions of `aapt`, the resource packaging tool, to crash. \\\n                To work around this, declare the id explicitly with \\\n                `<item type=\"id\" name=\"...\" />` instead.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector$Companion;", "", "()V", "CRASH", "Lcom/android/tools/lint/detector/api/Issue;", "CYCLE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

