/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;

public class ParcelDetector
extends Detector
implements SourceCodeScanner {
    private static final String OLD_PARCELIZE = "kotlinx.android.parcel.Parcelize";
    private static final String NEW_PARCELIZE = "kotlinx.parcelize.Parcelize";
    public static final Issue ISSUE = Issue.create("ParcelCreator", "Missing Parcelable `CREATOR` field", "According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.\"", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ParcelDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true).addMoreInfo("https://developer.android.com/reference/android/os/Parcelable.html");

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.os.Parcelable");
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        PsiModifierList modifierList;
        PsiModifierList modifierList2;
        if (declaration instanceof UAnonymousClass) {
            return;
        }
        if (declaration.isInterface()) {
            return;
        }
        if (declaration.hasModifierProperty("abstract")) {
            return;
        }
        if (context2.getEvaluator().implementsInterface((PsiClass)declaration, "android.text.ParcelableSpan", false)) {
            return;
        }
        boolean isKotlin = Lint.isKotlin((PsiElement)declaration);
        if (isKotlin && (modifierList2 = declaration.getModifierList()) != null && (modifierList2.findAnnotation(OLD_PARCELIZE) != null || modifierList2.findAnnotation(NEW_PARCELIZE) != null)) {
            return;
        }
        PsiField field = declaration.findFieldByName("CREATOR", true);
        if (field == null) {
            Location location = context2.getNameLocation(declaration);
            String message2 = "This class implements `Parcelable` but does not provide a `CREATOR` field";
            context2.report(ISSUE, declaration, location, message2, null);
        } else if (Lint.isKotlin((PsiElement)field) && !ParcelDetector.hasCreatorInnerClass(declaration) && (modifierList = field.getModifierList()) != null && modifierList.findAnnotation("kotlin.jvm.JvmField") == null) {
            Location location = context2.getNameLocation((PsiElement)field);
            LintFix fix = this.fix().name("Add @JvmField", true).replace().text("val").with("@JvmField val").range(context2.getLocation((PsiElement)field)).autoFix().build();
            context2.report(ISSUE, (PsiElement)field, location, "Field should be annotated with `@JvmField`", fix);
        }
    }

    private static boolean hasCreatorInnerClass(UClass declaration) {
        for (UClass inner : declaration.getInnerClasses()) {
            String name = inner.getName();
            if (!"CREATOR".equals(name)) continue;
            return true;
        }
        return false;
    }
}

