/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.OtherFileScanner;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.CharSequences;
import java.util.EnumSet;

public class MergeMarkerDetector
extends Detector
implements OtherFileScanner {
    public static final Issue ISSUE = Issue.create("MergeMarker", "Code contains merge marker", "Many version control systems leave unmerged files with markers such as <<< in the source code. This check looks for these markers, which are sometimes accidentally left in, particularly in resource files where they don't break compilation.", Category.CORRECTNESS, 8, Severity.ERROR, new Implementation(MergeMarkerDetector.class, Scope.OTHER_SCOPE));
    private static final String[] targetFileTypes = new String[]{".gradle", ".kts", ".properties", ".xml"};

    @Override
    public EnumSet<Scope> getApplicableFiles() {
        return Scope.OTHER_SCOPE;
    }

    @Override
    public void run(Context context2) {
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        boolean shouldCheckFile = false;
        String path2 = context2.file.getPath();
        for (String ext : targetFileTypes) {
            if (!path2.endsWith(ext)) continue;
            shouldCheckFile = true;
            break;
        }
        if (!shouldCheckFile) {
            return;
        }
        CharSequence source = context2.getContents();
        if (source == null) {
            return;
        }
        int length = source.length();
        int offset = 0;
        while ((offset = CharSequences.indexOf((CharSequence)source, (char)'\n', (int)offset)) != -1 && offset != length - 1) {
            char peek;
            if ((peek = source.charAt(++offset)) != '<' && peek != '=' && peek != '>' || !CharSequences.startsWith((CharSequence)source, (CharSequence)"<<<<<<< ", (int)offset) && !CharSequences.startsWith((CharSequence)source, (CharSequence)"=======\n", (int)offset) && !CharSequences.startsWith((CharSequence)source, (CharSequence)">>>>>>> ", (int)offset)) continue;
            Location location = Location.create(context2.file, source, offset, offset + 7);
            context2.report(ISSUE, location, "Missing merge marker?");
        }
    }
}

