/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.StringHelper;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiType;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUField;
import org.jetbrains.uast.kotlin.KotlinStringTemplateUPolyadicExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/LintDetectorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "applicableSuperClasses", "", "", "checkKotlin", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "getApplicableMethodNames", "visitClass", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "LintDetectorVisitor", "android.sdktools.lint-checks"})
public final class LintDetectorDetector
extends Detector
implements Detector.UastScanner {
    private static final String CLASS_LINT_CLIENT = "com.android.tools.lint.client.api.LintClient";
    private static final String CLASS_DETECTOR = "com.android.tools.lint.detector.api.Detector";
    private static final String CLASS_ISSUE_REGISTRY = "com.android.tools.lint.client.api.IssueRegistry";
    private static final String CLASS_CONTEXT = "com.android.tools.lint.detector.api.Context";
    private static final String CLASS_ISSUE = "com.android.tools.lint.detector.api.Issue";
    private static final String CLASS_ISSUE_COMPANION = "com.android.tools.lint.detector.api.Issue.Companion";
    private static final String CLASS_TEST_LINT_TASK = "com.android.tools.lint.checks.infrastructure.TestLintTask";
    private static final String CLASS_PSI_METHOD = "com.intellij.psi.PsiMethod";
    private static final String CLASS_PSI_ELEMENT = "com.intellij.psi.PsiElement";
    private static final String CLASS_PSI_VARIABLE = "com.intellij.psi.PsiVariable";
    private static final String CLASS_PSI_TREE_UTIL = "com.intellij.psi.util.PsiTreeUtil";
    private static final String CLASS_PSI_JVM_MEMBER = "com.intellij.psi.PsiJvmMember";
    private static final String CLASS_U_ELEMENT = "org.jetbrains.uast.UElement";
    private static final String DOLLAR_STRING = "${\"$\"}";
    private static final String DOLLAR_CHAR = "${'$'}";
    private static final Regex CAMELCASE_PATTERN;
    private static final Regex CALL_PATTERN;
    private static final Regex XML_PATTERN;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ID;
    @JvmField
    @NotNull
    public static final Issue CHECK_URL;
    @JvmField
    @NotNull
    public static final Issue UNEXPECTED_DOMAIN;
    @JvmField
    @NotNull
    public static final Issue TEXT_FORMAT;
    @JvmField
    @NotNull
    public static final Issue EXISTING_LINT_CONSTANTS;
    @JvmField
    @NotNull
    public static final Issue USE_UAST;
    @JvmField
    @NotNull
    public static final Issue PSI_COMPARE;
    @JvmField
    @NotNull
    public static final Issue USE_KOTLIN;
    @JvmField
    @NotNull
    public static final Issue TRIM_INDENT;
    @JvmField
    @NotNull
    public static final Issue DOLLAR_STRINGS;
    public static final Companion Companion;

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object[])new String[]{CLASS_DETECTOR, CLASS_ISSUE_REGISTRY});
    }

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"lint");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        PsiType psiType = method.getReturnType();
        if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)CLASS_TEST_LINT_TASK) ^ true) {
            return;
        }
        UElement parent = node.getUastParent();
        if (parent instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)parent).getReceiver(), (Object)node)) {
            UExpression selector = ((UQualifiedReferenceExpression)parent).getSelector();
            LintDetectorVisitor visitor2 = new LintDetectorVisitor(context2);
            if (selector instanceof UCallExpression) {
                for (UExpression testFile : ((UCallExpression)selector).getValueArguments()) {
                    if (!(testFile instanceof UCallExpression)) continue;
                    visitor2.checkTestFile((UCallExpression)testFile);
                }
            }
        }
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        this.checkKotlin(context2, declaration);
        declaration.accept((UastVisitor)new LintDetectorVisitor(context2));
    }

    private final void checkKotlin(JavaContext context2, UClass declaration) {
        block5: {
            String yearString;
            int n;
            block7: {
                block6: {
                    String source;
                    int yearIndex;
                    if (Lint.isKotlin(declaration.getSourcePsi()) || (yearIndex = StringsKt.indexOf$default((CharSequence)(source = String.valueOf(context2.getContents())), (String)" 20", (int)0, (boolean)false, (int)6, null)) == -1) break block5;
                    String string = source;
                    int n2 = yearIndex + 1;
                    n = yearIndex + 5;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n2, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    yearString = string3;
                    char c = yearString.charAt(2);
                    n2 = 0;
                    if (!Character.isDigit(c)) break block6;
                    c = yearString.charAt(3);
                    n2 = 0;
                    if (Character.isDigit(c)) break block7;
                }
                return;
            }
            String string = yearString;
            n = 0;
            int year = Integer.parseInt(string);
            if (year < 2020) {
                return;
            }
            context2.report(USE_KOTLIN, declaration, context2.getNameLocation(declaration), "New lint checks should be implemented in Kotlin to take advantage of a lot of Kotlin-specific mechanisms in the Lint API");
        }
    }

    static {
        Companion = new Companion(null);
        CAMELCASE_PATTERN = new Regex("[a-zA-Z]+[a-z]+[A-Z][a-z]+");
        CALL_PATTERN = new Regex("[a-zA-Z().=]+\\(.*\\)");
        XML_PATTERN = new Regex("<.+>");
        IMPLEMENTATION = new Implementation(LintDetectorDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet<Platform> enumSet = Platform.JDK_SET;
        Boolean bl = null;
        boolean bl2 = false;
        Implementation implementation = IMPLEMENTATION;
        Severity severity = Severity.ERROR;
        int n = 6;
        String string = null;
        Category category = Category.CUSTOM_LINT_CHECKS;
        ID = Issue.Companion.create$default(Issue.Companion, "LintImplIdFormat", "Lint ID Format", "\n                    This check looks at lint issue id registrations and makes sure the id \\\n                    follows the expected conventions: capitalized, camel case, no spaces, \\\n                    and not too long.\n\n                    Note: You shouldn't change id's for lint checks that are already widely \\\n                    used, since the id can already appear in `@SuppressLint` annotations, \\\n                    `tools:ignore=` attributes, lint baselines, Gradle `lintOptions` blocks, \\\n                    `lint.xml` files, and so on. In these cases, just explicitly suppress this \\\n                    warning instead using something like\n\n                    ```kotlin\n                        @JvmField\n                        val ISSUE = Issue.create(\n                            // ID string is too long, but we can't change this now since this\n                            // id is already used in user suppress configurations\n                            //noinspection LintImplIdFormat\n                            id = \"IncompatibleMediaBrowserServiceCompatVersion\",\n                            ...\n                    ```\n                ", implementation, string, category, n, severity, bl2, bl, enumSet, collection, 2832, null);
        collection = null;
        enumSet = Platform.JDK_SET;
        bl = null;
        bl2 = false;
        implementation = IMPLEMENTATION;
        severity = Severity.ERROR;
        n = 6;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        CHECK_URL = Issue.Companion.create$default(Issue.Companion, "LintImplBadUrl", "Bad More Info Link", "\n                   More Info URLs let a link check point to additional resources about \\\n                   the problem and solution it's checking for.\n\n                   This check validates the URLs in various ways, such as making sure that \\\n                   issue tracker links look correct. It may also at some point touch the network \\\n                   to make sure that the URLs are actually still reachable.\n                ", implementation, string, category, n, severity, bl2, bl, enumSet, collection, 2832, null);
        collection = null;
        enumSet = Platform.JDK_SET;
        bl = null;
        Implementation implementation2 = IMPLEMENTATION;
        boolean bl3 = false;
        severity = Severity.ERROR;
        n = 6;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        UNEXPECTED_DOMAIN = Issue.Companion.create$default(Issue.Companion, "LintImplUnexpectedDomain", "Unexpected URL Domain", "\n                    This checks flags URLs to domains that have not been explicitly \\\n                    allowed for use as a documentation source.\n                ", implementation2, string, category, n, severity, bl3, bl, enumSet, collection, 2576, null);
        collection = null;
        enumSet = Platform.JDK_SET;
        bl = null;
        boolean bl4 = false;
        Implementation implementation3 = IMPLEMENTATION;
        severity = Severity.WARNING;
        n = 6;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        TEXT_FORMAT = Issue.Companion.create$default(Issue.Companion, "LintImplTextFormat", "Lint Text Format", "\n                    Lint supports various markdown like formatting directives in all of its \\\n                    strings (issue explanations, reported error messages, etc).\n\n                    This lint check looks for strings that look like they may benefit from \\\n                    additional formatting. For example, if a snippet looks like code it should \\\n                    be surrounded with backticks.\n\n                    Note: Be careful changing **existing** strings; this may stop baseline file \\\n                    matching from working, so consider suppressing existing violations of this \\\n                    check if this is an error many users may be filtering in baselines. (This \\\n                    is only an issue for strings used in `report` calls; for issue registration \\\n                    strings like summaries and explanations there's no risk changing the text \\\n                    contents.)\n                ", implementation3, string, category, n, severity, bl4, bl, enumSet, collection, 2832, null);
        collection = null;
        enumSet = Platform.JDK_SET;
        bl = null;
        bl4 = false;
        implementation3 = IMPLEMENTATION;
        severity = Severity.WARNING;
        n = 6;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        EXISTING_LINT_CONSTANTS = Issue.Companion.create$default(Issue.Companion, "LintImplUseExistingConstants", "Use Existing Lint Constants", "\n                    This check looks for opportunities to reuse predefined lint constants.\n                ", implementation3, string, category, n, severity, bl4, bl, enumSet, collection, 2832, null);
        collection = null;
        enumSet = Platform.JDK_SET;
        bl = null;
        bl4 = false;
        implementation3 = IMPLEMENTATION;
        severity = Severity.ERROR;
        n = 4;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        USE_UAST = Issue.Companion.create$default(Issue.Companion, "LintImplUseUast", "Using Wrong UAST Method", "\n                    UAST is a library that sits on top of PSI, and in many cases PSI is \\\n                    part of the UAST API; for example, UResolvable#resolve returns a \\\n                    PsiElement.\n\n                    Also, for convenience, a UClass is a PsiClass, a UMethod is a PsiMethod, \\\n                    and so on.\n\n                    However, there are some parts of the PSI API that does not work correctly \\\n                    when used in this way. For example, if you call `PsiMethod#getBody` or \\\n                    `PsiVariable#getInitializer`, this will only work in Java, not for \\\n                    Kotlin (or potentially other languages).\n\n                    There are UAST specific methods you need to call instead and lint will \\\n                    flag these.\n                    ", implementation3, string, category, n, severity, bl4, bl, enumSet, collection, 2832, null);
        collection = null;
        boolean bl5 = false;
        bl = null;
        EnumSet<Platform> enumSet2 = Platform.JDK_SET;
        implementation3 = IMPLEMENTATION;
        severity = Severity.ERROR;
        n = 4;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        PSI_COMPARE = Issue.Companion.create$default(Issue.Companion, "LintImplPsiEquals", "Comparing PsiElements with Equals", "\n                    You should never compare two PSI elements for equality with `equals`;\n                    use `isEquivalentTo(PsiElement)` instead.\n                    ", implementation3, string, category, n, severity, bl5, bl, enumSet2, collection, 2576, null);
        collection = null;
        EnumSet<Platform> enumSet3 = Platform.JDK_SET;
        bl = null;
        boolean bl6 = false;
        implementation3 = IMPLEMENTATION;
        severity = Severity.WARNING;
        n = 4;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        USE_KOTLIN = Issue.Companion.create$default(Issue.Companion, "LintImplUseKotlin", "Non-Kotlin Lint Detectors", "\n                    New lint checks should be written in Kotlin; the Lint API is written in \\\n                    Kotlin and uses a number of language features that makes it beneficial \\\n                    to also write the lint checks in Kotlin. Examples include many extension \\\n                    functions (as well as in UAST), default and named parameters (for the \\\n                    Issue registration methods for example where there are methods with 12+ \\\n                    parameters with only a couple of required ones), and so on.\n                    ", implementation3, string, category, n, severity, bl6, bl, enumSet3, collection, 2832, null);
        collection = null;
        enumSet3 = Platform.JDK_SET;
        bl = null;
        bl6 = false;
        implementation3 = IMPLEMENTATION;
        severity = Severity.ERROR;
        n = 4;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        TRIM_INDENT = Issue.Companion.create$default(Issue.Companion, "LintImplTrimIndent", "Calling `.trimIndent` on Lint Strings", "\n                    Lint implicitly calls `.trimIndent()` (lazily, at the last minute) in \\\n                    a number of places:\n                    * Issue explanations\n                    * Error messages\n                    * Lint test file descriptions\n                    * etc\n\n                    That means you don't need to put `.trimIndent()` in your source code \\\n                    to handle this.\n\n                    There are advantages to **not** putting `.trimIndent()` in the code. \\\n                    For test files, if you call for example `kotlin(\"\"\\\"source code\"\\\"\"\\\")` \\\n                    then IntelliJ/Android Studio will syntax highlight the source code as \\\n                    Kotlin. The second you add in a .trimIndent() on the string, the syntax \\\n                    highlighting goes away. For test files you can instead call \".indented()\" \\\n                    on the test file builder to get it to indent the string.\n                    ", implementation3, string, category, n, severity, bl6, bl, enumSet3, collection, 2832, null);
        collection = null;
        enumSet3 = Platform.JDK_SET;
        bl = null;
        bl6 = false;
        implementation3 = IMPLEMENTATION;
        severity = Severity.ERROR;
        n = 4;
        string = null;
        category = Category.CUSTOM_LINT_CHECKS;
        DOLLAR_STRINGS = Issue.Companion.create$default(Issue.Companion, "LintImplDollarEscapes", "Using Dollar Escapes", "\n                    Instead of putting ${\"$\"} in your Kotlin raw string literals \\\n                    you can simply use \uff04. This looks like the dollar sign but is instead \\\n                    the full width dollar sign, U+FF04. And this character does not need \\\n                    to be escaped in Kotlin raw strings, since it does not start a \\\n                    string template.\n\n                    Lint will automatically convert references to \uff04 in unit test files into \\\n                    a real dollar sign, and when pulling results and error messages out of \\\n                    lint, the dollar sign back into the full width dollar sign.\n\n                    That means you can use \uff04 everywhere instead of ${\"$\"}, which makes \\\n                    the test strings more readable -- especially $-heavy code such as \\\n                    references to inner classes.\n                    ", implementation3, string, category, n, severity, bl6, bl, enumSet3, collection, 2832, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0002J.\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0002J(\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0018H\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0007H\u0002J\u000e\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\rJ\u001a\u00101\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\b\b\u0002\u00102\u001a\u00020\u0011H\u0002J\u0018\u00103\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0018\u00105\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0002J\"\u0010<\u001a\u00020:2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00072\b\b\u0002\u00109\u001a\u00020:H\u0002J\u0018\u0010=\u001a\u00020\u00112\u0006\u00109\u001a\u00020:2\u0006\u0010 \u001a\u00020\u0007H\u0002J.\u0010>\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00070CH\u0002J\u0010\u0010D\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010G\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020JH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/android/tools/lint/checks/LintDetectorDetector$LintDetectorVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkedUrls", "", "", "typoLookup", "Lcom/android/tools/lint/checks/TypoLookup;", "checkCall", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "expectedContainer", "message", "requireUastReceiver", "", "checkDollarSubstitutions", "source", "Lorg/jetbrains/uast/UExpression;", "checkEnumSet", "node", "checkEquals", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/intellij/psi/PsiType;", "arg1", "arg2", "checkForCodeFragments", "pattern", "Lkotlin/text/Regex;", "string", "argument", "typeString", "checkGetIssues", "checkId", "idArgument", "id", "checkIssueRegistration", "checkLintString", "checkMoreInfoUrl", "urlArgument", "url", "checkReport", "checkSummary", "title", "checkTestFile", "testFile", "checkTrimIndent", "isUnitTest", "checkTypos", "checkUrl", "checkUrls", "createSurroundFix", "Lcom/android/tools/lint/detector/api/LintFix;", "s", "location", "Lcom/android/tools/lint/detector/api/Location;", "getString", "getStringLocation", "locationContains", "reportTypo", "text", "begin", "", "replacements", "", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "visitCallExpression", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "android.sdktools.lint-checks"})
    public static final class LintDetectorVisitor
    extends AbstractUastVisitor {
        private final TypoLookup typoLookup;
        private final Set<String> checkedUrls;
        private final JavaContext context;

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            String string = node.getMethodName();
            if (string != null) {
                switch (string) {
                    case "getBody": {
                        LintDetectorVisitor.checkCall$default(this, node, LintDetectorDetector.CLASS_PSI_METHOD, "Don't call PsiMethod#getBody(); you must use UAST instead. If you don't have a UMethod call UastFacade.getMethodBody(method)", false, 8, null);
                        break;
                    }
                    case "getParent": {
                        this.checkCall(node, LintDetectorDetector.CLASS_PSI_ELEMENT, "Don't call `PsiElement#getParent()`; you should use UAST instead and call `getUastParent()`", true);
                        break;
                    }
                    case "getContainingClass": {
                        this.checkCall(node, LintDetectorDetector.CLASS_PSI_JVM_MEMBER, "Don't call `PsiMember#getContainingClass()`; you should use UAST instead and call `getContainingUClass()`", true);
                        break;
                    }
                    case "getParentOfType": {
                        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
                        PsiType receiverType = uExpression != null ? uExpression.getExpressionType() : null;
                        JavaEvaluator evaluator = this.context.getEvaluator();
                        PsiClass typeClass = evaluator.getTypeClass(receiverType);
                        if (typeClass == null || !evaluator.inheritsFrom(typeClass, LintDetectorDetector.CLASS_U_ELEMENT, false)) break;
                        LintDetectorVisitor.checkCall$default(this, node, LintDetectorDetector.CLASS_PSI_TREE_UTIL, "Don't call `PsiTreeUtil#getParentOfType()`; you should use UAST instead and call `UElement.parentOfType`", false, 8, null);
                        break;
                    }
                    case "getInitializer": {
                        LintDetectorVisitor.checkCall$default(this, node, LintDetectorDetector.CLASS_PSI_VARIABLE, "Don't call PsiField#getInitializer(); you must use UAST instead. If you don't have a UField call UastFacade.getInitializerBody(field)", false, 8, null);
                        break;
                    }
                    case "equals": {
                        this.checkEquals((UElement)node, node.getReceiverType(), (UElement)node.getReceiver(), (UElement)CollectionsKt.firstOrNull((List)node.getValueArguments()));
                        break;
                    }
                    case "create": {
                        this.checkIssueRegistration(node);
                        break;
                    }
                    case "addMoreInfo": {
                        if (node.getValueArgumentCount() != 1) break;
                        UExpression argument = (UExpression)node.getValueArguments().get(0);
                        String string2 = this.getString(argument);
                        CharSequence charSequence = string2;
                        boolean bl = false;
                        if (!(charSequence.length() > 0)) break;
                        this.checkMoreInfoUrl(argument, string2);
                        break;
                    }
                    case "report": {
                        this.checkReport(node);
                        break;
                    }
                    case "of": {
                        this.checkEnumSet(node);
                        break;
                    }
                }
            }
            return super.visitCallExpression(node);
        }

        public final void checkTestFile(@NotNull UCallExpression testFile) {
            String name = testFile.getMethodName();
            if (Intrinsics.areEqual((Object)name, (Object)"java") || Intrinsics.areEqual((Object)name, (Object)"kotlin") || Intrinsics.areEqual((Object)name, (Object)"kt") || Intrinsics.areEqual((Object)name, (Object)"kts") || Intrinsics.areEqual((Object)name, (Object)"manifest") || Intrinsics.areEqual((Object)name, (Object)"gradle")) {
                List args = testFile.getValueArguments();
                UExpression source = args.size() > 1 ? (UExpression)args.get(1) : (UExpression)args.get(0);
                String string = this.getString(source);
                this.checkTrimIndent(source, true);
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null) && Lint.isKotlin(testFile.getSourcePsi())) {
                    this.checkDollarSubstitutions(source);
                }
            }
        }

        private final void checkDollarSubstitutions(UExpression source) {
            block0: {
                PsiElement psiElement = source.getSourcePsi();
                if (psiElement == null) break block0;
                psiElement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, source){
                    final /* synthetic */ LintDetectorVisitor this$0;
                    final /* synthetic */ UExpression $source;

                    public void visitElement(@NotNull PsiElement element) {
                        String text = element.getText();
                        boolean string = true;
                        int index = StringsKt.indexOf$default((CharSequence)text, (String)"${\"$\"}", (int)0, (boolean)false, (int)6, null);
                        if (index == -1) {
                            string = false;
                            index = StringsKt.indexOf$default((CharSequence)text, (String)"${'$'}", (int)0, (boolean)false, (int)6, null);
                        }
                        if (index != -1) {
                            LintFix fix = LintFix.create().replace().text(string ? "${\"$\"}" : "${'$'}").with("\uff04").build();
                            Location location = LintDetectorVisitor.access$getContext$p(this.this$0).getRangeLocation(element, index, 6);
                            LintDetectorVisitor.access$getContext$p(this.this$0).report(LintDetectorDetector.DOLLAR_STRINGS, (UElement)this.$source, location, "In unit tests, use the fullwidth dollar sign, `\uff04`, instead of `$`, to avoid having to use cumbersome escapes. Lint will treat a `\uff04` as a `$`.", fix);
                            return;
                        }
                        super.visitElement(element);
                    }
                    {
                        this.this$0 = this$0;
                        this.$source = $captured_local_variable$1;
                    }
                });
            }
        }

        private final void checkEnumSet(UCallExpression node) {
            UExpression receiver = node.getReceiver();
            if (receiver instanceof USimpleNameReferenceExpression && Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)receiver).getIdentifier(), (Object)"EnumSet")) {
                EnumSet<Scope> scopes = EnumSet.noneOf(Scope.class);
                for (UExpression argument : node.getValueArguments()) {
                    String name;
                    PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)argument));
                    if (!(psiElement instanceof PsiField)) {
                        psiElement = null;
                    }
                    PsiField psiField = (PsiField)psiElement;
                    String string = name = psiField != null ? psiField.getName() : null;
                    if (name == null) {
                        String string2;
                        if (argument instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)argument).getSelector() instanceof USimpleNameReferenceExpression) {
                            UExpression uExpression = ((UQualifiedReferenceExpression)argument).getSelector();
                            if (uExpression == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.USimpleNameReferenceExpression");
                            }
                            string2 = ((USimpleNameReferenceExpression)uExpression).getIdentifier();
                        } else if (argument instanceof USimpleNameReferenceExpression) {
                            string2 = ((USimpleNameReferenceExpression)argument).getIdentifier();
                        } else {
                            return;
                        }
                        name = string2;
                    }
                    try {
                        Scope scope = Scope.valueOf(name);
                        scopes.add(scope);
                    }
                    catch (Throwable e) {
                        return;
                    }
                }
                if (!scopes.isEmpty()) {
                    for (Field field : Scope.class.getDeclaredFields()) {
                        if ((field.getModifiers() & 8) == 0 || field.isEnumConstant()) continue;
                        field.setAccessible(true);
                        Object constant = field.get(0);
                        if (!Intrinsics.areEqual(scopes, (Object)constant)) continue;
                        LintFix.ReplaceStringBuilder replaceStringBuilder = LintFix.create().name("Replace with Scope." + field.getName()).replace();
                        Object object = node.getSourcePsi();
                        if (object == null || (object = object.getText()) == null) {
                            object = node.asSourceString();
                        }
                        LintFix fix = replaceStringBuilder.text((String)object).with("com.android.tools.lint.detector.api.Scope." + field.getName()).shortenNames().autoFix().build();
                        this.context.report(EXISTING_LINT_CONSTANTS, (UElement)node, this.context.getLocation((UElement)node), "Use `Scope." + field.getName() + "` instead", fix);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkReport(UCallExpression call) {
            PsiMethod psiMethod = call.resolve();
            if (psiMethod == null) {
                return;
            }
            PsiMethod create = psiMethod;
            JavaEvaluator evaluator = this.context.getEvaluator();
            if (!evaluator.isMemberInSubClassOf((PsiMember)create, LintDetectorDetector.CLASS_CONTEXT, false) && !evaluator.isMemberInSubClassOf((PsiMember)create, LintDetectorDetector.CLASS_LINT_CLIENT, false)) {
                return;
            }
            List arguments = call.getValueArguments();
            int n = 2;
            int n2 = arguments.size();
            while (n < n2) {
                PsiType type;
                void index;
                UExpression argument = (UExpression)arguments.get((int)index);
                if (argument.getExpressionType() == null) {
                } else if (Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)"java.lang.String")) {
                    String string = this.getString(argument);
                    this.checkLintString(argument, string);
                    if (StringsKt.endsWith$default((String)string, (String)".", (boolean)false, (int)2, null) && StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)(string.length() - 2), (boolean)false, (int)4, null) == -1 && !StringsKt.endsWith$default((String)string, (String)" etc.", (boolean)false, (int)2, null)) {
                        Location fallback = this.context.getLocation((UElement)argument);
                        Location location = this.getStringLocation(argument, string, fallback);
                        boolean canFix = location != fallback || this.locationContains(location, string);
                        LintFix fix = canFix ? LintFix.create().name("Remove period").replace().text(".").with("").autoFix().build() : null;
                        this.context.report(TEXT_FORMAT, (UElement)argument, location, "Single sentence error messages should not end with a period", fix);
                    }
                }
                ++index;
            }
        }

        private final boolean locationContains(Location location, String string) {
            Position position = location.getStart();
            int start = position != null ? position.getOffset() : -1;
            Position position2 = location.getEnd();
            int end = position2 != null ? position2.getOffset() : -1;
            CharSequence charSequence = this.context.getContents();
            int i = charSequence != null ? StringsKt.indexOf$default((CharSequence)charSequence, (String)string, (int)start, (boolean)false, (int)4, null) : -1;
            return i < end && i != -1;
        }

        public boolean visitField(@NotNull UField node) {
            UExpression initializer;
            if (Intrinsics.areEqual((Object)node.getName(), (Object)"issues") && (initializer = node.getUastInitializer()) != null) {
                this.checkGetIssues((UElement)initializer);
            }
            return super.visitField(node);
        }

        public boolean visitMethod(@NotNull UMethod node) {
            if (Intrinsics.areEqual((Object)node.getName(), (Object)"getIssues")) {
                this.checkGetIssues((UElement)node);
            }
            return super.visitMethod(node);
        }

        private final void checkGetIssues(UElement node) {
            node.accept((UastVisitor)new AbstractUastVisitor(this){
                final /* synthetic */ LintDetectorVisitor this$0;

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    block6: {
                        UMethod create;
                        PsiElement resolved;
                        block7: {
                            UField uField;
                            UField issue;
                            block8: {
                                boolean bl;
                                block5: {
                                    JavaEvaluator evaluator = LintDetectorVisitor.access$getContext$p(this.this$0).getEvaluator();
                                    PsiClass type = LintDetectorVisitor.access$getContext$p(this.this$0).getEvaluator().getTypeClass(node.getExpressionType());
                                    if (type == null || !JavaEvaluator.inheritsFrom$default(evaluator, type, "com.android.tools.lint.detector.api.Issue", false, 4, null)) break block6;
                                    resolved = node.resolve();
                                    if (!(resolved instanceof PsiField)) break block7;
                                    PsiElement $this$toUElementOfType$iv = resolved;
                                    boolean $i$f$toUElementOfType = false;
                                    issue = (UField)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UField.class);
                                    if (issue instanceof JavaUField && JavaEvaluator.inheritsFrom$default(evaluator, (PsiClass)UastUtils.getContainingUClass((UElement)((UElement)issue)), "com.android.tools.lint.detector.api.Detector", false, 4, null)) break block6;
                                    Object object = issue;
                                    if (object == null || (object = object.getUAnnotations()) == null) break block8;
                                    Iterable $this$any$iv = (Iterable)object;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            UAnnotation it = (UAnnotation)element$iv;
                                            boolean bl2 = false;
                                            if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"kotlin.jvm.JvmField")) continue;
                                            bl = true;
                                            break block5;
                                        }
                                        bl = false;
                                    }
                                }
                                if (bl) break block6;
                            }
                            if ((uField = issue) != null && (uField = uField.getUastInitializer()) != null) {
                                uField.accept((UastVisitor)this.this$0);
                            }
                            break block6;
                        }
                        if (!(resolved instanceof PsiMethod)) break block6;
                        PsiElement $this$toUElementOfType$iv = resolved;
                        boolean $i$f$toUElementOfType = false;
                        UMethod uMethod = create = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                        if (uMethod != null) {
                            uMethod.accept((UastVisitor)this.this$0);
                        }
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
                {
                    this.this$0 = this$0;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void checkIssueRegistration(UCallExpression call) {
            block10: {
                PsiMethod psiMethod = call.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod create = psiMethod;
                JavaEvaluator evaluator = this.context.getEvaluator();
                if (!evaluator.isMemberInClass((PsiMember)create, LintDetectorDetector.CLASS_ISSUE_COMPANION) && !evaluator.isMemberInClass((PsiMember)create, LintDetectorDetector.CLASS_ISSUE)) {
                    return;
                }
                JvmParameter[] parameters = create.getParameters();
                Map<UExpression, PsiParameter> mapping = evaluator.computeArgumentMapping(call, create);
                boolean bl = false;
                Map map = new LinkedHashMap();
                boolean bl2 = false;
                boolean bl3 = false;
                Map it = map;
                boolean bl4 = false;
                Map<UExpression, PsiParameter> $this$forEach$iv = mapping;
                boolean $i$f$forEach = false;
                Map<UExpression, PsiParameter> map2 = $this$forEach$iv;
                boolean bl5 = false;
                Object object = map2.entrySet().iterator();
                while (object.hasNext()) {
                    void argument;
                    Map.Entry<UExpression, PsiParameter> element$iv;
                    Map.Entry<UExpression, PsiParameter> $dstr$argument$parameter = element$iv = object.next();
                    boolean bl6 = false;
                    Map.Entry<UExpression, PsiParameter> entry = $dstr$argument$parameter;
                    boolean bl7 = false;
                    UExpression uExpression = entry.getKey();
                    entry = $dstr$argument$parameter;
                    bl7 = false;
                    PsiParameter parameter = entry.getValue();
                    it.put(parameter, argument);
                }
                Map reversed = MapsKt.toMap((Map)map);
                JvmParameter idParameter = parameters[0];
                JvmParameter summaryParameter = parameters[1];
                JvmParameter explanationParameter = parameters[2];
                Map map3 = reversed;
                boolean bl8 = false;
                UExpression uExpression = (UExpression)map3.get(idParameter);
                if (uExpression != null) {
                    map3 = uExpression;
                    bl8 = false;
                    boolean bl9 = false;
                    Map it2 = map3;
                    boolean bl10 = false;
                    String string = this.getString((UExpression)it2);
                    this.checkId((UExpression)it2, string);
                }
                map3 = reversed;
                bl8 = false;
                UExpression uExpression2 = (UExpression)map3.get(summaryParameter);
                if (uExpression2 != null) {
                    map3 = uExpression2;
                    bl8 = false;
                    boolean bl11 = false;
                    Map it3 = map3;
                    boolean bl12 = false;
                    String string = this.getString((UExpression)it3);
                    object = string;
                    boolean bl13 = false;
                    if (object.length() > 0) {
                        this.checkSummary((UExpression)it3, string);
                    }
                }
                map3 = reversed;
                bl8 = false;
                UExpression uExpression3 = (UExpression)map3.get(explanationParameter);
                if (uExpression3 != null) {
                    map3 = uExpression3;
                    bl8 = false;
                    boolean bl14 = false;
                    Map it4 = map3;
                    boolean bl15 = false;
                    String string = this.getString((UExpression)it4);
                    object = string;
                    boolean bl16 = false;
                    if (object.length() > 0) {
                        this.checkLintString((UExpression)it4, string);
                        LintDetectorVisitor.checkTrimIndent$default(this, (UExpression)it4, false, 2, null);
                    }
                }
                if (parameters.length != 12) break block10;
                map3 = reversed;
                JvmParameter jvmParameter = parameters[4];
                boolean bl17 = false;
                UExpression uExpression4 = (UExpression)map3.get(jvmParameter);
                if (uExpression4 != null) {
                    map3 = uExpression4;
                    boolean bl18 = false;
                    bl17 = false;
                    Map it5 = map3;
                    boolean bl19 = false;
                    String string = this.getString((UExpression)it5);
                    object = string;
                    boolean bl20 = false;
                    if (object.length() > 0) {
                        this.checkMoreInfoUrl((UExpression)it5, string);
                    }
                }
            }
        }

        private final void checkSummary(UExpression argument, String title) {
            if (title.length() > 60) {
                JavaContext.report$default(this.context, TEXT_FORMAT, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, title, null, 4, null), "The issue summary should be shorter; typically just a 3-6 words; it's used as a topic header in HTML reports and in the IDE inspections window", null, 16, null);
            } else {
                char c = title.charAt(0);
                boolean bl = false;
                if (Character.isLowerCase(c)) {
                    JavaContext.report$default(this.context, TEXT_FORMAT, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, title, null, 4, null), "The issue summary should be capitalized", null, 16, null);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void checkId(UExpression idArgument, String id) {
            String leaf;
            block13: {
                block12: {
                    boolean bl;
                    block11: {
                        String string;
                        boolean bl2;
                        CharSequence charSequence;
                        if (Intrinsics.areEqual((Object)id, (Object)"IncompatibleMediaBrowserServiceCompatVersion")) return;
                        if (Intrinsics.areEqual((Object)id, (Object)"PrivateMemberAccessBetweenOuterAndInnerClass")) return;
                        if (Intrinsics.areEqual((Object)id, (Object)"PermissionImpliesUnsupportedChromeOsHardware")) {
                            return;
                        }
                        int leafIndex = StringsKt.lastIndexOf$default((CharSequence)id, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
                        if (leafIndex > 0 && leafIndex < id.length() - 1) {
                            charSequence = id;
                            bl2 = false;
                            CharSequence charSequence2 = charSequence;
                            if (charSequence2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string2 = ((String)charSequence2).substring(leafIndex);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        } else {
                            string = id;
                        }
                        leaf = string;
                        charSequence = leaf;
                        bl2 = false;
                        if (charSequence.length() == 0) {
                            return;
                        }
                        boolean bl3 = false;
                        if (bl3) {
                            return;
                        }
                        char c = leaf.charAt(0);
                        bl2 = false;
                        if (!Character.isUpperCase(c)) break block12;
                        CharSequence $this$none$iv = leaf;
                        boolean $i$f$none = false;
                        CharSequence charSequence3 = $this$none$iv;
                        for (int i = 0; i < charSequence3.length(); ++i) {
                            char element$iv;
                            char it = element$iv = charSequence3.charAt(i);
                            boolean bl4 = false;
                            char c2 = it;
                            boolean bl5 = false;
                            if (!Character.isLowerCase(c2)) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                    if (!bl) break block13;
                }
                JavaContext.report$default(this.context, ID, (UElement)idArgument, this.context.getLocation((UElement)idArgument), "Lint issue IDs should use capitalized camel case, such as `MyIssueId`", null, 16, null);
                return;
            }
            if (StringsKt.contains$default((CharSequence)id, (CharSequence)" ", (boolean)false, (int)2, null)) {
                JavaContext.report$default(this.context, ID, (UElement)idArgument, this.context.getLocation((UElement)idArgument), "Lint issue IDs should not contain spaces, such as `MyIssueId`", null, 16, null);
                return;
            }
            if (leaf.length() < 40) return;
            JavaContext.report$default(this.context, ID, (UElement)idArgument, this.context.getLocation((UElement)idArgument), "Lint issue IDs should be reasonably short (< 40 chars); they're used in suppress annotations etc", null, 16, null);
        }

        private final void checkMoreInfoUrl(UExpression urlArgument, String url) {
            this.checkUrl(url, urlArgument);
        }

        private final void checkUrls(UExpression argument, String string) {
            int index;
            int start = 0;
            while ((index = StringsKt.indexOf$default((CharSequence)string, (String)"http://", (int)start, (boolean)false, (int)4, null)) != -1 || (index = StringsKt.indexOf$default((CharSequence)string, (String)"https://", (int)start, (boolean)false, (int)4, null)) != -1) {
                String url;
                start = index;
                int end = TextFormat.Companion.findUrlEnd(string, start);
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                this.checkUrl(url, argument);
                start = end;
            }
        }

        private final Location getStringLocation(UExpression argument, String string, Location location) {
            Location location2;
            CharSequence contents;
            Position position = location.getStart();
            if (position == null) {
                return location;
            }
            int start = position.getOffset();
            Position position2 = location.getEnd();
            if (position2 == null) {
                return location;
            }
            int end = position2.getOffset();
            CharSequence charSequence = contents = this.context.getContents();
            if (charSequence == null) {
                return location;
            }
            int n = start;
            int n2 = 0;
            int index = StringsKt.indexOf((CharSequence)charSequence, (String)string, (int)n, n2 != 0);
            if (index != -1) {
                boolean bl;
                int alt;
                if (index > end && (alt = StringsKt.lastIndexOf((CharSequence)contents, (String)string, (int)(n2 = start), (boolean)(bl = false))) != -1) {
                    index = alt;
                }
                location2 = argument instanceof KotlinStringTemplateUPolyadicExpression && ((KotlinStringTemplateUPolyadicExpression)argument).getOperands().size() == 1 && location.getSource() == (UExpression)((KotlinStringTemplateUPolyadicExpression)argument).getOperands().get(0) ? this.context.getRangeLocation((UElement)((KotlinStringTemplateUPolyadicExpression)argument).getOperands().get(0), index - start, string.length()) : this.context.getRangeLocation((UElement)argument, index - start, string.length());
            } else {
                location2 = location;
            }
            return location2;
        }

        static /* synthetic */ Location getStringLocation$default(LintDetectorVisitor lintDetectorVisitor, UExpression uExpression, String string, Location location, int n, Object object) {
            if ((n & 4) != 0) {
                location = lintDetectorVisitor.context.getLocation((UElement)uExpression);
            }
            return lintDetectorVisitor.getStringLocation(uExpression, string, location);
        }

        private final void checkUrl(String url, UExpression argument) {
            if (Intrinsics.areEqual((Object)url, (Object)"http://schemas.android.com/apk/res-auto") || Intrinsics.areEqual((Object)url, (Object)"http://schemas.android.com/apk/res/android") || Intrinsics.areEqual((Object)url, (Object)"http://schemas.android.com/tools")) {
                return;
            }
            if (!this.checkedUrls.add(url)) {
                return;
            }
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)"b.android.com", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url, (CharSequence)"code.google.com/p/android/issues/", (boolean)false, (int)2, null)) {
                JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Don't point to old `http://b.android.com` links; should be using `https://issuetracker.google.com` instead", null, 16, null);
            } else if (StringsKt.startsWith$default((String)url, (String)"https://issuetracker.google.com/", (boolean)false, (int)2, null)) {
                int expectedLength;
                int issueLength = url.length() - (StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                if (issueLength < (expectedLength = 9)) {
                    JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Suspicious issue tracker length; expected a " + expectedLength + " digit issue id, but was " + issueLength, null, 16, null);
                }
            } else {
                try {
                    String protocol;
                    String string;
                    URL parsed = new URL(url);
                    String string2 = parsed.getProtocol();
                    if (string2 != null) {
                        String string3 = string2;
                        Locale locale = Locale.US;
                        boolean bl = false;
                        String string4 = string3;
                        boolean bl2 = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.toLowerCase(locale);
                        string = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                    } else {
                        string = protocol = null;
                    }
                    if (Intrinsics.areEqual(protocol, (Object)"mailto")) {
                        return;
                    }
                    if (protocol != null && Intrinsics.areEqual(protocol, (Object)"http") ^ true && Intrinsics.areEqual((Object)protocol, (Object)"https") ^ true) {
                        JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Unexpected protocol `" + protocol + "` in `" + url + '`', null, 16, null);
                    } else {
                        String host = parsed.getHost();
                        if (host != null && (StringsKt.contains$default((CharSequence)host, (CharSequence)"corp.google.com", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)host, (CharSequence)"googleplex.com", (boolean)false, (int)2, null))) {
                            JavaContext.report$default(this.context, UNEXPECTED_DOMAIN, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Don't use internal Google links (`" + url + "`)", null, 16, null);
                        } else if (host != null && !StringsKt.endsWith$default((String)host, (String)".google.com", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)host, (String)".android.com", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)host, (Object)"android.com") ^ true && Intrinsics.areEqual((Object)host, (Object)"android-developers.googleblog.com") ^ true && Intrinsics.areEqual((Object)host, (Object)"android-developers.blogspot.com") ^ true && Intrinsics.areEqual((Object)host, (Object)"g.co") ^ true && Intrinsics.areEqual((Object)host, (Object)"material.io") ^ true && Intrinsics.areEqual((Object)host, (Object)"android.github.io") ^ true && (Intrinsics.areEqual((Object)host, (Object)"medium.com") ^ true || !StringsKt.startsWith$default((String)parsed.getPath(), (String)"/androiddevelopers/", (boolean)false, (int)2, null)) && !StringsKt.endsWith$default((String)host, (String)".wikipedia.org", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)host, (String)".groovy-lang.org", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)host, (String)".sqlite.org", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)host, (Object)"stackoverflow.com") ^ true && Intrinsics.areEqual((Object)host, (Object)"tools.ietf.org") ^ true && Intrinsics.areEqual((Object)host, (Object)"kotlinlang.org") ^ true && Intrinsics.areEqual((Object)host, (Object)"bugs.eclipse.org") ^ true) {
                            JavaContext.report$default(this.context, UNEXPECTED_DOMAIN, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Unexpected URL host `" + host + "`; for the builtin Android Lint checks make sure to use an authoritative link (`" + url + "`)", null, 16, null);
                        } else if (Intrinsics.areEqual((Object)protocol, (Object)"http")) {
                            JavaContext.report$default(this.context, UNEXPECTED_DOMAIN, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Use https, not http, for more info links (`" + url + "`)", null, 16, null);
                        }
                    }
                }
                catch (MalformedURLException e) {
                    JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "The URL `" + url + "` cannot be parsed: " + e, null, 16, null);
                }
            }
        }

        private final void checkTrimIndent(UExpression argument, boolean isUnitTest) {
            String methodName;
            UExpression selector;
            if (argument instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)argument).getSelector()) instanceof UCallExpression && (Intrinsics.areEqual((Object)(methodName = ((UCallExpression)selector).getMethodName()), (Object)"trimIndent") || Intrinsics.areEqual((Object)methodName, (Object)"trimMargin"))) {
                String string;
                Location location = this.context.getCallLocation((UCallExpression)selector, false, true);
                LintFix fix = !isUnitTest ? LintFix.create().replace().all().with("").build() : null;
                UElement uElement = (UElement)selector;
                StringBuilder stringBuilder = new StringBuilder().append("No need to call `.").append(methodName).append("()` in issue registration strings; they ").append("are already trimmed by indent by lint when displaying to users");
                if (isUnitTest) {
                    StringBuilder stringBuilder2 = new StringBuilder().append(". Instead, call `.indented()` on the surrounding `");
                    UElement uElement2 = argument.getUastParent();
                    if (!(uElement2 instanceof UCallExpression)) {
                        uElement2 = null;
                    }
                    UCallExpression uCallExpression = (UCallExpression)uElement2;
                    string = stringBuilder2.append(uCallExpression != null ? uCallExpression.getMethodName() : null).append("()` test file construction").toString();
                } else {
                    string = "";
                }
                this.context.report(TRIM_INDENT, uElement, location, stringBuilder.append(string).toString(), fix);
            }
        }

        static /* synthetic */ void checkTrimIndent$default(LintDetectorVisitor lintDetectorVisitor, UExpression uExpression, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            lintDetectorVisitor.checkTrimIndent(uExpression, bl);
        }

        private final String getString(UExpression argument) {
            String constant;
            if (argument instanceof UPolyadicExpression) {
                StringBuilder sb = new StringBuilder();
                for (UExpression part : ((UPolyadicExpression)argument).getOperands()) {
                    sb.append(this.getString(part));
                }
                return sb.toString();
            }
            if (argument instanceof ULiteralExpression) {
                Object object = ((ULiteralExpression)argument).getValue();
                if (object == null || (object = object.toString()) == null) {
                    object = "";
                }
                return object;
            }
            if (argument instanceof UCallExpression) {
                UExpression receiver = ((UCallExpression)argument).getReceiver();
                if (receiver != null) {
                    String string = ((UCallExpression)argument).getMethodName();
                    if (string != null) {
                        if (StringsKt.startsWith$default((String)string, (String)"trim", (boolean)false, (int)2, null)) {
                            return this.getString(receiver);
                        }
                    }
                }
            } else if (argument instanceof UQualifiedReferenceExpression) {
                UExpression selector = ((UQualifiedReferenceExpression)argument).getSelector();
                if (selector instanceof UCallExpression) {
                    String methodName;
                    String string = methodName = ((UCallExpression)selector).getMethodName();
                    if (string != null) {
                        if (StringsKt.startsWith$default((String)string, (String)"trim", (boolean)false, (int)2, null)) {
                            return this.getString(((UQualifiedReferenceExpression)argument).getReceiver());
                        }
                    }
                    if (Intrinsics.areEqual((Object)methodName, (Object)"format")) {
                        List args = ((UCallExpression)selector).getValueArguments();
                        for (UExpression arg : args) {
                            PsiType psiType = arg.getExpressionType();
                            if (!Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)"java.lang.String")) continue;
                            return this.getString(arg);
                        }
                    }
                }
            } else if (!(argument.getUastParent() instanceof KotlinStringTemplateUPolyadicExpression) && (constant = ConstantEvaluator.evaluateString(null, (UElement)argument, true)) != null) {
                return constant;
            }
            return "";
        }

        private final void checkTypos(UExpression argument, String string) {
            int start = 0;
            int length = string.length();
            int index = start;
            while (true) {
                boolean bl;
                char c;
                if (index < length) {
                    c = string.charAt(index);
                    bl = false;
                    if (!Character.isLetter(c)) {
                        ++index;
                        continue;
                    }
                }
                start = index;
                while (index < length) {
                    c = string.charAt(index);
                    bl = false;
                    if (!Character.isLetter(c)) break;
                    ++index;
                }
                if (index <= start) break;
                TypoLookup typoLookup = this.typoLookup;
                List<String> replacements = typoLookup != null ? typoLookup.getTypos(string, start, index) : null;
                if (replacements == null) continue;
                this.reportTypo(argument, string, start, replacements);
            }
        }

        private final void checkLintString(UExpression argument, String string) {
            this.checkUrls(argument, string);
            this.checkTypos(argument, string);
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"`", (boolean)false, (int)2, null)) {
                return;
            }
            if (this.checkForCodeFragments(XML_PATTERN, string, argument, "an XML reference") || this.checkForCodeFragments(CALL_PATTERN, string, argument, "a call") || this.checkForCodeFragments(CAMELCASE_PATTERN, string, argument, "a code reference")) {
                // empty if block
            }
        }

        private final boolean checkForCodeFragments(Regex pattern, String string, UExpression argument, String typeString) {
            boolean bl;
            MatchResult xml = Regex.find$default((Regex)pattern, (CharSequence)string, (int)0, (int)2, null);
            if (xml != null) {
                Location fallback;
                String s = (String)xml.getGroupValues().get(0);
                Location location = this.getStringLocation(argument, s, fallback = this.context.getLocation((UElement)argument));
                boolean canFix = location != fallback || this.locationContains(location, string);
                LintFix fix = canFix ? this.createSurroundFix(s, location) : null;
                this.context.report(TEXT_FORMAT, (UElement)argument, location, '\"' + s + "\" looks like " + typeString + "; surround with backtics in string to display as symbol, e.g. \\`" + s + "\\`", fix);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private final LintFix createSurroundFix(String s, Location location) {
            return LintFix.create().name("Surround with backtics").replace().text(s).with('`' + s + '`').range(location).autoFix().build();
        }

        private final void reportTypo(UExpression argument, String text, int begin, List<String> replacements) {
            String string;
            boolean canFix;
            if (replacements.size() < 2) {
                return;
            }
            String typo = replacements.get(0);
            String string2 = text;
            int n = begin + typo.length();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(begin, n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String word = string4;
            String first = null;
            String message2 = null;
            LintFix.GroupBuilder fixBuilder = LintFix.create().alternatives();
            boolean isCapitalized = Character.isUpperCase(word.charAt(0));
            StringBuilder sb = new StringBuilder(40);
            int n2 = replacements.size();
            for (int i = 1; i < n2; ++i) {
                String replacement = replacements.get(i);
                if (first == null) {
                    first = replacement;
                }
                CharSequence charSequence = sb;
                boolean bl2 = false;
                if (charSequence.length() > 0) {
                    sb.append(" or ");
                }
                sb.append('\"');
                if (isCapitalized) {
                    replacement = StringHelper.usLocaleCapitalize((String)replacement);
                }
                sb.append(replacement);
                fixBuilder.add(LintFix.create().name("Replace with \"" + replacement + '\"').replace().text(word).with(replacement).build());
                sb.append('\"');
            }
            LintFix fix = fixBuilder.build();
            Location fallback = this.context.getLocation((UElement)argument);
            Location location = this.getStringLocation(argument, word, fallback);
            boolean bl3 = canFix = location != fallback || this.locationContains(location, word);
            if (first != null && StringsKt.equals((String)first, (String)word, (boolean)true)) {
                if (Intrinsics.areEqual((Object)first, (Object)word)) {
                    return;
                }
                string = '\"' + word + "\" is usually capitalized as \"" + first + '\"';
            } else {
                string = '\"' + word + "\" is a common misspelling; did you mean " + sb + " ?";
            }
            message2 = string;
            this.context.report(TEXT_FORMAT, (UElement)argument, location, message2, canFix ? fix : null);
        }

        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            UastBinaryOperator operator = node.getOperator();
            if (Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.EQUALS) || Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.NOT_EQUALS)) {
                this.checkEquals((UElement)node, node.getLeftOperand().getExpressionType(), (UElement)node.getLeftOperand(), (UElement)node.getRightOperand());
            }
            return super.visitBinaryExpression(node);
        }

        private final void checkCall(UCallExpression call, String expectedContainer, String message2, boolean requireUastReceiver) {
            if (requireUastReceiver) {
                PsiType receiverType;
                UExpression uExpression = call.getReceiver();
                PsiType psiType = receiverType = uExpression != null ? uExpression.getExpressionType() : null;
                if (psiType != null) {
                    PsiType psiType2 = psiType;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiType it = psiType2;
                    boolean bl3 = false;
                    JavaEvaluator evaluator = this.context.getEvaluator();
                    PsiClass typeClass = evaluator.getTypeClass(it);
                    if (typeClass != null && !evaluator.inheritsFrom(typeClass, LintDetectorDetector.CLASS_U_ELEMENT, false)) {
                        return;
                    }
                }
            }
            PsiMethod psiMethod = call.resolve();
            if (psiMethod == null) {
                return;
            }
            PsiMethod method = psiMethod;
            if (this.context.getEvaluator().isMemberInClass((PsiMember)method, expectedContainer)) {
                JavaContext.report$default(this.context, USE_UAST, (UElement)call, this.context.getLocation((UElement)call), message2, null, 16, null);
            }
        }

        static /* synthetic */ void checkCall$default(LintDetectorVisitor lintDetectorVisitor, UCallExpression uCallExpression, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            lintDetectorVisitor.checkCall(uCallExpression, string, string2, bl);
        }

        private final void checkEquals(UElement node, PsiType type, UElement arg1, UElement arg2) {
            PsiClass psiClass;
            if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && this.context.getEvaluator().inheritsFrom(psiClass, LintDetectorDetector.CLASS_PSI_ELEMENT, false)) {
                UElement uElement = arg1;
                if (uElement != null) {
                    if (UastLiteralUtils.isNullLiteral((UElement)uElement)) {
                        return;
                    }
                }
                UElement uElement2 = arg2;
                if (uElement2 != null) {
                    if (UastLiteralUtils.isNullLiteral((UElement)uElement2)) {
                        return;
                    }
                }
                String message2 = "Don't compare PsiElements with `equals`, use `isEquivalentTo(PsiElement)` instead";
                JavaContext.report$default(this.context, PSI_COMPARE, node, this.context.getLocation(node), message2, null, 16, null);
            }
        }

        public LintDetectorVisitor(@NotNull JavaContext context2) {
            this.context = context2;
            this.typoLookup = TypoLookup.Companion.get(this.context.getClient(), "en", null);
            boolean bl = false;
            this.checkedUrls = new LinkedHashSet();
        }

        public static final /* synthetic */ JavaContext access$getContext$p(LintDetectorVisitor $this) {
            return $this.context;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/LintDetectorDetector$Companion;", "", "()V", "CALL_PATTERN", "Lkotlin/text/Regex;", "CAMELCASE_PATTERN", "CHECK_URL", "Lcom/android/tools/lint/detector/api/Issue;", "CLASS_CONTEXT", "", "CLASS_DETECTOR", "CLASS_ISSUE", "CLASS_ISSUE_COMPANION", "CLASS_ISSUE_REGISTRY", "CLASS_LINT_CLIENT", "CLASS_PSI_ELEMENT", "CLASS_PSI_JVM_MEMBER", "CLASS_PSI_METHOD", "CLASS_PSI_TREE_UTIL", "CLASS_PSI_VARIABLE", "CLASS_TEST_LINT_TASK", "CLASS_U_ELEMENT", "DOLLAR_CHAR", "DOLLAR_STRING", "DOLLAR_STRINGS", "EXISTING_LINT_CONSTANTS", "ID", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "PSI_COMPARE", "TEXT_FORMAT", "TRIM_INDENT", "UNEXPECTED_DOMAIN", "USE_KOTLIN", "USE_UAST", "XML_PATTERN", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

