/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ButtonDetector
extends ResourceXmlDetector {
    private static final String CANCEL_LABEL = "Cancel";
    private static final String OK_LABEL = "OK";
    private static final String BACK_LABEL = "Back";
    private static final String YES_LABEL = "Yes";
    private static final String NO_LABEL = "No";
    private static final String ANDROID_OK_RESOURCE = "@android:string/ok";
    private static final String ANDROID_CANCEL_RESOURCE = "@android:string/cancel";
    private static final String ANDROID_YES_RESOURCE = "@android:string/yes";
    private static final String ANDROID_NO_RESOURCE = "@android:string/no";
    private static final Implementation IMPLEMENTATION = new Implementation(ButtonDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ORDER = Issue.create("ButtonOrder", "Button order", "According to the Android Design Guide,\n\n\"Action buttons are typically Cancel and/or OK, with OK indicating the preferred or most likely action. However, if the options consist of specific actions such as Close or Wait rather than a confirmation or cancellation of the action described in the content, then all the buttons should be active verbs. As a rule, the dismissive action of a dialog is always on the left whereas the affirmative actions are on the right.\"\n\nThis check looks for button bars and buttons which look like cancel buttons, and makes sure that these are on the left.", Category.USABILITY, 8, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://material.io/components/dialogs/");
    public static final Issue STYLE = Issue.create("ButtonStyle", "Button should be borderless", "Button bars typically use a borderless style for the buttons. Set the `style=\"?android:attr/buttonBarButtonStyle\"` attribute on each of the buttons, and set `style=\"?android:attr/buttonBarStyle\"` on the parent layout", Category.USABILITY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://material.io/components/dialogs/");
    public static final Issue BACK_BUTTON = Issue.create("BackButton", "Back button", "According to the Android Design Guide,\n\n\"Other platforms use an explicit back button with label to allow the user to navigate up the application's hierarchy. Instead, Android uses the main action bar's app icon for hierarchical navigation and the navigation bar's back button for temporal navigation.\"\nThis check is not very sophisticated (it just looks for buttons with the label \"Back\"), so it is disabled by default to not trigger on common scenarios like pairs of Back/Next buttons to paginate through screens.", Category.USABILITY, 6, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false).addMoreInfo("https://material.io/design/");
    public static final Issue CASE = Issue.create("ButtonCase", "Cancel/OK dialog button capitalization", "The standard capitalization for OK/Cancel dialogs is \"OK\" and \"Cancel\". To ensure that your dialogs use the standard strings, you can use the resource strings @android:string/ok and @android:string/cancel.", Category.USABILITY, 2, Severity.WARNING, IMPLEMENTATION);
    private Set<String> mApplicableResources;
    private Map<String, String> mKeyToLabel;
    private Set<Element> mIgnore;

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("Button", "string");
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        int phase = context2.getPhase();
        if (phase == 1 && this.mApplicableResources != null) {
            context2.getDriver().requestRepeat(this, Scope.RESOURCE_FILE_SCOPE);
        }
    }

    private static String stripLabel(String text) {
        if ((text = text.trim()).length() > 2 && (text.charAt(0) == '\"' || text.charAt(0) == '\'') && text.charAt(0) == text.charAt(text.length() - 1)) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        int phase = context2.getPhase();
        String tagName = element.getTagName();
        if (phase == 1 && tagName.equals("string")) {
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            block0: for (int i = 0; i < n; ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 3) continue;
                String text = child.getNodeValue();
                int len = text.length();
                for (int j = 0; j < len; ++j) {
                    String name;
                    String label;
                    char c = text.charAt(j);
                    if (Character.isWhitespace(c) || c == '\"' || c == '\'') continue;
                    if (Lint.startsWith(text, CANCEL_LABEL, j)) {
                        label = ButtonDetector.stripLabel(text);
                        if (!label.equalsIgnoreCase(CANCEL_LABEL)) continue block0;
                        name = element.getAttribute("name");
                        this.foundResource(context2, name, element);
                        if (label.equals(CANCEL_LABEL) || !Lint.isEnglishResource(context2, true) || !context2.isEnabled(CASE)) continue block0;
                        assert (label.trim().equalsIgnoreCase(CANCEL_LABEL)) : label;
                        context2.report(CASE, child, context2.getLocation(child), String.format("The standard Android way to capitalize %1$s is \"Cancel\" (tip: use `@android:string/cancel` instead)", label));
                        continue block0;
                    }
                    if (Lint.startsWith(text, OK_LABEL, j)) {
                        label = ButtonDetector.stripLabel(text);
                        if (!label.equalsIgnoreCase(OK_LABEL)) continue block0;
                        name = element.getAttribute("name");
                        this.foundResource(context2, name, element);
                        if (label.equals(OK_LABEL) || !Lint.isEnglishResource(context2, true) || !context2.isEnabled(CASE)) continue block0;
                        assert (label.trim().equalsIgnoreCase(OK_LABEL)) : label;
                        context2.report(CASE, child, context2.getLocation(child), String.format("The standard Android way to capitalize %1$s is \"OK\" (tip: use `@android:string/ok` instead)", label));
                        continue block0;
                    }
                    if (!Lint.startsWith(text, BACK_LABEL, j) || !ButtonDetector.stripLabel(text).equalsIgnoreCase(BACK_LABEL)) continue block0;
                    String name2 = element.getAttribute("name");
                    this.foundResource(context2, name2, element);
                    continue block0;
                }
            }
        } else if (tagName.equals("Button")) {
            if (!(phase != 1 || !ButtonDetector.isInButtonBar(element) || element.hasAttribute("style") || "?android:attr/selectableItemBackground".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "background")) || context2.getProject().getMinSdk() < 11 && context2.getFolderVersion() < 11 || !context2.isEnabled(STYLE) || ButtonDetector.parentDefinesSelectableItem(element))) {
                context2.report(STYLE, (Node)element, context2.getElementLocation(element), "Buttons in button bars should be borderless; use `style=\"?android:attr/buttonBarButtonStyle\"` (and `?android:attr/buttonBarStyle` on the parent)", this.createBorderlessFix(context2, element));
            }
            String text = element.getAttributeNS("http://schemas.android.com/apk/res/android", "text");
            if (phase == 2) {
                if (this.mApplicableResources.contains(text)) {
                    String label;
                    boolean isCancel;
                    String key = text;
                    if (key.startsWith("@string/")) {
                        key = key.substring("@string/".length());
                    }
                    if (isCancel = CANCEL_LABEL.equalsIgnoreCase(label = this.mKeyToLabel.get(key))) {
                        if (ButtonDetector.isWrongCancelPosition(element)) {
                            this.reportCancelPosition(context2, element);
                        }
                    } else if (OK_LABEL.equalsIgnoreCase(label)) {
                        if (ButtonDetector.isWrongOkPosition(element)) {
                            this.reportOkPosition(context2, element);
                        }
                    } else if (BACK_LABEL.equalsIgnoreCase(label) && context2.isEnabled(BACK_BUTTON)) {
                        Location location = context2.getElementLocation(element);
                        context2.report(BACK_BUTTON, element, location, "Back buttons are not standard on Android; see design guide's navigation section");
                    }
                }
            } else if (text.equals(CANCEL_LABEL) || text.equals(ANDROID_CANCEL_RESOURCE)) {
                if (ButtonDetector.isWrongCancelPosition(element)) {
                    this.reportCancelPosition(context2, element);
                }
            } else if (text.equals(OK_LABEL) || text.equals(ANDROID_OK_RESOURCE)) {
                if (ButtonDetector.isWrongOkPosition(element)) {
                    this.reportOkPosition(context2, element);
                }
            } else {
                boolean isYes = text.equals(ANDROID_YES_RESOURCE);
                if (isYes || text.equals(ANDROID_NO_RESOURCE)) {
                    Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "text");
                    Location location = context2.getLocation(attribute);
                    String message2 = String.format("%1$s actually returns \"%2$s\", not \"%3$s\"; use %4$s instead or create a local string resource for %5$s", text, isYes ? OK_LABEL : CANCEL_LABEL, isYes ? YES_LABEL : NO_LABEL, isYes ? ANDROID_OK_RESOURCE : ANDROID_CANCEL_RESOURCE, isYes ? YES_LABEL : NO_LABEL);
                    context2.report(CASE, element, location, message2);
                }
            }
        }
    }

    private static boolean parentDefinesSelectableItem(Element element) {
        String background = element.getAttributeNS("http://schemas.android.com/apk/res/android", "background");
        if ("?android:attr/selectableItemBackground".equals(background)) {
            return true;
        }
        Node parent = element.getParentNode();
        if (parent != null && parent.getNodeType() == 1) {
            return ButtonDetector.parentDefinesSelectableItem((Element)parent);
        }
        return false;
    }

    private void reportOkPosition(XmlContext context2, Element element) {
        this.report(context2, element, false);
    }

    private void reportCancelPosition(XmlContext context2, Element element) {
        this.report(context2, element, true);
    }

    private void foundResource(XmlContext context2, String name, Element element) {
        if (!Lint.isEnglishResource(context2, true)) {
            return;
        }
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        if (this.mApplicableResources == null) {
            this.mApplicableResources = new HashSet<String>();
        }
        this.mApplicableResources.add("@string/" + name);
        Node parentNode = element.getParentNode();
        if (this.mKeyToLabel == null) {
            this.mKeyToLabel = new HashMap<String, String>();
        }
        block0: for (Element item : XmlUtils.getSubTags((Node)parentNode)) {
            String itemName = item.getAttribute("name");
            NodeList childNodes = item.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                String text;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 3 || (text = ButtonDetector.stripLabel(child.getNodeValue())).isEmpty()) continue;
                this.mKeyToLabel.put(itemName, text);
                continue block0;
            }
        }
    }

    private void report(XmlContext context2, Element element, boolean isCancel) {
        String layout;
        if (!context2.isEnabled(ORDER)) {
            return;
        }
        if (this.mIgnore != null && this.mIgnore.contains(element)) {
            return;
        }
        int target2 = context2.getProject().getTargetSdk();
        if (target2 < 14) {
            return;
        }
        boolean mustCreateIcsLayout = false;
        if (context2.getProject().getMinSdk() < 14) {
            boolean isIcsLayout;
            boolean bl = isIcsLayout = context2.getFolderVersion() >= 14;
            if (!isIcsLayout) {
                File res = context2.file.getParentFile().getParentFile();
                File[] resFolders = res.listFiles();
                String fileName = context2.file.getName();
                if (resFolders != null) {
                    for (File folder : resFolders) {
                        File layout2;
                        String folderName = folder.getName();
                        if (!folderName.startsWith("layout") || !folderName.contains("-v14") || !(layout2 = new File(folder, fileName)).exists()) continue;
                        return;
                    }
                }
                mustCreateIcsLayout = true;
            }
        }
        List<Element> buttons = Lint.getChildren(element.getParentNode());
        if (this.mIgnore == null) {
            this.mIgnore = new HashSet<Element>();
        }
        this.mIgnore.addAll(buttons);
        String message2 = isCancel ? "Cancel button should be on the left" : "OK button should be on the right";
        if (mustCreateIcsLayout) {
            message2 = String.format("Layout uses the wrong button order for API >= 14: Create a `layout-v14/%1$s` file with opposite order: %2$s", context2.file.getName(), message2);
        }
        if ((layout = element.getParentNode().getNodeName()).equals("LinearLayout") || layout.equals("TableRow")) {
            List<String> labelList = this.getLabelList(buttons);
            String wrong = ButtonDetector.describeButtons(labelList);
            ButtonDetector.sortButtons(labelList);
            String right = ButtonDetector.describeButtons(labelList);
            message2 = message2 + String.format(" (was \"%1$s\", should be \"%2$s\")", wrong, right);
        }
        Location location = context2.getElementLocation(element);
        context2.report(ORDER, element, location, message2);
    }

    private static void sortButtons(List<String> labelList) {
        int n = labelList.size();
        for (int i = 0; i < n; ++i) {
            String label = labelList.get(i);
            if (label.equalsIgnoreCase(CANCEL_LABEL) && i > 0) {
                ButtonDetector.swap(labelList, 0, i);
                continue;
            }
            if (!label.equalsIgnoreCase(OK_LABEL) || i >= n - 1) continue;
            ButtonDetector.swap(labelList, n - 1, i);
        }
    }

    private static void swap(List<String> strings, int i, int j) {
        if (i != j) {
            String temp = strings.get(i);
            strings.set(i, strings.get(j));
            strings.set(j, temp);
        }
    }

    private static String describeButtons(List<String> labelList) {
        StringBuilder sb = new StringBuilder(80);
        for (String label : labelList) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(label);
        }
        return sb.toString();
    }

    private List<String> getLabelList(List<Element> views) {
        ArrayList<String> labels = new ArrayList<String>();
        if (this.mIgnore == null) {
            this.mIgnore = new HashSet<Element>();
        }
        for (Element view : views) {
            if (!view.getTagName().equals("Button")) continue;
            String text = view.getAttributeNS("http://schemas.android.com/apk/res/android", "text");
            String label = this.getLabel(text);
            labels.add(label);
            this.mIgnore.add(view);
        }
        return labels;
    }

    private String getLabel(String key) {
        String label = null;
        if (key.startsWith("@android:string/")) {
            if (key.equals(ANDROID_OK_RESOURCE)) {
                label = OK_LABEL;
            } else if (key.equals(ANDROID_CANCEL_RESOURCE)) {
                label = CANCEL_LABEL;
            }
        } else if (this.mKeyToLabel != null && key.startsWith("@string/")) {
            label = this.mKeyToLabel.get(key.substring("@string/".length()));
        }
        if (label == null) {
            label = key;
        }
        if (label.indexOf(32) != -1 && label.indexOf(34) == -1) {
            label = '\"' + label + '\"';
        }
        return label;
    }

    private static boolean isWrongCancelPosition(Element element) {
        return ButtonDetector.isWrongPosition(element, true);
    }

    private static boolean isWrongOkPosition(Element element) {
        return ButtonDetector.isWrongPosition(element, false);
    }

    private static boolean isInButtonBar(Element element) {
        assert (element.getTagName().equals("Button")) : element.getTagName();
        Node parentNode = element.getParentNode();
        if (parentNode.getNodeType() != 1) {
            return false;
        }
        Element parent = (Element)parentNode;
        String style = parent.getAttribute("style");
        if (style != null && style.contains("buttonBarStyle")) {
            return true;
        }
        if (Lint.getChildCount(parent) < 2) {
            return false;
        }
        String layout = parent.getTagName();
        if (layout.equals("LinearLayout") || layout.equals("TableRow")) {
            String orientation = parent.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation");
            if ("vertical".equals(orientation)) {
                return false;
            }
        } else {
            return false;
        }
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || "Button".equals(n.getNodeName())) continue;
            return false;
        }
        return true;
    }

    private LintFix createBorderlessFix(XmlContext context2, Element element) {
        ArrayList<LintFix> fixes = new ArrayList<LintFix>();
        Element parent = (Element)element.getParentNode();
        String style = parent.getAttribute("style");
        if (style.isEmpty()) {
            fixes.add(this.fix().set(null, "style", "?android:attr/buttonBarStyle").range(context2.getLocation(parent)).build());
        }
        for (Element button : Lint.getChildren(parent)) {
            if (button.hasAttribute("style")) continue;
            fixes.add(this.fix().set(null, "style", "?android:attr/buttonBarButtonStyle").range(context2.getLocation(button)).build());
        }
        return this.fix().name("Make borderless").composite(fixes.toArray(new LintFix[0]));
    }

    private static boolean isWrongPosition(Element element, boolean isCancel) {
        Node parentNode = element.getParentNode();
        if (parentNode.getNodeType() != 1) {
            return false;
        }
        Element parent = (Element)parentNode;
        if (Lint.getChildCount(parent) < 2) {
            return false;
        }
        String layout = parent.getTagName();
        if (layout.equals("LinearLayout") || layout.equals("TableRow")) {
            String orientation = parent.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation");
            if ("vertical".equals(orientation)) {
                return false;
            }
            if (isCancel) {
                for (Node n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (n.getNodeType() != 1) continue;
                    return true;
                }
            } else {
                for (Node n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (n.getNodeType() != 1) continue;
                    return true;
                }
            }
            return false;
        }
        if (layout.equals("RelativeLayout") || layout.equals("android.support.percent.PercentRelativeLayout")) {
            if (isCancel) {
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_toRightOf") && ButtonDetector.isButtonId(parent, element.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_toRightOf"))) {
                    return true;
                }
                if (ButtonDetector.isTrue(element, "layout_alignParentRight") && !ButtonDetector.isTrue(element, "layout_alignParentLeft")) {
                    return true;
                }
            } else {
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_toLeftOf") && ButtonDetector.isButtonId(parent, element.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_toRightOf"))) {
                    return true;
                }
                if (ButtonDetector.isTrue(element, "layout_alignParentLeft") && !ButtonDetector.isTrue(element, "layout_alignParentRight")) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isTrue(Element element, String attribute) {
        return "true".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", attribute));
    }

    private static boolean isButtonId(Element parent, String targetId) {
        for (Element child : XmlUtils.getSubTags((Node)parent)) {
            String id = child.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (!Lint.idReferencesMatch(id, targetId)) continue;
            return child.getTagName().equals("Button");
        }
        return false;
    }
}

