/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.ModulePath;

public class CompilationPaths {
    private final Collection<File> myPlatformClasspath;
    private final Collection<File> myClasspath;
    private final Collection<File> myUpgradeModulePath;
    private final ModulePath myModulePath;
    private final Collection<File> mySourcePath;

    public CompilationPaths(Collection<? extends File> platformClasspath, Collection<? extends File> classpath, Collection<? extends File> upgradeModulePath, ModulePath modulePath, Collection<? extends File> sourcePath) {
        this.myPlatformClasspath = CompilationPaths.constCollection(platformClasspath);
        this.myClasspath = CompilationPaths.constCollection(classpath);
        this.myUpgradeModulePath = CompilationPaths.constCollection(upgradeModulePath);
        this.myModulePath = modulePath;
        this.mySourcePath = CompilationPaths.constCollection(sourcePath);
    }

    private static <T> Collection<T> constCollection(Collection<? extends T> col) {
        return col == null || col.isEmpty() ? Collections.emptyList() : Collections.unmodifiableCollection(col);
    }

    @NotNull
    public Collection<File> getPlatformClasspath() {
        return this.myPlatformClasspath;
    }

    @NotNull
    public Collection<File> getClasspath() {
        return this.myClasspath;
    }

    @NotNull
    public Collection<File> getUpgradeModulePath() {
        return this.myUpgradeModulePath;
    }

    @NotNull
    public ModulePath getModulePath() {
        return this.myModulePath;
    }

    @NotNull
    public Collection<File> getSourcePath() {
        return this.mySourcePath;
    }

    public static CompilationPaths create(@Nullable Collection<? extends File> platformCp, @Nullable Collection<? extends File> cp, @Nullable Collection<? extends File> upgradeModCp, @NotNull ModulePath modulePath, @Nullable Collection<? extends File> sourcePath) {
        return new CompilationPaths(platformCp, cp, upgradeModCp, modulePath, sourcePath);
    }
}

