/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.util.PathUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;

public class BuildDataPathsImpl
implements BuildDataPaths {
    private final File myDataStorageRoot;

    public BuildDataPathsImpl(File dataStorageRoot) {
        this.myDataStorageRoot = dataStorageRoot;
    }

    @Override
    public File getDataStorageRoot() {
        return this.myDataStorageRoot;
    }

    @Override
    public File getTargetsDataRoot() {
        return new File(this.myDataStorageRoot, "targets");
    }

    @Override
    public File getTargetTypeDataRoot(BuildTargetType<?> targetType) {
        return new File(this.getTargetsDataRoot(), targetType.getTypeId());
    }

    @Override
    public File getTargetDataRoot(BuildTarget<?> target) {
        BuildTargetType<BuildTarget<?>> targetType = target.getTargetType();
        String targetId = target.getId();
        return this.getTargetDataRoot(targetType, targetId);
    }

    @Override
    @NotNull
    public File getTargetDataRoot(@NotNull BuildTargetType<?> targetType, @NotNull String targetId) {
        return new File(this.getTargetTypeDataRoot(targetType), PathUtilRt.suggestFileName((String)(targetId + "_" + Integer.toHexString(targetId.hashCode())), (boolean)true, (boolean)false));
    }
}

