/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"findKotlinRuntimeLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "module", "Lcom/intellij/openapi/module/Module;", "predicate", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "", "isKotlinJavaRuntime", "library", "isKotlinJsRuntime", "project", "isKotlinRuntime", "isRuntimeOutdated", "libraryVersion", "", "runtimeVersion", "kotlin.jvm"})
public final class OutdatedKotlinRuntimeCheckerKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Library findKotlinRuntimeLibrary(@NotNull Module module, @NotNull Function2<? super Library, ? super Project, Boolean> predicate) {
        Object v4;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(module).orderEntries");
            OrderEntry[] $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            OrderEntry[] orderEntryArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List orderEntries = (List)destination$iv$iv;
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)orderEntries), (Function1)findKotlinRuntimeLibrary.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Library it = (Library)element$iv;
                boolean bl = false;
                Library library2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"it");
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                if (!((Boolean)predicate.invoke((Object)library2, (Object)project)).booleanValue()) continue;
                v4 = element$iv;
                break block2;
            }
            v4 = null;
        }
        return v4;
    }

    public static /* synthetic */ Library findKotlinRuntimeLibrary$default(Module module, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = findKotlinRuntimeLibrary.1.INSTANCE;
        }
        return OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary(module, (Function2<? super Library, ? super Project, Boolean>)function2);
    }

    private static final boolean isKotlinRuntime(Library library2, Project project) {
        return OutdatedKotlinRuntimeCheckerKt.isKotlinJavaRuntime(library2) || OutdatedKotlinRuntimeCheckerKt.isKotlinJsRuntime(library2, project);
    }

    private static final boolean isKotlinJavaRuntime(Library library2) {
        Object[] objectArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        return JavaRuntimeDetectionUtil.getRuntimeJar((List)ArraysKt.asList((Object[])objectArray)) != null;
    }

    private static final boolean isKotlinJsRuntime(Library library2, Project project) {
        return JsLibraryStdDetectionUtil.hasJsStdlibJar$default((JsLibraryStdDetectionUtil)JsLibraryStdDetectionUtil.INSTANCE, (Library)library2, (Project)project, (boolean)false, (int)4, null);
    }

    public static final boolean isRuntimeOutdated(@Nullable String libraryVersion, @NotNull String runtimeVersion) {
        Intrinsics.checkNotNullParameter((Object)runtimeVersion, (String)"runtimeVersion");
        return libraryVersion == null || StringsKt.startsWith$default((String)libraryVersion, (String)"internal-", (boolean)false, (int)2, null) != StringsKt.startsWith$default((String)runtimeVersion, (String)"internal-", (boolean)false, (int)2, null) || VersionComparatorUtil.compare((String)StringsKt.substringBefore$default((String)runtimeVersion, (String)"-release-", null, (int)2, null), (String)libraryVersion) > 0;
    }

    public static final /* synthetic */ boolean access$isKotlinRuntime(Library library2, Project project) {
        return OutdatedKotlinRuntimeCheckerKt.isKotlinRuntime(library2, project);
    }
}

