/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinJVMRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"askUpdateRuntime", "", "module", "Lcom/intellij/openapi/module/Module;", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "project", "Lcom/intellij/openapi/project/Project;", "librariesToUpdate", "", "Lcom/intellij/openapi/roots/libraries/Library;", "checkUpdateRuntime", "kotlin.jvm"})
public final class EnableUnsupportedFeatureFixKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean checkUpdateRuntime(@NotNull Project project, @NotNull ApiVersion requiredVersion) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Iterable $this$filter$iv = ProjectStructureUtilKt.allModules((Project)project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApiVersion parsedModuleRuntimeVersion;
            ApiVersion apiVersion;
            Module module = (Module)element$iv$iv;
            boolean bl = false;
            Module module2 = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            if (KotlinVersionInfoProviderKt.getRuntimeLibraryVersion((Module)module2) != null) {
                String string;
                boolean bl2 = false;
                boolean bl3 = false;
                String version = string;
                boolean bl4 = false;
                apiVersion = ApiVersion.Companion.parse(StringsKt.substringBefore$default((String)version, (String)"-", null, (int)2, null));
            } else {
                apiVersion = null;
            }
            if (!((parsedModuleRuntimeVersion = apiVersion) != null && parsedModuleRuntimeVersion.compareTo(requiredVersion) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modulesWithOutdatedRuntime = (List)destination$iv$iv;
        $this$filter$iv = modulesWithOutdatedRuntime;
        $i$f$filter = false;
        if (!$this$filter$iv.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$filter$iv = modulesWithOutdatedRuntime;
            ApiVersion apiVersion = requiredVersion;
            Project project2 = project;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Library library2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Module it = (Module)element$iv$iv;
                boolean bl5 = false;
                Module module = it;
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"it");
                if (OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary$default(module, null, 2, null) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                Library it$iv$iv = library2;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            if (!EnableUnsupportedFeatureFixKt.askUpdateRuntime(project2, apiVersion, list)) {
                return false;
            }
        }
        return true;
    }

    public static final boolean askUpdateRuntime(@NotNull Project project, @NotNull ApiVersion requiredVersion, @NotNull List<? extends Library> librariesToUpdate) {
        int rc;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Intrinsics.checkNotNullParameter(librariesToUpdate, (String)"librariesToUpdate");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode() && (rc = Messages.showOkCancelDialog((Project)project, (String)KotlinJvmBundle.message("this.language.feature.requires.version.0.or.later.of.the.kotlin.runtime.library.would.you.like.to.update.the.runtime.library.in.your.project", requiredVersion), (String)KotlinJvmBundle.message("update.runtime.library", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return false;
        }
        KotlinJVMRuntimeLibraryUtilKt.updateLibraries(project, (Collection<? extends Library>)librariesToUpdate);
        return true;
    }

    public static final boolean askUpdateRuntime(@NotNull Module module, @NotNull ApiVersion requiredVersion) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Library library2 = OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary$default(module, null, 2, null);
        if (library2 == null) {
            return true;
        }
        Library library3 = library2;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        return EnableUnsupportedFeatureFixKt.askUpdateRuntime(project, requiredVersion, CollectionsKt.listOf((Object)library3));
    }
}

