/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.application.Topics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManagerKt;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.cloneDialog.BaseCloneDialogExtensionComponent;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionKt;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogLoginPanel;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0014J\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J \u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0014J\u0012\u0010\u0012\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent;", "Lorg/jetbrains/plugins/github/ui/cloneDialog/BaseCloneDialogExtensionComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "accountRemoved", "", "removedAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "createAccountMenuLoginActions", "", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem$Action;", "account", "createLoginAction", "createLoginPanel", "Ljavax/swing/JComponent;", "cancelHandler", "Lkotlin/Function0;", "createLoginWithTokenAction", "getAccounts", "getLoginPanel", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogLoginPanel;", "tokenChanged", "intellij.vcs.github"})
final class GHCloneDialogExtensionComponent
extends BaseCloneDialogExtensionComponent {
    @Override
    @NotNull
    protected Collection<GithubAccount> getAccounts() {
        return GHCloneDialogExtensionKt.access$getGHAccounts();
    }

    @Override
    public void accountRemoved(@NotNull GithubAccount removedAccount) {
        if (GithubAccountManagerKt.isGHAccount(removedAccount)) {
            super.accountRemoved(removedAccount);
        }
    }

    @Override
    public void tokenChanged(@NotNull GithubAccount account) {
        if (GithubAccountManagerKt.isGHAccount(account)) {
            super.tokenChanged(account);
        }
    }

    @Override
    @NotNull
    protected JComponent createLoginPanel(@Nullable GithubAccount account, @NotNull Function0<Unit> cancelHandler) {
        GHCloneDialogLoginPanel gHCloneDialogLoginPanel = new GHCloneDialogLoginPanel(account);
        boolean bl = false;
        boolean bl2 = false;
        GHCloneDialogLoginPanel $this$apply = gHCloneDialogLoginPanel;
        boolean bl3 = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)$this$apply);
        Function0<Unit> chooseLoginUiHandler2 = new Function0<Unit>($this$apply){
            final /* synthetic */ GHCloneDialogLoginPanel $this_apply;

            public final void invoke() {
                this.$this_apply.setChooseLoginUi();
            }
            {
                this.$this_apply = gHCloneDialogLoginPanel;
                super(0);
            }
        };
        $this$apply.getLoginPanel().setCancelHandler(this.getAccounts().isEmpty() ? chooseLoginUiHandler2 : cancelHandler);
        return (JComponent)((Object)gHCloneDialogLoginPanel);
    }

    @Override
    @NotNull
    protected Collection<AccountMenuItem.Action> createAccountMenuLoginActions(@Nullable GithubAccount account) {
        return CollectionsKt.listOf((Object[])new AccountMenuItem.Action[]{this.createLoginAction(account), this.createLoginWithTokenAction(account)});
    }

    private final AccountMenuItem.Action createLoginAction(GithubAccount account) {
        boolean isExistingAccount = account != null;
        return new AccountMenuItem.Action(GithubBundle.message("login.via.github.action", new Object[0]), (Function0)new Function0<Unit>(this, account){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;

            public final void invoke() {
                block0: {
                    this.this$0.switchToLogin(this.$account);
                    GHCloneDialogLoginPanel gHCloneDialogLoginPanel = GHCloneDialogExtensionComponent.access$getLoginPanel(this.this$0);
                    if (gHCloneDialogLoginPanel == null) break block0;
                    gHCloneDialogLoginPanel.setPrimaryLoginUi();
                }
            }
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                this.$account = githubAccount;
                super(0);
            }
        }, null, !isExistingAccount, 4, null);
    }

    private final AccountMenuItem.Action createLoginWithTokenAction(GithubAccount account) {
        return new AccountMenuItem.Action(GithubBundle.message("login.with.token.action", new Object[0]), (Function0)new Function0<Unit>(this, account){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;

            public final void invoke() {
                block0: {
                    this.this$0.switchToLogin(this.$account);
                    GHCloneDialogLoginPanel gHCloneDialogLoginPanel = GHCloneDialogExtensionComponent.access$getLoginPanel(this.this$0);
                    if (gHCloneDialogLoginPanel == null) break block0;
                    gHCloneDialogLoginPanel.setTokenUi();
                }
            }
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                this.$account = githubAccount;
                super(0);
            }
        }, null, false, 12, null);
    }

    private final GHCloneDialogLoginPanel getLoginPanel() {
        JComponent jComponent = this.getContent();
        if (!(jComponent instanceof GHCloneDialogLoginPanel)) {
            jComponent = null;
        }
        return (GHCloneDialogLoginPanel)((Object)jComponent);
    }

    public GHCloneDialogExtensionComponent(@NotNull Project project) {
        super(project, GithubAuthenticationManager.Companion.getInstance(), GithubApiRequestExecutorManager.Companion.getInstance(), GithubAccountInformationProvider.Companion.getInstance(), CachingGithubUserAvatarLoader.Companion.getInstance(), GithubImageResizer.Companion.getInstance());
        Topics.subscribe(GithubAccountManager.Companion.getACCOUNT_REMOVED_TOPIC(), (Disposable)((Disposable)this), (Object)this);
        Topics.subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Disposable)((Disposable)this), (Object)this);
        this.setup();
    }

    public static final /* synthetic */ GHCloneDialogLoginPanel access$getLoginPanel(GHCloneDialogExtensionComponent $this) {
        return $this.getLoginPanel();
    }
}

