/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.provider;

import com.google.common.graph.Graph;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesService;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J\u001e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u001b\u0010\u001e\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u001f\u00a2\u0006\u0002\b H\u0016J\u0013\u0010!\u001a\r\u0012\u0004\u0012\u00020\u00100\u001f\u00a2\u0006\u0002\b H\u0016J\u001b\u0010\"\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00130\u00130\u001f\u00a2\u0006\u0002\b H\u0016J\u0014\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0$0\u001fH\u0016J\b\u0010%\u001a\u00020\u0010H\u0016R&\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00130\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRChangesDataProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRChangesDataProvider;", "Lcom/intellij/openapi/Disposable;", "changesService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "detailsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProviderImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProviderImpl;)V", "apiCommitsRequestValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "Lcom/google/common/graph/Graph;", "baseBranchFetchRequestValue", "", "kotlin.jvm.PlatformType", "changesProviderValue", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProvider;", "headBranchFetchRequestValue", "lastKnownBaseSha", "", "lastKnownHeadSha", "addChangesListener", "disposable", "listener", "Lkotlin/Function0;", "addCommitsListener", "dispose", "fetchBaseBranch", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/annotations/NotNull;", "fetchHeadBranch", "loadChanges", "loadCommitsFromApi", "", "reloadChanges", "intellij.vcs.github"})
public final class GHPRChangesDataProviderImpl
implements GHPRChangesDataProvider,
Disposable {
    private String lastKnownBaseSha;
    private String lastKnownHeadSha;
    private final LazyCancellableBackgroundProcessValue<Unit> baseBranchFetchRequestValue;
    private final LazyCancellableBackgroundProcessValue<Unit> headBranchFetchRequestValue;
    private final LazyCancellableBackgroundProcessValue<Pair<GHCommit, Graph<GHCommit>>> apiCommitsRequestValue;
    private final LazyCancellableBackgroundProcessValue<GHPRChangesProvider> changesProviderValue;
    private final GHPRChangesService changesService;
    private final GHPRIdentifier pullRequestId;
    private final GHPRDetailsDataProviderImpl detailsData;

    @Override
    @NotNull
    public CompletableFuture<GHPRChangesProvider> loadChanges() {
        return (CompletableFuture)this.changesProviderValue.getValue();
    }

    @Override
    public void reloadChanges() {
        this.baseBranchFetchRequestValue.drop();
        this.headBranchFetchRequestValue.drop();
        this.apiCommitsRequestValue.drop();
        this.changesProviderValue.drop();
    }

    @Override
    public void addChangesListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        this.changesProviderValue.addDropEventListener(disposable, listener2);
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHCommit>> loadCommitsFromApi() {
        return ((CompletableFuture)this.apiCommitsRequestValue.getValue()).thenApply((Function)loadCommitsFromApi.1.INSTANCE);
    }

    @Override
    public void addCommitsListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        this.apiCommitsRequestValue.addDropEventListener(disposable, listener2);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> fetchBaseBranch() {
        return (CompletableFuture)this.baseBranchFetchRequestValue.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> fetchHeadBranch() {
        return (CompletableFuture)this.headBranchFetchRequestValue.getValue();
    }

    public void dispose() {
    }

    public GHPRChangesDataProviderImpl(@NotNull GHPRChangesService changesService, @NotNull GHPRIdentifier pullRequestId, @NotNull GHPRDetailsDataProviderImpl detailsData) {
        this.changesService = changesService;
        this.pullRequestId = pullRequestId;
        this.detailsData = detailsData;
        this.detailsData.addDetailsLoadedListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                GHPullRequest gHPullRequest = detailsData.getLoadedDetails();
                if (gHPullRequest == null) {
                    return;
                }
                GHPullRequest details2 = gHPullRequest;
                if (lastKnownBaseSha != null && Intrinsics.areEqual((Object)lastKnownBaseSha, (Object)details2.getBaseRefOid()) ^ true && lastKnownHeadSha != null && Intrinsics.areEqual((Object)lastKnownHeadSha, (Object)details2.getHeadRefOid()) ^ true) {
                    this.reloadChanges();
                }
                lastKnownBaseSha = details2.getBaseRefOid();
                lastKnownHeadSha = details2.getHeadRefOid();
            }
        }));
        this.baseBranchFetchRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<Unit>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;

            @NotNull
            public final CompletableFuture<Unit> invoke(@NotNull ProgressIndicator indicator) {
                return GHPRChangesDataProviderImpl.access$getDetailsData$p(this.this$0).loadDetails().thenCompose(new Function<GHPullRequest, CompletionStage<Unit>>(this, indicator){
                    final /* synthetic */ baseBranchFetchRequestValue.1 this$0;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final CompletionStage<Unit> apply(GHPullRequest it) {
                        return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0.this$0).fetchBranch(this.$indicator, it.getBaseRefName());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$indicator = progressIndicator;
                    }
                });
            }
            {
                this.this$0 = gHPRChangesDataProviderImpl;
                super(1);
            }
        });
        this.headBranchFetchRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<Unit>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;

            @NotNull
            public final CompletableFuture<Unit> invoke(@NotNull ProgressIndicator it) {
                return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0).fetch(it, "refs/pull/" + GHPRChangesDataProviderImpl.access$getPullRequestId$p(this.this$0).getNumber() + "/head:");
            }
            {
                this.this$0 = gHPRChangesDataProviderImpl;
                super(1);
            }
        });
        this.apiCommitsRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<Pair<? extends GHCommit, ? extends Graph<GHCommit>>>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;

            @NotNull
            public final CompletableFuture<Pair<GHCommit, Graph<GHCommit>>> invoke(@NotNull ProgressIndicator it) {
                return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0).loadCommitsFromApi(it, GHPRChangesDataProviderImpl.access$getPullRequestId$p(this.this$0));
            }
            {
                this.this$0 = gHPRChangesDataProviderImpl;
                super(1);
            }
        });
        this.changesProviderValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<GHPRChangesProvider>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;

            @NotNull
            public final CompletableFuture<GHPRChangesProvider> invoke(@NotNull ProgressIndicator indicator) {
                CompletableFuture commitsRequest = (CompletableFuture)GHPRChangesDataProviderImpl.access$getApiCommitsRequestValue$p(this.this$0).getValue();
                return ((CompletableFuture)GHPRChangesDataProviderImpl.access$getDetailsData$p(this.this$0).loadDetails().thenCompose(new Function<GHPullRequest, CompletionStage<String>>(this, indicator){
                    final /* synthetic */ changesProviderValue.1 this$0;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final CompletionStage<String> apply(GHPullRequest it) {
                        return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0.this$0).loadMergeBaseOid(this.$indicator, it.getBaseRefOid(), it.getHeadRefOid());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$indicator = progressIndicator;
                    }
                })).thenCompose(new Function<String, CompletionStage<GHPRChangesProvider>>(this, commitsRequest, indicator){
                    final /* synthetic */ changesProviderValue.1 this$0;
                    final /* synthetic */ CompletableFuture $commitsRequest;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final CompletionStage<GHPRChangesProvider> apply(String mergeBase) {
                        return this.$commitsRequest.thenCompose(new Function<Pair<? extends GHCommit, ? extends Graph<GHCommit>>, CompletionStage<GHPRChangesProvider>>(this, mergeBase){
                            final /* synthetic */ changesProviderValue.2 this$0;
                            final /* synthetic */ String $mergeBase;

                            public final CompletionStage<GHPRChangesProvider> apply(Pair<GHCommit, ? extends Graph<GHCommit>> it) {
                                return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0.this$0.this$0).createChangesProvider(this.this$0.$indicator, this.$mergeBase, it);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$mergeBase = string;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$commitsRequest = completableFuture;
                        this.$indicator = progressIndicator;
                    }
                });
            }
            {
                this.this$0 = gHPRChangesDataProviderImpl;
                super(1);
            }
        });
    }

    @Override
    public void loadChanges(@NotNull Disposable disposable, @NotNull Function1<? super CompletableFuture<GHPRChangesProvider>, Unit> consumer) {
        GHPRChangesDataProvider.DefaultImpls.loadChanges(this, disposable, consumer);
    }

    @Override
    public void loadCommitsFromApi(@NotNull Disposable disposable, @NotNull Function1<? super CompletableFuture<List<GHCommit>>, Unit> consumer) {
        GHPRChangesDataProvider.DefaultImpls.loadCommitsFromApi(this, disposable, consumer);
    }

    public static final /* synthetic */ GHPRChangesService access$getChangesService$p(GHPRChangesDataProviderImpl $this) {
        return $this.changesService;
    }

    public static final /* synthetic */ GHPRIdentifier access$getPullRequestId$p(GHPRChangesDataProviderImpl $this) {
        return $this.pullRequestId;
    }

    public static final /* synthetic */ LazyCancellableBackgroundProcessValue access$getApiCommitsRequestValue$p(GHPRChangesDataProviderImpl $this) {
        return $this.apiCommitsRequestValue;
    }
}

