/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubUser {
    @NotNull
    public static final GithubUser UNKNOWN = GithubUser.createUnknownUser();
    private String login;
    private Long id;
    private String nodeId;
    private String avatarUrl;
    private String gravatarId;
    private String url;
    private String htmlUrl;
    private String type;
    private Boolean siteAdmin;

    @NotNull
    public String getNodeId() {
        return this.nodeId;
    }

    @NotNull
    public String getLogin() {
        return this.login;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @Nullable
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubUser)) {
            return false;
        }
        GithubUser user = (GithubUser)o;
        return this.id.equals(user.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @NotNull
    private static GithubUser createUnknownUser() {
        GithubUser user = new GithubUser();
        user.id = -1L;
        user.login = "ghost";
        return user;
    }
}

