/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkFileRepo", "", "url", "project", "Lcom/intellij/openapi/project/Project;", "checkUrl", "uriString", "isValidRepository", "", "file", "Ljava/nio/file/Path;", "intellij.settingsRepository"})
public interface RepositoryService {
    @Nullable
    public String checkUrl(@NotNull String var1, @Nullable Project var2);

    public boolean isValidRepository(@NotNull Path var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static String checkUrl(@NotNull RepositoryService $this, @NotNull String uriString, @Nullable Project project) {
            URIish uri = new URIish(uriString);
            boolean isFile = Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file") || uri.getScheme() == null && uri.getHost() == null;
            return isFile ? DefaultImpls.checkFileRepo($this, uriString, project) : null;
        }

        public static /* synthetic */ String checkUrl$default(RepositoryService repositoryService, String string, Project project, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkUrl");
            }
            if ((n & 2) != 0) {
                project = null;
            }
            return repositoryService.checkUrl(string, project);
        }

        private static String checkFileRepo(RepositoryService $this, String url, Project project) {
            block14: {
                String string;
                boolean bl;
                String string2;
                String suffix = "/.git";
                if (StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2, null)) {
                    string2 = url;
                    int n = 0;
                    int n2 = url.length() - suffix.length();
                    bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, n2);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = url;
                }
                Path file = Paths.get(string, new String[0]);
                if (PathKt.exists((Path)file)) {
                    if (!PathKt.isDirectory((Path)file)) {
                        return "Path is not a directory";
                    }
                    if ($this.isValidRepository(file)) {
                        return null;
                    }
                } else if (!file.isAbsolute()) {
                    return IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]);
                }
                if (!((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), (String)IcsBundleKt.icsMessage("init.dialog.message", file)).yesText("Create")).project(project)).isYes()) break block14;
                try {
                    GitExKt.createBareRepository(file);
                    string2 = null;
                }
                catch (IOException e) {
                    String string5;
                    block16: {
                        block15: {
                            string5 = e.getMessage();
                            if (string5 == null) break block15;
                            String string6 = string5;
                            bl = false;
                            boolean bl2 = false;
                            String it = string6;
                            boolean bl3 = false;
                            string5 = IcsBundleKt.icsMessage("init.failed.message", it);
                            if (string5 != null) break block16;
                        }
                        string5 = IcsBundleKt.icsMessage("init.failed.message.without.details", new Object[0]);
                    }
                    string2 = string5;
                }
                return string2;
            }
            return "";
        }
    }
}

