/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandAuthenticator;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.SocketServer;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgRemoteCommandExecutor
extends HgCommandExecutor {
    @Nullable
    private final ModalityState myState;
    final boolean myIgnoreAuthorizationRequest;

    public HgRemoteCommandExecutor(@NotNull Project project, @Nullable String destination) {
        this(project, destination, null, false);
    }

    public HgRemoteCommandExecutor(@NotNull Project project, @Nullable String destination, @Nullable ModalityState state, boolean ignoreAuthorizationRequest) {
        super(project, destination);
        this.myState = state;
        this.myIgnoreAuthorizationRequest = ignoreAuthorizationRequest;
    }

    @Override
    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments) {
        HgCommandResult result = this.executeRemoteCommandInCurrentThread(repo, operation, arguments, false);
        if (!this.myIgnoreAuthorizationRequest && HgErrorUtil.isAuthorizationError(result)) {
            if (HgErrorUtil.hasAuthorizationInDestinationPath(this.myDestination)) {
                new HgCommandResultNotifier(this.myProject).notifyError(result, HgBundle.message("hg4idea.command.executor.remote.auth.failed", new Object[0]), HgBundle.message("hg4idea.command.executor.remote.auth.failed.msg", new Object[0]));
                return null;
            }
            result = this.executeRemoteCommandInCurrentThread(repo, operation, arguments, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private HgCommandResult executeRemoteCommandInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, boolean forceAuthorization) {
        PassReceiver passReceiver = new PassReceiver(this.myProject, forceAuthorization, this.myIgnoreAuthorizationRequest, this.myState);
        SocketServer passServer = new SocketServer(passReceiver);
        try {
            int passPort = passServer.start();
            HgCommandResult result = super.executeInCurrentThread(repo, operation, this.prepareArguments(arguments, passPort));
            if (HgErrorUtil.isAuthorizationError(result)) {
                passReceiver.forgetPassword();
            }
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        catch (IOException e) {
            this.showError(e);
            LOG.info("IOException during preparing command", (Throwable)e);
            HgCommandResult hgCommandResult = null;
            return hgCommandResult;
        }
        finally {
            passServer.stop();
        }
    }

    private List<String> prepareArguments(List<String> arguments, int port) {
        ArrayList<String> cmdArguments = new ArrayList<String>();
        cmdArguments.add("--config");
        cmdArguments.add("extensions.hg4ideapromptextension=" + this.myVcs.getPromptHooksExtensionFile().getAbsolutePath());
        cmdArguments.add("--config");
        cmdArguments.add("hg4ideapass.port=" + port);
        if (arguments != null && arguments.size() != 0) {
            cmdArguments.addAll(arguments);
        }
        return cmdArguments;
    }

    @Override
    protected void logCommand(@NotNull String operation, @Nullable List<String> arguments) {
        super.logCommand(operation, null);
    }

    private static class PassReceiver
    extends SocketServer.Protocol {
        private final Project myProject;
        private HgCommandAuthenticator myAuthenticator;
        private final boolean myForceAuthorization;
        private final boolean mySilentMode;
        @Nullable
        private final ModalityState myState;

        private PassReceiver(Project project, boolean forceAuthorization, boolean silent, @Nullable ModalityState state) {
            this.myProject = project;
            this.myForceAuthorization = forceAuthorization;
            this.mySilentMode = silent;
            this.myState = state;
        }

        @Override
        public boolean handleConnection(Socket socket) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            String command = new String(PassReceiver.readDataBlock(dataInputStream), StandardCharsets.UTF_8);
            assert ("getpass".equals(command)) : "Invalid command: " + command;
            String uri = new String(PassReceiver.readDataBlock(dataInputStream), StandardCharsets.UTF_8);
            String path = new String(PassReceiver.readDataBlock(dataInputStream), StandardCharsets.UTF_8);
            HgCommandAuthenticator authenticator = new HgCommandAuthenticator(this.myForceAuthorization, this.mySilentMode);
            String proposedLogin = new String(PassReceiver.readDataBlock(dataInputStream), StandardCharsets.UTF_8);
            boolean ok = authenticator.promptForAuthentication(this.myProject, proposedLogin, uri, path, this.myState);
            if (ok) {
                this.myAuthenticator = authenticator;
                PassReceiver.sendDataBlock(out, authenticator.getUserName().getBytes(StandardCharsets.UTF_8));
                PassReceiver.sendDataBlock(out, authenticator.getPassword().getBytes(StandardCharsets.UTF_8));
            }
            return true;
        }

        public void forgetPassword() {
            if (this.myAuthenticator == null) {
                return;
            }
            this.myAuthenticator.forgetPassword();
        }
    }
}

