/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action.mq;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.action.mq.HgMqAppliedPatchAction;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQFinishFromLogAction
extends HgMqAppliedPatchAction {
    protected void actionPerformed(@NotNull HgRepository repository, @NotNull Hash commit) {
        String revision = commit.asString();
        Project project = repository.getProject();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)repository, () -> {
            HgCommandExecutor executor = new HgCommandExecutor(project);
            HgCommandResult result = executor.executeInCurrentThread(repository.getRoot(), "qfinish", Collections.singletonList("qbase:" + revision));
            if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                new HgCommandResultNotifier(project).notifyError(result, HgBundle.message("action.hg4idea.QFinish.error", new Object[0]), HgBundle.message("action.hg4idea.QFinish.error.msg", new Object[0]));
            }
            repository.update();
        });
    }
}

